/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view;

import com.kms.katalon.composer.search.action.OpenEditorAction;
import com.kms.katalon.composer.search.view.provider.SearchResultPageLabelProvider;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public class QSearchResultPage
extends FileSearchPage {
    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        if (!this.showEditor(file, offset, length)) {
            super.showMatch(match, offset, length, activate);
        }
    }

    private boolean showEditor(IFile file, int offset, int length) {
        block10: {
            ProjectEntity project;
            String fileExtension;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block9: {
                                String fileName = FilenameUtils.getBaseName((String)file.getFullPath().toString());
                                fileExtension = "." + file.getFileExtension();
                                project = ProjectController.getInstance().getCurrentProject();
                                try {
                                    if (!fileExtension.equals(".groovy")) break block9;
                                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByScriptName(fileName);
                                    if (testCase != null) {
                                        OpenEditorAction.openEditor(testCase, offset, length);
                                        return true;
                                    }
                                    break block10;
                                }
                                catch (Exception exception) {}
                            }
                            if (!fileExtension.equals(TestCaseEntity.getTestCaseFileExtension())) break block11;
                            String testCaseId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(TestCaseEntity.getTestCaseFileExtension(), "");
                            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
                            OpenEditorAction.openTestCase(testCase);
                            return true;
                        }
                        if (!fileExtension.equals(WebElementEntity.getWebElementFileExtension())) break block12;
                        String testObjectId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(WebElementEntity.getWebElementFileExtension(), "");
                        WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
                        OpenEditorAction.openTestObject(testObject);
                        return true;
                    }
                    if (!fileExtension.equals(TestSuiteEntity.getTestSuiteFileExtension())) break block13;
                    String testSuiteId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(TestSuiteEntity.getTestSuiteFileExtension(), "");
                    TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
                    OpenEditorAction.openTestSuite(testSuite);
                    return true;
                }
                if (!fileExtension.equals(DataFileEntity.getTestDataFileExtension())) break block14;
                String testDataId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(DataFileEntity.getTestDataFileExtension(), "");
                DataFileEntity testData = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
                OpenEditorAction.openTestData(testData);
                return true;
            }
            if (fileExtension.equals(ReportEntity.getReportFileExtension())) {
                String reportDisplayId = file.getParent().getProjectRelativePath().toString();
                ReportEntity testData = ReportController.getInstance().getReportEntityByDisplayId(reportDisplayId, project);
                OpenEditorAction.openReport(testData);
                return true;
            }
        }
        return false;
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new SearchResultPageLabelProvider(new FileLabelProvider((AbstractTextSearchViewPage)this, 1)));
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof IFile) {
            if (this.getDisplayedMatchCount(firstElement) == 0 && !this.showEditor((IFile)firstElement, 0, 0)) {
                super.handleOpen(event);
            }
        } else if (firstElement instanceof LineElement) {
            super.handleOpen(event);
        }
    }
}

