/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;

public class QSearchInput
extends TextSearchQueryProvider.TextSearchInput {
    private static final String[] UNQUALIFIED_RESOURCES = new String[]{".svn", "bin", "Libs", ".classpath", ".project", "GlobalVariables.glbl", "settings"};
    private String searchText;
    private boolean isCaseSensitive;
    private boolean isRegExSearch;
    private String[] fileNamePatterns;
    private IProject project;

    public QSearchInput(String searchText, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, IProject project) {
        this.isCaseSensitive = isCaseSensitive;
        this.searchText = searchText;
        this.isRegExSearch = isRegExSearch;
        this.fileNamePatterns = fileNamePatterns;
        this.project = project;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public boolean isCaseSensitiveSearch() {
        return this.isCaseSensitive;
    }

    public boolean isRegExSearch() {
        return this.isRegExSearch;
    }

    public FileTextSearchScope getScope() {
        try {
            return FileTextSearchScope.newSearchScope((IResource[])this.getValidRootResouces(), (String[])this.fileNamePatterns, (boolean)false);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private IResource[] getValidRootResouces() throws CoreException {
        ArrayList<IResource> validResources = new ArrayList<IResource>();
        IResource[] iResourceArray = this.project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resourceRoot = iResourceArray[n2];
            if (QSearchInput.isValidResourceToSearch(resourceRoot)) {
                validResources.add(resourceRoot);
            }
            ++n2;
        }
        return validResources.toArray(new IResource[validResources.size()]);
    }

    public static boolean isValidResourceToSearch(IResource resource) {
        if (!resource.exists()) {
            return false;
        }
        String[] stringArray = UNQUALIFIED_RESOURCES;
        int n = UNQUALIFIED_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String unqualifiedName = stringArray[n2];
            if (unqualifiedName.equals(resource.getName())) {
                return false;
            }
            if (resource.getFileExtension() != null && resource.getFileExtension().equals("prj")) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

