/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.requestor;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class CompletionNodeFinder
extends ClassCodeVisitorSupport {
    private Stack<ASTNode> blockStack;
    private AnnotatedNode currentDeclaration;
    private int completionOffset;
    private int completionEnd;
    private int supportingNodeEnd;
    private String completionExpression;
    private String fullCompletionExpression;
    private GroovyCompilationUnit unit;
    private ContentAssistContext context;
    private Expression lhsNode;
    private Stack<TupleExpression> argsStack;

    public CompletionNodeFinder(int completionOffset, int completionEnd, int supportingNodeEnd, String completionExpression, String fullCompletionExpression) {
        this.completionOffset = completionOffset;
        this.completionEnd = completionEnd;
        this.supportingNodeEnd = supportingNodeEnd;
        this.completionExpression = completionExpression;
        this.fullCompletionExpression = fullCompletionExpression;
        this.blockStack = new Stack();
        this.argsStack = new Stack();
    }

    public ContentAssistContext findContentAssistContext(GroovyCompilationUnit unit) {
        try {
            this.unit = unit;
            ModuleNode node = unit.getModuleNode();
            this.visitImports(node);
            ClassNode script = null;
            for (ClassNode clazz : node.getClasses()) {
                if (clazz.isScript()) {
                    script = clazz;
                    continue;
                }
                this.visitClass(clazz);
            }
            if (script != null) {
                this.visitClass(script);
            }
        }
        catch (VisitCompleteException visitCompleteException) {}
        return this.context;
    }

    public void visitImports(ModuleNode node) {
        PackageNode packageNode = node.getPackage();
        if (packageNode != null && this.doTest((ASTNode)packageNode)) {
            this.currentDeclaration = packageNode;
            this.createContext(null, (ASTNode)packageNode, ContentAssistLocation.PACKAGE);
        }
        ImportNodeCompatibilityWrapper wrapper = new ImportNodeCompatibilityWrapper(node);
        for (ImportNode importNode : wrapper.getAllImportNodes()) {
            this.visitAnnotations((AnnotatedNode)importNode);
            if (importNode.getType() == null || !this.doTest((ASTNode)importNode.getType())) continue;
            this.currentDeclaration = importNode;
            this.createContext(null, (ASTNode)importNode, ContentAssistLocation.IMPORT);
        }
    }

    public void visitClass(ClassNode node) {
        MethodNode run;
        ConstructorNode init;
        Iterator innerClasses;
        if (!this.doTest((ASTNode)node) && !node.isScript()) {
            return;
        }
        this.currentDeclaration = node;
        this.blockStack.push((ASTNode)node);
        this.visitAnnotations((AnnotatedNode)node);
        this.blockStack.pop();
        ClassNode supr = node.getUnresolvedSuperClass();
        if (supr != null && supr.getEnd() > 0 && this.doTest((ASTNode)supr)) {
            this.createContext(null, (ASTNode)node, ContentAssistLocation.EXTENDS);
        }
        if ((innerClasses = node.getInnerClasses()) != null) {
            while (innerClasses.hasNext()) {
                InnerClassNode inner = (InnerClassNode)innerClasses.next();
                if (inner.isSynthetic() && !(inner instanceof GeneratedClosure)) continue;
                this.visitClass((ClassNode)inner);
            }
        }
        if (node.getInterfaces() != null) {
            ClassNode[] classNodeArray = node.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode interf = classNodeArray[n2];
                if (this.doTest((ASTNode)interf)) {
                    this.createContext(null, (ASTNode)node, ContentAssistLocation.IMPLEMENTS);
                }
                ++n2;
            }
        }
        for (FieldNode fn : node.getFields()) {
            this.visitField(fn);
        }
        for (ConstructorNode cn : node.getDeclaredConstructors()) {
            this.visitConstructor(cn);
        }
        for (MethodNode mn : node.getMethods()) {
            this.visitMethod(mn);
        }
        MethodNode clinit = node.getMethod("<clinit>", new Parameter[0]);
        if (clinit != null && clinit.getCode() instanceof BlockStatement) {
            this.blockStack.push((ASTNode)clinit.getCode());
            for (Statement element : ((BlockStatement)clinit.getCode()).getStatements()) {
                element.visit((GroovyCodeVisitor)this);
            }
            this.blockStack.pop();
        }
        if ((init = this.findDefaultConstructor(node)) != null) {
            Statement statement = init.getCode();
            if (statement instanceof ExpressionStatement) {
                ((ExpressionStatement)statement).visit((GroovyCodeVisitor)this);
            } else {
                this.blockStack.push((ASTNode)init.getCode());
                for (Statement element : ((BlockStatement)init.getCode()).getStatements()) {
                    element.visit((GroovyCodeVisitor)this);
                }
                this.blockStack.pop();
            }
        }
        this.currentDeclaration = node;
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit((GroovyCodeVisitor)this);
        }
        if (node.isScript() && (run = node.getMethod("run", Parameter.EMPTY_ARRAY)) != null && run.getDeclaringClass().equals((Object)node)) {
            this.internalVisitConstructorOrMethod(run);
        }
        this.createContext(null, (ASTNode)node, node.isScript() ? ContentAssistLocation.SCRIPT : ContentAssistLocation.CLASS_BODY);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        if (!this.isRunMethod(node)) {
            this.internalVisitConstructorOrMethod(node);
        }
    }

    protected void visitAnnotation(AnnotationNode node) {
        super.visitAnnotation(node);
        if (this.doTest((ASTNode)node.getClassNode())) {
            this.createContext((ASTNode)node, (ASTNode)this.currentDeclaration, ContentAssistLocation.ANNOTATION);
        }
    }

    private boolean isRunMethod(MethodNode node) {
        return node.getDeclaringClass() != null && node.getDeclaringClass().isScript() && node.getName().equals("run") && (node.getParameters() == null || node.getParameters().length == 0) && node.getReturnType() != null && node.getReturnType().getName().equals("java.lang.Object");
    }

    private void internalVisitConstructorOrMethod(MethodNode node) {
        if (!this.isRunMethod(node)) {
            if (!this.doTest((ASTNode)node)) {
                return;
            }
            this.currentDeclaration = node;
        }
        this.internalVisitParameters(node.getParameters(), (ASTNode)node);
        if (node.getExceptions() != null) {
            ClassNode[] classNodeArray = node.getExceptions();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode excep = classNodeArray[n2];
                if (this.doTest((ASTNode)excep)) {
                    this.createContext(null, (ASTNode)node, ContentAssistLocation.EXCEPTIONS);
                }
                ++n2;
            }
        }
        this.blockStack.push((ASTNode)node);
        this.visitAnnotations((AnnotatedNode)node);
        this.blockStack.pop();
        Statement code = node.getCode();
        if (code != null) {
            this.visitClassCodeContainer(code);
            if (this.completionOffset < code.getStart() && !this.isRunMethod(node)) {
                this.createContext(null, (ASTNode)node, ContentAssistLocation.PARAMETER);
            }
            code.setStart(node.getStart());
            code.setEnd(node.getEnd());
            this.createContext((ASTNode)code, (ASTNode)code, this.expressionScriptOrStatement(node));
        }
    }

    private ContentAssistLocation expressionScriptOrStatement(MethodNode node) {
        return this.isRunMethod(node) ? this.expressionOrScript() : this.expressionOrStatement();
    }

    private ContentAssistLocation expressionOrScript() {
        return this.supportingNodeEnd == -1 ? ContentAssistLocation.SCRIPT : ContentAssistLocation.EXPRESSION;
    }

    private ContentAssistLocation expressionOrStatement() {
        return this.supportingNodeEnd == -1 ? ContentAssistLocation.STATEMENT : ContentAssistLocation.EXPRESSION;
    }

    public void visitBlockStatement(BlockStatement node) {
        this.blockStack.push((ASTNode)node);
        super.visitBlockStatement(node);
        if (this.doTest((ASTNode)node)) {
            this.createContext(this.blockStack.peek(), (ASTNode)node, this.expressionOrStatement());
        }
        this.blockStack.pop();
    }

    protected void visitStatement(Statement statement) {
        if (this.doTest((ASTNode)statement) || statement.getStart() <= 0 && statement.getEnd() <= 0) {
            super.visitStatement(statement);
        }
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        super.visitExpressionStatement(statement);
        if (this.doTest((ASTNode)statement)) {
            Expression expression = statement.getExpression();
            int exprEnd = expression.getEnd();
            int stateEnd = statement.getEnd();
            if ((this.completionOffset <= stateEnd && this.completionOffset > exprEnd || this.supportingNodeEnd <= stateEnd && this.supportingNodeEnd > exprEnd) && (expression instanceof VariableExpression || expression instanceof ConstantExpression || expression instanceof PropertyExpression)) {
                if (expression instanceof PropertyExpression) {
                    expression = this.getRightMost(expression);
                }
                if (expression != null) {
                    this.createContextForCallContext(expression, (AnnotatedNode)expression, expression.getText());
                }
            }
        }
    }

    private Expression getRightMost(Expression expression) {
        if (expression instanceof VariableExpression || expression instanceof ConstantExpression) {
            return expression;
        }
        if (expression instanceof PropertyExpression) {
            return this.getRightMost(((PropertyExpression)expression).getProperty());
        }
        if (expression instanceof BinaryExpression) {
            return this.getRightMost(((BinaryExpression)expression).getRightExpression());
        }
        return null;
    }

    public void visitField(FieldNode node) {
        if (!this.doTest((ASTNode)node)) {
            return;
        }
        this.currentDeclaration = node;
        ClassNode type = node.getType();
        if (type != null && this.doTest((ASTNode)type)) {
            this.createContext(null, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
        }
        this.blockStack.push((ASTNode)node);
        super.visitField(node);
        this.blockStack.pop();
        if (node.isStatic() && node.getEnd() > node.getNameEnd() + 1) {
            return;
        }
        this.currentDeclaration = node.getDeclaringClass();
        this.createContext((ASTNode)node, (ASTNode)node.getDeclaringClass(), ContentAssistLocation.CLASS_BODY);
    }

    public void visitVariableExpression(VariableExpression expression) {
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitVariableExpression(expression);
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitFieldExpression(expression);
    }

    public void visitClassExpression(ClassExpression expression) {
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitClassExpression(expression);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitConstantExpression(expression);
    }

    public void visitCastExpression(CastExpression node) {
        if (this.doTest((ASTNode)node.getType())) {
            this.createContext((ASTNode)node.getType(), this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitCastExpression(node);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        ClassNode type = expression.getLeftExpression().getType();
        if (this.doTest((ASTNode)type)) {
            this.createContext((ASTNode)type, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitDeclarationExpression(expression);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.internalVisitParameter(statement.getVariable(), (ASTNode)statement);
        super.visitCatchStatement(statement);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.internalVisitParameter(forLoop.getVariable(), (ASTNode)forLoop);
        super.visitForLoop(forLoop);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
        super.visitArrayExpression(expression);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        if (!this.doTest((ASTNode)call)) {
            return;
        }
        if (call.getOwnerType().getNameEnd() == 0 && this.doTest((ASTNode)call.getOwnerType())) {
            this.createContext((ASTNode)call.getOwnerType(), this.blockStack.peek(), this.expressionOrStatement());
        }
        this.internalVisitCallArguments(call.getArguments());
        if (this.doTest((ASTNode)call)) {
            this.createContext((ASTNode)call, this.blockStack.peek(), this.expressionOrStatement());
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.blockStack.push((ASTNode)expression);
        this.internalVisitParameters(expression.getParameters(), (ASTNode)expression.getCode());
        super.visitClosureExpression(expression);
        this.blockStack.pop();
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)expression.getCode(), this.expressionOrStatement());
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getOperation().getText().equals("=")) {
            this.lhsNode = expression.getLeftExpression();
        }
        super.visitBinaryExpression(expression);
        this.lhsNode = null;
        if (expression.getOperation().getText().equals("[") && this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, this.blockStack.peek(), this.expressionOrStatement());
        }
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        if (!this.doTest((ASTNode)expression)) {
            return;
        }
        Expression objectExpression = expression.getObjectExpression();
        Expression propertyExpression = expression.getProperty();
        if (this.supportingNodeEnd >= 0 && this.supportingNodeEnd < propertyExpression.getStart()) {
            this.createContext((ASTNode)objectExpression, this.blockStack.peek(), ContentAssistLocation.EXPRESSION);
        }
        this.checkForCommandExpression(objectExpression, propertyExpression);
        super.visitPropertyExpression(expression);
    }

    void checkForCommandExpression(Expression leftExpression, Expression rightExpression) {
        Expression leftMost = this.leftMost(rightExpression);
        if (this.methodCallWithOneArgument(leftExpression) && leftMost instanceof ConstantExpression && this.doTest((ASTNode)leftMost)) {
            this.createContext((ASTNode)leftExpression, this.blockStack.peek(), ContentAssistLocation.EXPRESSION);
        }
    }

    boolean methodCallWithOneArgument(Expression objectExpression) {
        if (objectExpression instanceof MethodCallExpression) {
            Expression arguments = ((MethodCallExpression)objectExpression).getArguments();
            return arguments instanceof TupleExpression && ((TupleExpression)arguments).getExpressions() != null && ((TupleExpression)arguments).getExpressions().size() > 0;
        }
        return false;
    }

    private Expression leftMost(Expression expr) {
        if (expr instanceof ConstantExpression) {
            return expr;
        }
        if (expr instanceof PropertyExpression) {
            return this.leftMost(((PropertyExpression)expr).getObjectExpression());
        }
        if (expr instanceof MethodCallExpression) {
            return this.leftMost(((MethodCallExpression)expr).getObjectExpression());
        }
        if (expr instanceof BinaryExpression) {
            return this.leftMost(((BinaryExpression)expr).getLeftExpression());
        }
        return null;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (!this.doTest((ASTNode)call)) {
            return;
        }
        Expression objectExpression = call.getObjectExpression();
        Expression methodExpression = call.getMethod();
        Expression arguments = call.getArguments();
        this.checkForCommandExpression(objectExpression, methodExpression);
        this.checkForAfterClosingParen((AnnotatedNode)methodExpression, arguments);
        objectExpression.visit((GroovyCodeVisitor)this);
        if (this.supportingNodeEnd >= 0 && this.supportingNodeEnd < methodExpression.getStart()) {
            this.createContext((ASTNode)objectExpression, this.blockStack.peek(), ContentAssistLocation.EXPRESSION);
        }
        methodExpression.visit((GroovyCodeVisitor)this);
        this.internalVisitCallArguments(arguments);
        this.createContextForCallContext((Expression)call, (AnnotatedNode)methodExpression, methodExpression.getText());
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (!this.doTest((ASTNode)call)) {
            return;
        }
        Expression arguments = call.getArguments();
        ClassNode constructorType = call.getType();
        this.checkForAfterClosingParen((AnnotatedNode)call, arguments);
        if (this.doTest((ASTNode)constructorType)) {
            this.createContext((ASTNode)constructorType, this.blockStack.peek(), ContentAssistLocation.CONSTRUCTOR);
        }
        this.internalVisitCallArguments(arguments);
        String constructorName = constructorType.getNameWithoutPackage();
        if (constructorName.length() < constructorType.getLength()) {
            constructorName = constructorType.getName();
        }
        this.fullCompletionExpression = "new " + constructorName;
        this.createContextForCallContext((Expression)call, (AnnotatedNode)constructorType, constructorName);
    }

    private void checkForAfterClosingParen(AnnotatedNode contextTarget, Expression arguments) {
        boolean shouldLookAtArguments;
        int lastArgEnd = this.findLastArgumentEnd(arguments);
        int start = arguments.getStart();
        if (start == 0 && arguments instanceof TupleExpression && ((TupleExpression)arguments).getExpressions().size() > 0) {
            start = ((TupleExpression)arguments).getExpression(0).getStart();
        }
        if (start == 0 && lastArgEnd == 0) {
            return;
        }
        boolean bl = shouldLookAtArguments = lastArgEnd != start || this.completionOffset != start;
        if (shouldLookAtArguments && this.after(lastArgEnd)) {
            this.createContext((ASTNode)contextTarget, this.blockStack.peek(), this.expressionOrStatement());
        }
    }

    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        super.visitArgumentlistExpression(ale);
    }

    public void visitListExpression(ListExpression expression) {
        super.visitListExpression(expression);
        if (this.doTest((ASTNode)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)this.currentDeclaration, ContentAssistLocation.EXPRESSION);
        }
    }

    public void visitMapExpression(MapExpression expression) {
        super.visitMapExpression(expression);
        if (this.doTest((ASTNode)expression) && !this.isArgument((Expression)expression)) {
            this.createContext((ASTNode)expression, (ASTNode)this.currentDeclaration, ContentAssistLocation.EXPRESSION);
        }
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.visitListOfExpressions(expression.getValues());
        List strings = expression.getStrings();
        for (ConstantExpression stringExpr : strings) {
            if (!this.doTest((ASTNode)stringExpr)) continue;
            this.context = null;
            throw new VisitCompleteException();
        }
    }

    private boolean isArgument(Expression expression) {
        if (this.argsStack.isEmpty()) {
            return false;
        }
        TupleExpression args = this.argsStack.peek();
        if (args.getExpressions() != null) {
            for (Expression arg : args.getExpressions()) {
                if (arg != expression) continue;
                return true;
            }
        }
        return false;
    }

    private int findLastArgumentEnd(Expression args) {
        TupleExpression list;
        int numExprs;
        int listEnd = args.getEnd();
        int lastExpressionEnd = -1;
        if (args instanceof TupleExpression && (numExprs = (list = (TupleExpression)args).getExpressions().size()) > 0) {
            if (listEnd == 0) {
                listEnd = list.getExpression(numExprs - 1).getEnd();
            }
            Expression lastExpression = list.getExpression(numExprs - 1);
            lastExpressionEnd = lastExpression.getEnd();
        }
        return Math.max(listEnd, lastExpressionEnd);
    }

    private boolean after(int callEnd) {
        return this.supportingNodeEnd == -1 && callEnd < this.completionOffset || callEnd <= this.supportingNodeEnd;
    }

    private void internalVisitCallArguments(Expression arguments) {
        boolean doContext = false;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            for (Expression expr : tuple.getExpressions()) {
                if (expr.getStart() != this.completionOffset) continue;
                doContext = true;
                break;
            }
            this.argsStack.push(tuple);
        } else if (arguments != null && arguments.getStart() == this.completionOffset) {
            doContext = true;
        }
        if (!doContext) {
            arguments.visit((GroovyCodeVisitor)this);
        }
        if (arguments instanceof TupleExpression) {
            this.argsStack.pop();
        }
    }

    private void internalVisitParameters(Parameter[] ps, ASTNode declaringNode) {
        if (ps != null) {
            Parameter[] parameterArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                this.internalVisitParameter(p, declaringNode);
                ++n2;
            }
        }
    }

    private void internalVisitParameter(Parameter p, ASTNode declaringNode) {
        Expression initialExpression;
        ClassNode componentType;
        if (this.doTest((ASTNode)p.getType())) {
            this.createContext(null, declaringNode, ContentAssistLocation.PARAMETER);
        }
        if ((componentType = p.getType().getComponentType()) != null && this.doTest((ASTNode)componentType)) {
            this.createContext(null, declaringNode, ContentAssistLocation.PARAMETER);
        }
        if ((initialExpression = p.getInitialExpression()) != null && this.doTest((ASTNode)initialExpression)) {
            initialExpression.visit((GroovyCodeVisitor)this);
        }
        if (p.getNameStart() < this.completionOffset && p.getNameEnd() >= this.completionOffset) {
            this.createContext(null, declaringNode, ContentAssistLocation.PARAMETER);
        }
        if (this.doTest((ASTNode)p)) {
            this.createContext((ASTNode)p, declaringNode, this.expressionOrStatement());
        }
    }

    private ConstructorNode findDefaultConstructor(ClassNode node) {
        List constructors = node.getDeclaredConstructors();
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters() != null && constructor.getParameters().length != 0 || constructor.getEnd() > 0) continue;
            return constructor;
        }
        return null;
    }

    private void createContextForCallContext(Expression origExpression, AnnotatedNode methodExpr, String methodName) {
        this.context = new MethodInfoContentAssistContext(this.completionOffset, this.completionExpression, this.fullCompletionExpression, (ASTNode)origExpression, this.blockStack.peek(), this.lhsNode, this.unit, this.currentDeclaration, this.completionEnd, methodExpr, methodName, methodExpr.getEnd());
        throw new VisitCompleteException();
    }

    private void createContext(ASTNode completionNode, ASTNode declaringNode, ContentAssistLocation location) {
        this.context = new ContentAssistContext(this.completionOffset, this.completionExpression, this.fullCompletionExpression, completionNode, declaringNode, this.lhsNode, location, this.unit, this.currentDeclaration, this.completionEnd);
        throw new VisitCompleteException();
    }

    protected boolean doTest(ASTNode node) {
        return node.getEnd() > 0 && (this.supportingNodeEnd > node.getStart() && this.supportingNodeEnd <= node.getEnd() || this.completionOffset > node.getStart() && this.completionOffset <= node.getEnd());
    }

    public ContentAssistContext getContext() {
        return this.context;
    }
}

