/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.relevance;

import java.util.Arrays;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.relevance.AbstractRule;
import org.codehaus.groovy.eclipse.codeassist.relevance.IRelevanceRule;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.SourceType;

public class RelevanceRules
implements IRelevanceRule {
    public static int DEFAULT_STARTING_RELEVANCE_VALUE = 1;
    private RelevanceRuleType[] ruleTypes;
    public static RelevanceRules ALL_RULES = new RelevanceRules(RelevanceRuleType.LIBRARY_TYPE, RelevanceRuleType.SOURCE_TYPE, RelevanceRuleType.MODIFIERS, RelevanceRuleType.SIMILAR_PACKAGE);

    public static IRelevanceRule getRule(RelevanceRuleType type) {
        if (type == null) {
            return null;
        }
        AbstractRule rule = null;
        switch (type) {
            case SOURCE_TYPE: {
                rule = new SourceRule();
                break;
            }
            case MODIFIERS: {
                rule = new ModifierRule();
                break;
            }
            case LIBRARY_TYPE: {
                rule = new LibraryTypeRule();
                break;
            }
            case SIMILAR_PACKAGE: {
                rule = new SimilarPackagesRule();
            }
        }
        return rule;
    }

    public RelevanceRules(RelevanceRuleType ... ruleTypes) {
        this.ruleTypes = ruleTypes;
    }

    public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
        if (fullyQualifiedName == null) {
            return 0;
        }
        RelevanceRuleType[] rTypes = this.ruleTypes == null || this.ruleTypes.length == 0 ? RelevanceRuleType.values() : this.ruleTypes;
        int relevance = this.getStartingRelevanceValue();
        RelevanceRuleType[] relevanceRuleTypeArray = rTypes;
        int n = rTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelevanceRuleType ruleType = relevanceRuleTypeArray[n2];
            IRelevanceRule rule = RelevanceRules.getRule(ruleType);
            if (rule != null) {
                relevance += rule.getRelevance(fullyQualifiedName, contextTypes, accessibility, modifiers);
            }
            ++n2;
        }
        return Relevance.LOWEST.getRelevance(relevance);
    }

    public int getRelevance(IType type, IType[] contextTypes) {
        if (type == null) {
            return 0;
        }
        RelevanceRuleType[] rTypes = this.ruleTypes == null || this.ruleTypes.length == 0 ? RelevanceRuleType.values() : this.ruleTypes;
        int relevance = this.getStartingRelevanceValue();
        RelevanceRuleType[] relevanceRuleTypeArray = rTypes;
        int n = rTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelevanceRuleType ruleType = relevanceRuleTypeArray[n2];
            IRelevanceRule rule = RelevanceRules.getRule(ruleType);
            if (rule != null) {
                relevance += rule.getRelevance(type, contextTypes);
            }
            ++n2;
        }
        return Relevance.LOWEST.getRelevance(relevance);
    }

    protected int getStartingRelevanceValue() {
        return DEFAULT_STARTING_RELEVANCE_VALUE;
    }

    public static class AccessibilityRule
    extends AbstractRule {
        public int getRelevance(IType relevanceType, IType[] contextTypes) {
            if (relevanceType == null) {
                return 0;
            }
            AccessRestriction accessRestriction = ProposalUtils.getTypeAccessibility(relevanceType);
            int accessibility = 0;
            if (accessRestriction != null) {
                switch (accessRestriction.getProblemId()) {
                    case 0x1000133: {
                        accessibility = 1;
                        break;
                    }
                    case 0x1000118: {
                        accessibility = 2;
                    }
                }
            }
            return this.getRelevance(null, null, accessibility, 0);
        }

        public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
            return accessibility == 0 ? AbstractRule.TypeRelevanceCategory.MEDIUM_TYPE.applyCategory(1) : 0;
        }
    }

    public static class LibraryTypeRule
    extends AbstractRule {
        protected LibraryType getLibraryType(char[] qualifiedName) {
            char[][] segments = CharOperation.splitOn((char)'.', (char[])qualifiedName);
            if (segments != null && segments.length > 0) {
                char[] firstPackSegment = segments[0];
                LibraryType[] libraryTypeArray = LibraryType.values();
                int n = libraryTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryType type = libraryTypeArray[n2];
                    if (Arrays.equals(type.getValue(), firstPackSegment)) {
                        return type;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public int getRelevance(IType relevanceType, IType[] contextTypes) {
            if (relevanceType == null) {
                return 0;
            }
            return this.getRelevance(relevanceType.getFullyQualifiedName().toCharArray(), contextTypes, 0, 0);
        }

        public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
            int relevance = 0;
            LibraryType packType = this.getLibraryType(fullyQualifiedName);
            if (packType != null) {
                switch (packType) {
                    case JAVA: {
                        relevance += 4;
                        break;
                    }
                    case GROOVY: {
                        relevance += 3;
                        break;
                    }
                    case GROOVYX: {
                        relevance += 2;
                        break;
                    }
                    case JAVAX: {
                        ++relevance;
                    }
                }
            }
            return AbstractRule.TypeRelevanceCategory.LOW_TYPE.applyCategory(relevance);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum LibraryType {
            JAVA("java"),
            JAVAX("javax"),
            GROOVY("groovy"),
            GROOVYX("groovyx");

            private char[] value;

            private LibraryType(String value) {
                this.value = value.toCharArray();
            }

            public char[] getValue() {
                return this.value;
            }
        }
    }

    public static class ModifierRule
    extends AbstractRule {
        protected AbstractRule.TypeRelevanceCategory getTypeCategory(IType relevanceType, IType[] contextTypes) {
            AbstractRule.TypeRelevanceCategory category = null;
            category = this.areTypesInSameCompilationUnit(relevanceType, contextTypes) ? AbstractRule.TypeRelevanceCategory.HIGH_TYPE : (this.areTypesInSamePackage(relevanceType, contextTypes) ? AbstractRule.TypeRelevanceCategory.MEDIUM_HIGH_TYPE : null);
            return category;
        }

        public int getRelevance(IType relevanceType, IType[] contextTypes) {
            int relevance = 0;
            AbstractRule.TypeRelevanceCategory category = null;
            try {
                int modifiers = relevanceType.getFlags();
                category = this.getTypeCategory(relevanceType, contextTypes);
                if (category != null) {
                    relevance += false ? 0 : 1;
                    return category.applyCategory(relevance += (modifiers & 2) != 0 ? 0 : 1);
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Exception calculating relevance", (Throwable)e);
            }
            return 0;
        }

        public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelevanceRuleType {
        SOURCE_TYPE,
        ACCESSIBILITY,
        MODIFIERS,
        LIBRARY_TYPE,
        SIMILAR_PACKAGE;

    }

    public static class SimilarPackagesRule
    extends AbstractRule {
        protected String convertToDot(String name) {
            return name != null ? name.replace('$', '.') : name;
        }

        public int getRelevance(IType relevanceType, IType[] contextTypes) {
            return this.getRelevance(relevanceType.getFullyQualifiedName('.').toCharArray(), contextTypes, 0, 0);
        }

        public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
            int relevance = 0;
            IPackageFragment contextFragment = this.getContextPackageFragment(contextTypes);
            if (contextFragment != null && fullyQualifiedName != null) {
                String relQualified = String.valueOf(fullyQualifiedName);
                String contextQualified = this.convertToDot(contextFragment.getElementName());
                String[] relSegments = relQualified.split("\\.");
                String[] contextSegments = contextQualified.split("\\.");
                int i = 0;
                while (i < relSegments.length && i < contextSegments.length) {
                    if (!relSegments[i].equals(contextSegments[i])) break;
                    ++relevance;
                    ++i;
                }
            }
            return AbstractRule.TypeRelevanceCategory.HIGH_TYPE.applyCategory(relevance);
        }
    }

    public static class SourceRule
    extends AbstractRule {
        public int getRelevance(IType relevanceType, IType[] contextTypes) {
            return relevanceType instanceof SourceType ? AbstractRule.TypeRelevanceCategory.MEDIUM_TYPE.applyCategory(1) : AbstractRule.TypeRelevanceCategory.LOW_TYPE.applyCategory(1);
        }

        public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
            return 0;
        }
    }
}

