/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.relevance;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyCategoryMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyPropertyProposal;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Relevance {
    LOWEST(1),
    VERY_LOW(10),
    LOW(100),
    MEDIUM(1000),
    MEDIUM_HIGH(10000),
    HIGH(100000),
    VERY_HIGH(1000000);

    private int value;
    private static final Set<String> IGNORED_FIELD_NAMES;
    private static final Set<String> IGNORED_METHOD_NAMES;

    static {
        IGNORED_FIELD_NAMES = new HashSet<String>();
        IGNORED_FIELD_NAMES.add("metaClass");
        IGNORED_FIELD_NAMES.add("property");
        IGNORED_FIELD_NAMES.add("class");
        IGNORED_METHOD_NAMES = new HashSet<String>();
        IGNORED_METHOD_NAMES.add("getMetaClass");
        IGNORED_METHOD_NAMES.add("setMetaClass");
        IGNORED_METHOD_NAMES.add("getProperty");
        IGNORED_METHOD_NAMES.add("setProperty");
        IGNORED_METHOD_NAMES.add("invokeMethod");
    }

    private Relevance(int value) {
        this.value = value;
    }

    public int getRelevance(float multiplier) {
        return Math.max(1, (int)((float)this.value * multiplier));
    }

    public int getRelavance() {
        return this.value;
    }

    public static int calculateRelevance(AbstractGroovyProposal groovyProposal, float multiplier) {
        return Relevance.findRelevanceClass(groovyProposal).getRelevance(multiplier);
    }

    public static Relevance findRelevanceClass(AbstractGroovyProposal groovyProposal) {
        if (groovyProposal instanceof GroovyFieldProposal || groovyProposal instanceof GroovyPropertyProposal) {
            AnnotatedNode node = groovyProposal.getAssociatedNode();
            if (node instanceof FieldNode && IGNORED_FIELD_NAMES.contains(((FieldNode)node).getName())) {
                return VERY_LOW;
            }
            return MEDIUM_HIGH;
        }
        if (groovyProposal instanceof GroovyCategoryMethodProposal) {
            AnnotatedNode node = groovyProposal.getAssociatedNode();
            if (!(node instanceof MethodNode)) {
                return MEDIUM_HIGH;
            }
            MethodNode method = (MethodNode)node;
            if (VariableScope.ALL_DEFAULT_CATEGORIES.contains(method.getDeclaringClass())) {
                return VERY_LOW;
            }
            return MEDIUM_HIGH;
        }
        if (groovyProposal instanceof GroovyMethodProposal) {
            AnnotatedNode node = groovyProposal.getAssociatedNode();
            if (!(node instanceof MethodNode)) {
                return MEDIUM;
            }
            MethodNode method = (MethodNode)node;
            if (node instanceof MethodNode && IGNORED_METHOD_NAMES.contains(method.getName()) || VariableScope.OBJECT_CLASS_NODE.equals((Object)method.getDeclaringClass())) {
                return VERY_LOW;
            }
            return MEDIUM;
        }
        return MEDIUM;
    }
}

