/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProposalFormattingOptions {
    public final boolean noParensAroundClosures;
    public final boolean useBracketsForClosures;
    public final boolean useNamedArguments;
    public final boolean doParameterGuessing;
    public final boolean noParens;

    public static ProposalFormattingOptions newFromOptions() {
        IPreferenceStore prefs = GroovyPlugin.getDefault().getPreferenceStore();
        return new ProposalFormattingOptions(prefs.getBoolean("groovy.contentassist.noparens.around.closures"), prefs.getBoolean("groovy.contentassist.brackets"), prefs.getBoolean("groovy.contentassist.namedarguments"), prefs.getBoolean("groovy.contentassist.parameterguessing"), false);
    }

    public ProposalFormattingOptions(boolean noParensAroundArgs, boolean useBracketsForClosures, boolean useNamedArguments, boolean doParameterGuessing, boolean noParens) {
        this.noParensAroundClosures = noParensAroundArgs;
        this.useBracketsForClosures = useBracketsForClosures;
        this.useNamedArguments = useNamedArguments;
        this.doParameterGuessing = doParameterGuessing;
        this.noParens = noParens;
    }

    public ProposalFormattingOptions newFromExisting(boolean overrideUseNamedArgs, boolean overrideNoParens, MethodNode method) {
        if (overrideUseNamedArgs || overrideNoParens) {
            return new ProposalFormattingOptions(this.noParensAroundClosures, this.useBracketsForClosures, overrideUseNamedArgs, this.doParameterGuessing, overrideNoParens);
        }
        if (this.useNamedArguments && !(method instanceof ConstructorNode)) {
            return new ProposalFormattingOptions(this.noParensAroundClosures, this.useBracketsForClosures, false, this.doParameterGuessing, overrideNoParens);
        }
        return this;
    }
}

