/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.NamedParameterProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class GroovyNamedArgumentProposal
extends AbstractGroovyProposal {
    private final String paramName;
    private final String paramSignature;
    private final MethodNode ownerMethod;
    private final String contributor;
    private ProposalFormattingOptions options;

    public GroovyNamedArgumentProposal(String paramName, String paramSignature, MethodNode ownerMethod, String contributor) {
        this.paramName = paramName;
        this.paramSignature = paramSignature;
        this.ownerMethod = ownerMethod;
        this.contributor = contributor;
        this.setRelevanceMultiplier(100.0f);
    }

    public GroovyNamedArgumentProposal(String paramName, ClassNode paramType, MethodNode ownerMethod, String contributor) {
        this.paramName = paramName;
        this.paramSignature = ProposalUtils.createTypeSignatureStr(this.unbox(paramType));
        this.ownerMethod = ownerMethod;
        this.contributor = contributor;
        this.setRelevanceMultiplier(100.0f);
    }

    public AnnotatedNode getAssociatedNode() {
        return this.ownerMethod;
    }

    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (context.location != ContentAssistLocation.METHOD_CONTEXT) {
            return null;
        }
        MethodInfoContentAssistContext methodContext = (MethodInfoContentAssistContext)context;
        int startIndex = methodContext.completionLocation - methodContext.completionExpression.length();
        int length = methodContext.completionEnd - startIndex;
        return new NamedParameterProposal(this.paramName, this.paramSignature, startIndex, length, ProposalUtils.getParameterImage(), this.createDisplayString(), this.computeRelevance(), false, javaContext, this.getGroovyProposalOptions().doParameterGuessing);
    }

    private ProposalFormattingOptions getGroovyProposalOptions() {
        if (this.options == null) {
            this.options = ProposalFormattingOptions.newFromOptions();
        }
        return this.options.newFromExisting(true, false, null);
    }

    protected StyledString createDisplayString() {
        StyledString ss = new StyledString();
        ss.append(this.paramName).append(" : ").append("__").append(" - ").append(Signature.toString((String)this.paramSignature)).append(" : named parameter : ", StyledString.QUALIFIER_STYLER).append(" (" + this.contributor + ")", StyledString.DECORATIONS_STYLER);
        return ss;
    }

    private ClassNode unbox(ClassNode maybeBoxed) {
        if (ClassHelper.isPrimitiveType((ClassNode)maybeBoxed)) {
            return maybeBoxed;
        }
        String name = maybeBoxed.getName();
        if (ClassHelper.Boolean_TYPE.getName().equals(name)) {
            return ClassHelper.boolean_TYPE;
        }
        if (ClassHelper.Byte_TYPE.getName().equals(name)) {
            return ClassHelper.byte_TYPE;
        }
        if (ClassHelper.Character_TYPE.getName().equals(name)) {
            return ClassHelper.char_TYPE;
        }
        if (ClassHelper.Short_TYPE.getName().equals(name)) {
            return ClassHelper.short_TYPE;
        }
        if (ClassHelper.Integer_TYPE.getName().equals(name)) {
            return ClassHelper.int_TYPE;
        }
        if (ClassHelper.Long_TYPE.getName().equals(name)) {
            return ClassHelper.long_TYPE;
        }
        if (ClassHelper.Float_TYPE.getName().equals(name)) {
            return ClassHelper.float_TYPE;
        }
        if (ClassHelper.Double_TYPE.getName().equals(name)) {
            return ClassHelper.double_TYPE;
        }
        return maybeBoxed;
    }
}

