/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaGuessingCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaMethodCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.completions.NamedArgsMethodNode;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;

public class GroovyMethodProposal
extends AbstractGroovyProposal {
    protected final MethodNode method;
    private String contributor;
    private boolean useNamedArguments;
    private ProposalFormattingOptions options;
    private IType cachedDeclaringType;
    private boolean noParens;

    public GroovyMethodProposal(MethodNode method) {
        this.method = method;
        this.contributor = "Groovy";
        this.useNamedArguments = false;
        this.noParens = false;
    }

    public GroovyMethodProposal(MethodNode method, String contributor) {
        this(method);
        this.contributor = contributor;
    }

    public GroovyMethodProposal(MethodNode method, String contributor, ProposalFormattingOptions options) {
        this(method, contributor);
        this.options = options;
    }

    public void setUseNamedArguments(boolean useNamedArguments) {
        this.useNamedArguments = useNamedArguments;
    }

    public void setNoParens(boolean noParens) {
        this.noParens = noParens;
    }

    public AnnotatedNode getAssociatedNode() {
        return this.method;
    }

    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        GroovyCompletionProposal proposal = new GroovyCompletionProposal(6, context.completionLocation);
        if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
            MethodInfoContentAssistContext methodContext = (MethodInfoContentAssistContext)context;
            if (!methodContext.methodName.equals(this.method.getName())) {
                return null;
            }
            proposal.setReplaceRange(context.completionLocation, context.completionLocation);
            proposal.setCompletion(CharOperation.NO_CHAR);
        } else {
            proposal.setCompletion(this.completionName(!this.isParens(context, javaContext)));
            proposal.setReplaceRange(context.completionLocation - context.completionExpression.length(), context.completionEnd);
        }
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(this.method.getDeclaringClass()));
        proposal.setName(this.method.getName().toCharArray());
        if (this.method instanceof NamedArgsMethodNode) {
            this.fillInExtraParameters((NamedArgsMethodNode)this.method, proposal);
        } else {
            proposal.setParameterNames(this.createAllParameterNames((ICompilationUnit)context.unit));
            proposal.setParameterTypeNames(this.getParameterTypeNames(this.method.getParameters()));
        }
        proposal.setFlags(this.getModifiers());
        proposal.setAdditionalFlags(0);
        char[] methodSignature = this.createMethodSignature();
        proposal.setKey(methodSignature);
        proposal.setSignature(methodSignature);
        proposal.setRelevance(this.computeRelevance());
        JavaMethodCompletionProposal lazyProposal = null;
        ProposalFormattingOptions groovyProposalOptions = this.getGroovyProposalOptions();
        if (groovyProposalOptions.doParameterGuessing) {
            lazyProposal = GroovyJavaGuessingCompletionProposal.createProposal((CompletionProposal)proposal, javaContext, true, this.contributor, groovyProposalOptions);
        }
        if (lazyProposal == null) {
            lazyProposal = new GroovyJavaMethodCompletionProposal(proposal, javaContext, groovyProposalOptions, this.contributor);
            if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
                ((GroovyJavaMethodCompletionProposal)lazyProposal).contextOnly();
            }
        }
        if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
            lazyProposal.setContextInformationPosition(((MethodInfoContentAssistContext)context).methodNameEnd + 1);
        }
        return lazyProposal;
    }

    private void fillInExtraParameters(NamedArgsMethodNode namedArgsMethod, GroovyCompletionProposal proposal) {
        proposal.setParameterNames(this.getSpecialParameterNames(namedArgsMethod.getParameters()));
        proposal.setRegularParameterNames(this.getSpecialParameterNames(namedArgsMethod.getRegularParams()));
        proposal.setNamedParameterNames(this.getSpecialParameterNames(namedArgsMethod.getNamedParams()));
        proposal.setOptionalParameterNames(this.getSpecialParameterNames(namedArgsMethod.getOptionalParams()));
        proposal.setParameterTypeNames(this.getParameterTypeNames(namedArgsMethod.getParameters()));
        proposal.setRegularParameterTypeNames(this.getParameterTypeNames(namedArgsMethod.getRegularParams()));
        proposal.setNamedParameterTypeNames(this.getParameterTypeNames(namedArgsMethod.getNamedParams()));
        proposal.setOptionalParameterTypeNames(this.getParameterTypeNames(namedArgsMethod.getOptionalParams()));
    }

    private ProposalFormattingOptions getGroovyProposalOptions() {
        if (this.options == null) {
            this.options = ProposalFormattingOptions.newFromOptions();
        }
        return this.options.newFromExisting(this.useNamedArguments, this.noParens, this.method);
    }

    private boolean isParens(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (javaContext.getDocument().getLength() > context.completionEnd) {
            try {
                return javaContext.getDocument().getChar(context.completionEnd) == '(';
            }
            catch (BadLocationException e) {
                GroovyCore.logException((String)"Exception during content assist", (Throwable)e);
            }
        }
        return false;
    }

    protected boolean shouldUseNamedArguments(IPreferenceStore prefs) {
        return prefs.getBoolean("groovy.contentassist.namedarguments") && this.method instanceof ConstructorNode || this.useNamedArguments;
    }

    protected char[] createMethodSignature() {
        return ProposalUtils.createMethodSignature(this.method);
    }

    protected int getModifiers() {
        return this.method.getModifiers();
    }

    protected char[] completionName(boolean includeParens) {
        String name = this.method.getName();
        char[] nameArr = name.toCharArray();
        boolean hasWhitespace = false;
        int i = 0;
        while (i < nameArr.length) {
            if (Character.isWhitespace(nameArr[i])) {
                hasWhitespace = true;
                break;
            }
            ++i;
        }
        if (hasWhitespace) {
            name = "\"" + name + "\"";
        }
        if (includeParens) {
            return (String.valueOf(name) + "()").toCharArray();
        }
        return name.toCharArray();
    }

    protected char[][] createAllParameterNames(ICompilationUnit unit) {
        int numParams;
        Parameter[] params = this.method.getParameters();
        int n = numParams = params == null ? 0 : params.length;
        if (numParams == 0) {
            return new char[0][];
        }
        Object paramNames = null;
        if (params[0].getName().equals("arg0") || params[0].getName().equals("param0")) {
            paramNames = this.calculateAllParameterNames(unit, this.method);
        }
        if (paramNames == null) {
            paramNames = new char[params.length][];
            int i = 0;
            while (i < params.length) {
                String name = params[i].getName();
                paramNames[i] = name != null ? name.toCharArray() : ("arg" + i).toCharArray();
                ++i;
            }
        }
        return paramNames;
    }

    protected char[][] getParameterTypeNames(Parameter[] parameters) {
        char[][] typeNames = new char[parameters.length][];
        int i = 0;
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            typeNames[i] = ProposalUtils.createSimpleTypeName(param.getType());
            ++i;
            ++n2;
        }
        return typeNames;
    }

    protected char[][] calculateAllParameterNames(ICompilationUnit unit, MethodNode method) {
        try {
            IType declaringType = this.findDeclaringType(unit, method);
            if (declaringType != null && declaringType.exists()) {
                int numParams;
                Parameter[] params = method.getParameters();
                int n = numParams = params == null ? 0 : params.length;
                if (numParams == 0) {
                    return new char[0][];
                }
                String[] parameterTypeSignatures = new String[numParams];
                boolean doResolved = declaringType.isBinary();
                int i = 0;
                while (i < parameterTypeSignatures.length) {
                    parameterTypeSignatures[i] = doResolved ? ProposalUtils.createTypeSignatureStr(params[i].getType()) : ProposalUtils.createUnresolvedTypeSignatureStr(params[i].getType());
                    ++i;
                }
                IMethod jdtMethod = this.findPreciseMethod(declaringType, parameterTypeSignatures);
                if (jdtMethod != null) {
                    String[] paramNames = jdtMethod.getParameterNames();
                    char[][] paramNamesChar = new char[paramNames.length][];
                    int i2 = 0;
                    while (i2 < paramNames.length) {
                        paramNamesChar[i2] = paramNames[i2].toCharArray();
                        ++i2;
                    }
                    return paramNamesChar;
                }
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)("Exception while looking for parameter types of " + method.getName()), (Throwable)e);
        }
        return null;
    }

    private IMethod findPreciseMethod(IType declaringType, String[] parameterTypeSignatures) throws JavaModelException {
        IMethod closestMatch = declaringType.getMethod(this.method.getName(), parameterTypeSignatures);
        if (closestMatch != null && closestMatch.exists()) {
            return closestMatch;
        }
        IMethod[] methods = declaringType.getMethods();
        closestMatch = null;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IMethod maybeMethod = iMethodArray[n2];
                if (maybeMethod.getElementName().equals(this.method.getName())) {
                    String[] maybeMethodParameters = maybeMethod.getParameterTypes();
                    assert (maybeMethodParameters != null);
                    if (maybeMethodParameters.length == parameterTypeSignatures.length) {
                        closestMatch = maybeMethod;
                        int i = 0;
                        while (i < maybeMethodParameters.length) {
                            String maybeMethodParameterName = this.removeGenerics(maybeMethodParameters[i]);
                            if (parameterTypeSignatures[i].equals(maybeMethodParameterName)) {
                                ++i;
                                continue;
                            }
                            break block7;
                        }
                        return closestMatch;
                    }
                }
            }
            ++n2;
        }
        return closestMatch;
    }

    private String removeGenerics(String maybeMethodParameterName) {
        int genericStart = maybeMethodParameterName.indexOf("<");
        if (genericStart > 0) {
            maybeMethodParameterName = String.valueOf(maybeMethodParameterName.substring(0, genericStart)) + maybeMethodParameterName.substring(maybeMethodParameterName.indexOf(">") + 1, maybeMethodParameterName.length());
        }
        return maybeMethodParameterName;
    }

    private char[][] getSpecialParameterNames(Parameter[] params) {
        char[][] paramNames = new char[params.length][];
        int i = 0;
        while (i < params.length) {
            paramNames[i] = params[i].getName().toCharArray();
            ++i;
        }
        return paramNames;
    }

    private IType findDeclaringType(ICompilationUnit unit, MethodNode method) throws JavaModelException {
        if (this.cachedDeclaringType == null) {
            this.cachedDeclaringType = unit.getJavaProject().findType(method.getDeclaringClass().getName(), (IProgressMonitor)new NullProgressMonitor());
        }
        return this.cachedDeclaringType;
    }

    public MethodNode getMethod() {
        return this.method;
    }
}

