/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyJavaFieldCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class GroovyFieldProposal
extends AbstractGroovyProposal {
    private final FieldNode field;
    private final String contributor;

    public GroovyFieldProposal(FieldNode field) {
        this.field = field;
        this.contributor = "Groovy";
    }

    public GroovyFieldProposal(FieldNode field, String contributor) {
        this.field = field;
        this.contributor = contributor;
    }

    public GroovyFieldProposal(FieldNode field, int relevanceMultiplier) {
        this.field = field;
        this.setRelevanceMultiplier(relevanceMultiplier);
        this.contributor = "Groovy";
    }

    public GroovyFieldProposal(FieldNode field, int relevanceMultiplier, String contributor) {
        this.field = field;
        this.setRelevanceMultiplier(relevanceMultiplier);
        this.contributor = contributor;
    }

    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
            return null;
        }
        CompletionProposal proposal = this.createProposal(context);
        return new GroovyJavaFieldCompletionProposal(proposal, ProposalUtils.getImage(proposal), this.createDisplayString(this.field));
    }

    public AnnotatedNode getAssociatedNode() {
        return this.field;
    }

    protected StyledString createDisplayString(FieldNode field) {
        StyledString ss = new StyledString();
        ss.append(field.getName()).append(" : ").append(ProposalUtils.createSimpleTypeName(field.getType())).append(" - ").append(ProposalUtils.createSimpleTypeName(field.getDeclaringClass()), StyledString.QUALIFIER_STYLER).append(" (" + this.contributor + ")", StyledString.DECORATIONS_STYLER);
        return ss;
    }

    private CompletionProposal createProposal(ContentAssistContext context) {
        InternalCompletionProposal proposal = (InternalCompletionProposal)CompletionProposal.create((int)2, (int)context.completionLocation);
        proposal.setFlags(this.field.getModifiers());
        proposal.setName(this.field.getName().toCharArray());
        proposal.setCompletion(proposal.getName());
        proposal.setSignature(ProposalUtils.createTypeSignature(this.field.getType()));
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(this.field.getDeclaringClass()));
        proposal.setRelevance(this.computeRelevance());
        int startIndex = context.completionLocation - context.completionExpression.length();
        proposal.setReplaceRange(startIndex, context.completionEnd);
        return proposal;
    }

    public FieldNode getField() {
        return this.field;
    }
}

