/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.eclipse.codeassist.CharArraySourceBuffer;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ExpressionFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private static final Set<String> FIELD_MODIFIERS = new HashSet<String>();

    static {
        FIELD_MODIFIERS.add("private");
        FIELD_MODIFIERS.add("protected");
        FIELD_MODIFIERS.add("public");
        FIELD_MODIFIERS.add("static");
        FIELD_MODIFIERS.add("final");
    }

    public TypeCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        String toSearch;
        ContentAssistContext context = this.getContext();
        String string = toSearch = context.completionExpression.startsWith("new ") ? context.completionExpression.substring(4) : context.completionExpression;
        if (this.shouldShowTypes(context, toSearch)) {
            return Collections.emptyList();
        }
        int expressionStart = this.findExpressionStart(context);
        GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), expressionStart, context.completionEnd - expressionStart, this.getNameEnvironment().nameLookup, monitor);
        this.getNameEnvironment().findTypes(toSearch.toCharArray(), true, true, this.getSearchFor(), (ISearchRequestor)requestor, monitor);
        List<ICompletionProposal> typeProposals = requestor.processAcceptedTypes();
        return typeProposals;
    }

    private boolean shouldShowTypes(ContentAssistContext context, String toSearch) {
        return toSearch.length() == 0 && context.location != ContentAssistLocation.IMPORT || context.fullCompletionExpression.contains(".") || this.isBeforeTypeName(context.location, context.unit, context.completionLocation);
    }

    private int findExpressionStart(ContentAssistContext context) {
        int completionLength = context.completionExpression.startsWith("new ") ? context.completionExpression.substring("new ".length()).trim().length() : context.completionExpression.length();
        int expressionStart = context.completionLocation - completionLength;
        return expressionStart;
    }

    private int getSearchFor() {
        switch (this.getContext().location) {
            case EXTENDS: {
                return 5;
            }
            case IMPLEMENTS: {
                return 6;
            }
            case EXCEPTIONS: {
                return 5;
            }
            case ANNOTATION: {
                return 8;
            }
        }
        return 0;
    }

    private boolean isBeforeTypeName(ContentAssistLocation location, GroovyCompilationUnit unit, int completionLocation) {
        if (location != ContentAssistLocation.CLASS_BODY) {
            return false;
        }
        ExpressionFinder.NameAndLocation nameAndLocation = new ExpressionFinder().findPreviousTypeNameToken((ISourceBuffer)new CharArraySourceBuffer(unit.getContents()), completionLocation);
        if (nameAndLocation == null) {
            return false;
        }
        if (!(this.getContext().completionNode instanceof FieldNode)) {
            return false;
        }
        return !FIELD_MODIFIERS.contains(nameAndLocation.name.trim());
    }
}

