/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyExtendedCompletionContext;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.CategoryProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.FieldProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.MethodProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementAndExpressionCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    final ASTNode completionNode;
    final Expression lhsNode;

    public StatementAndExpressionCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
        this.completionNode = context.getPerceivedCompletionNode();
        this.lhsNode = context.lhsNode;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ClassNode completionType;
        boolean isStatic;
        TypeInferencingVisitorFactory factory = new TypeInferencingVisitorFactory();
        ContentAssistContext context = this.getContext();
        TypeInferencingVisitorWithRequestor visitor = factory.createVisitor(context.unit);
        ExpressionCompletionRequestor requestor = new ExpressionCompletionRequestor();
        if (this.completionNode != null) {
            visitor.visitCompilationUnit((ITypeRequestor)requestor);
        }
        LinkedList<IGroovyProposal> groovyProposals = new LinkedList<IGroovyProposal>();
        if (requestor.isVisitSuccessful()) {
            ClassNode closureThis;
            isStatic = this.isStatic() || requestor.isStatic;
            IProposalCreator[] creators = this.getAllProposalCreators();
            completionType = this.getCompletionType(requestor);
            if (completionType == null) {
                ClassNode classNode = completionType = context.containingDeclaration instanceof ClassNode ? (ClassNode)context.containingDeclaration : context.unit.getModuleNode().getScriptClassDummy();
            }
            if (context.completionNode instanceof ClassExpression && "java.lang.Class".equals(completionType.getName())) {
                ClassNode type = ((ClassExpression)context.completionNode).getType();
                this.proposalCreatorLoop(context, requestor, type, isStatic, groovyProposals, creators, false);
            }
            this.proposalCreatorLoop(context, requestor, completionType, isStatic, groovyProposals, creators, false);
            if (ContentAssistLocation.STATEMENT == context.location && (closureThis = requestor.currentScope.getThis()) != null && !closureThis.equals((Object)completionType)) {
                this.proposalCreatorLoop(context, requestor, closureThis, isStatic, groovyProposals, creators, true);
            }
        } else {
            Object importNode;
            AnnotatedNode node = context.containingDeclaration;
            Object containingClass = node instanceof ClassNode ? (ClassNode)node : (node instanceof MethodNode ? ((MethodNode)node).getDeclaringClass() : null);
            if (containingClass != null) {
                groovyProposals.addAll(new CategoryProposalCreator().findAllProposals((ClassNode)containingClass, VariableScope.ALL_DEFAULT_CATEGORIES, context.getPerceivedCompletionExpression(), false, ContentAssistLocation.STATEMENT == context.location));
            } else if (node instanceof ImportNode && (importNode = (ImportNode)node).isStatic()) {
                containingClass = importNode.getType();
                groovyProposals.addAll(new FieldProposalCreator().findAllProposals((ClassNode)containingClass, VariableScope.ALL_DEFAULT_CATEGORIES, context.getPerceivedCompletionExpression(), true, ContentAssistLocation.STATEMENT == context.location));
                groovyProposals.addAll(new MethodProposalCreator().findAllProposals((ClassNode)containingClass, VariableScope.ALL_DEFAULT_CATEGORIES, context.getPerceivedCompletionExpression(), true, ContentAssistLocation.STATEMENT == context.location));
            }
            completionType = context.containingDeclaration instanceof ClassNode ? (ClassNode)context.containingDeclaration : context.unit.getModuleNode().getScriptClassDummy();
            isStatic = false;
        }
        try {
            context.currentScope = requestor.currentScope != null ? requestor.currentScope : this.createTopLevelScope(completionType);
            List<IProposalProvider> providers = ProposalProviderRegistry.getRegistry().getProvidersFor(context.unit);
            for (IProposalProvider provider : providers) {
                try {
                    List<IGroovyProposal> otherProposals = provider.getStatementAndExpressionProposals(context, completionType, isStatic, requestor.categories);
                    if (otherProposals == null) continue;
                    groovyProposals.addAll(otherProposals);
                }
                catch (Exception e) {
                    GroovyCore.logException((String)("Exception when using third party proposal provider: " + provider.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
        catch (CoreException e) {
            GroovyCore.logException((String)"Exception accessing proposal provider registry", (Throwable)e);
        }
        this.fillInExtendedContext(requestor);
        try {
            List<IProposalFilter> filters = ProposalProviderRegistry.getRegistry().getFiltersFor(context.unit);
            for (IProposalFilter filter : filters) {
                try {
                    List<IGroovyProposal> newProposals = filter.filterProposals(groovyProposals, context, this.getJavaContext());
                    groovyProposals = newProposals == null ? groovyProposals : newProposals;
                }
                catch (Exception e) {
                    GroovyCore.logException((String)("Exception when using third party proposal filter: " + filter.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
        catch (CoreException e) {
            GroovyCore.logException((String)"Exception accessing proposal provider registry", (Throwable)e);
        }
        ArrayList<ICompletionProposal> javaProposals = new ArrayList<ICompletionProposal>(groovyProposals.size());
        JavaContentAssistInvocationContext javaContext = this.getJavaContext();
        for (IGroovyProposal groovyProposal : groovyProposals) {
            try {
                IJavaCompletionProposal javaProposal = groovyProposal.createJavaProposal(context, javaContext);
                if (javaProposal == null) continue;
                javaProposals.add((ICompletionProposal)javaProposal);
            }
            catch (Exception e) {
                GroovyCore.logException((String)"Exception when creating groovy completion proposal", (Throwable)e);
            }
        }
        return javaProposals;
    }

    private void proposalCreatorLoop(ContentAssistContext context, ExpressionCompletionRequestor requestor, ClassNode completionType, boolean isStatic, List<IGroovyProposal> groovyProposals, IProposalCreator[] creators, boolean isClosureThis) {
        IProposalCreator[] iProposalCreatorArray = creators;
        int n = creators.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalCreator creator = iProposalCreatorArray[n2];
            if (!isClosureThis || creator.redoForLoopClosure()) {
                if (creator instanceof AbstractProposalCreator) {
                    ((AbstractProposalCreator)creator).setLhsType(requestor.lhsType);
                    ((AbstractProposalCreator)creator).setCurrentScope(requestor.currentScope);
                }
                groovyProposals.addAll(creator.findAllProposals(completionType, requestor.categories, context.getPerceivedCompletionExpression(), isStatic, ContentAssistLocation.STATEMENT == context.location));
            }
            ++n2;
        }
    }

    private void fillInExtendedContext(ExpressionCompletionRequestor requestor) {
        JavaContentAssistInvocationContext javaContext = this.getJavaContext();
        CompletionContext coreContext = javaContext.getCoreContext();
        if (coreContext != null && !coreContext.isExtended()) {
            ReflectionUtils.setPrivateField(InternalCompletionContext.class, (String)"isExtended", (Object)coreContext, (Object)true);
            ReflectionUtils.setPrivateField(InternalCompletionContext.class, (String)"extendedContext", (Object)coreContext, (Object)((Object)new GroovyExtendedCompletionContext(this.getContext(), requestor.currentScope)));
        }
    }

    protected VariableScope createTopLevelScope(ClassNode completionType) {
        VariableScope scope = new VariableScope(null, (ASTNode)completionType, false);
        return scope;
    }

    private ClassNode getCompletionType(ExpressionCompletionRequestor requestor) {
        if (this.getContext().location == ContentAssistLocation.EXPRESSION) {
            return requestor.resultingType;
        }
        if (this.getContext().location == ContentAssistLocation.METHOD_CONTEXT) {
            return this.completionNode instanceof VariableExpression ? requestor.currentScope.getDelegateOrThis() : requestor.resultingType;
        }
        ClassNode type = requestor.currentScope.getDelegateOrThis();
        if (type != null) {
            return type;
        }
        return requestor.resultingType;
    }

    private boolean isStatic() {
        if (this.getContext().location == ContentAssistLocation.STATEMENT) {
            AnnotatedNode annotated = this.getContext().containingDeclaration;
            if (annotated instanceof FieldNode) {
                return ((FieldNode)annotated).isStatic();
            }
            if (annotated instanceof MethodNode) {
                return ((MethodNode)annotated).isStatic();
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExpressionCompletionRequestor
    implements ITypeRequestor {
        boolean visitSuccessful = false;
        boolean isStatic = false;
        ClassNode resultingType;
        ClassNode lhsType;
        Set<ClassNode> categories;
        VariableScope currentScope;
        private Expression arrayAccessLHS;
        private int derefCount = 0;

        public ExpressionCompletionRequestor() {
            ASTNode maybeLHS = StatementAndExpressionCompletionProcessor.this.getContext().getPerceivedCompletionNode();
            while (maybeLHS != null) {
                if (maybeLHS instanceof BinaryExpression) {
                    this.arrayAccessLHS = ((BinaryExpression)maybeLHS).getLeftExpression();
                    maybeLHS = this.arrayAccessLHS;
                    ++this.derefCount;
                    continue;
                }
                if (maybeLHS instanceof PropertyExpression) {
                    this.arrayAccessLHS = ((PropertyExpression)maybeLHS).getObjectExpression();
                    maybeLHS = ((PropertyExpression)maybeLHS).getProperty();
                    continue;
                }
                if (maybeLHS instanceof MethodCallExpression) {
                    this.arrayAccessLHS = ((MethodCallExpression)maybeLHS).getObjectExpression();
                    maybeLHS = ((MethodCallExpression)maybeLHS).getMethod();
                    continue;
                }
                if (maybeLHS instanceof Expression) {
                    this.arrayAccessLHS = (Expression)maybeLHS;
                }
                maybeLHS = null;
            }
        }

        public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
            MethodNode run;
            ClassNode clazz;
            if (!this.interestingElement(enclosingElement)) {
                return ITypeRequestor.VisitStatus.CANCEL_MEMBER;
            }
            if (node instanceof ClassNode ? (clazz = (ClassNode)node).redirect() == clazz && clazz.isScript() : node instanceof MethodNode && (run = (MethodNode)node).getName().equals("run") && run.getDeclaringClass().isScript() && (run.getParameters() == null || run.getParameters().length == 0)) {
                return ITypeRequestor.VisitStatus.CONTINUE;
            }
            boolean success = this.doTest(node);
            boolean derefList = false;
            if (!success) {
                derefList = success = this.doTestForAfterArrayAccess(node);
            }
            if (success) {
                this.maybeRememberLHSType(result);
                this.resultingType = this.findResultingType(result, derefList);
                this.categories = result.scope.getCategoryNames();
                this.visitSuccessful = true;
                this.isStatic = node instanceof StaticMethodCallExpression || node instanceof ClassExpression && this.resultingType != VariableScope.CLASS_CLASS_NODE;
                this.currentScope = result.scope;
                return ITypeRequestor.VisitStatus.STOP_VISIT;
            }
            return ITypeRequestor.VisitStatus.CONTINUE;
        }

        private ClassNode findResultingType(TypeLookupResult result, boolean derefList) {
            ClassNode candidate;
            ClassNode classNode = candidate = StatementAndExpressionCompletionProcessor.this.getContext().location == ContentAssistLocation.METHOD_CONTEXT ? result.declaringType : result.type;
            if (derefList) {
                int i = 0;
                while (i < this.derefCount) {
                    boolean getAtFound = false;
                    List getAts = candidate.getMethods("getAt");
                    for (MethodNode getAt : getAts) {
                        if (getAt.getParameters() == null || getAt.getParameters().length != 1) continue;
                        candidate = getAt.getReturnType();
                        getAtFound = true;
                    }
                    if (!getAtFound) {
                        if (VariableScope.MAP_CLASS_NODE.equals((Object)candidate)) {
                            candidate = candidate.getGenericsTypes()[1].getType();
                        } else {
                            int j = 0;
                            while (j < this.derefCount) {
                                candidate = VariableScope.extractElementType((ClassNode)candidate);
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            boolean extractElementType = false;
            ASTNode enclosing = result.scope.getEnclosingNode();
            if (enclosing instanceof MethodCallExpression) {
                extractElementType = ((MethodCallExpression)enclosing).isSpreadSafe();
            } else if (enclosing instanceof PropertyExpression) {
                extractElementType = ((PropertyExpression)enclosing).isSpreadSafe();
            }
            if (extractElementType) {
                candidate = VariableScope.extractElementType((ClassNode)candidate);
            }
            if (ClassHelper.isPrimitiveType((ClassNode)candidate)) {
                candidate = ClassHelper.getWrapper((ClassNode)candidate);
            }
            return candidate;
        }

        private boolean doTestForAfterArrayAccess(ASTNode node) {
            return node == this.arrayAccessLHS;
        }

        private void maybeRememberLHSType(TypeLookupResult result) {
            Variable variable;
            VariableScope.VariableInfo info;
            ClassNode maybeType;
            if (this.isAssignmentOfLhs(result.enclosingAssignment) && StatementAndExpressionCompletionProcessor.this.lhsNode instanceof Variable && (maybeType = (info = result.scope.lookupName((variable = (Variable)StatementAndExpressionCompletionProcessor.this.lhsNode).getName())) != null ? info.type : variable.getType()) != null && !maybeType.equals((Object)VariableScope.OBJECT_CLASS_NODE)) {
                this.lhsType = ClassHelper.getUnwrapper((ClassNode)maybeType);
            }
        }

        private boolean isAssignmentOfLhs(BinaryExpression node) {
            if (node != null && StatementAndExpressionCompletionProcessor.this.lhsNode != null) {
                Expression expression = node.getLeftExpression();
                return expression.getClass() == StatementAndExpressionCompletionProcessor.this.lhsNode.getClass() && expression.getStart() == StatementAndExpressionCompletionProcessor.this.lhsNode.getStart() && expression.getEnd() == StatementAndExpressionCompletionProcessor.this.lhsNode.getEnd();
            }
            return false;
        }

        private boolean doTest(ASTNode node) {
            BinaryExpression bin;
            if (node instanceof ArgumentListExpression) {
                return false;
            }
            if (node instanceof BinaryExpression && (bin = (BinaryExpression)node).getLeftExpression() == this.arrayAccessLHS) {
                return false;
            }
            return this.isNotExpressionAndStatement(StatementAndExpressionCompletionProcessor.this.completionNode, node) && StatementAndExpressionCompletionProcessor.this.completionNode.getStart() == node.getStart() && StatementAndExpressionCompletionProcessor.this.completionNode.getEnd() == node.getEnd();
        }

        private boolean interestingElement(IJavaElement enclosingElement) {
            if (enclosingElement.getElementName().equals("<clinit>")) {
                return true;
            }
            if (enclosingElement instanceof ISourceReference) {
                try {
                    ISourceRange range = ((ISourceReference)enclosingElement).getSourceRange();
                    return range.getOffset() <= StatementAndExpressionCompletionProcessor.this.completionNode.getStart() && range.getOffset() + range.getLength() >= StatementAndExpressionCompletionProcessor.this.completionNode.getEnd();
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)e);
                }
            }
            return false;
        }

        private boolean isNotExpressionAndStatement(ASTNode thisNode, ASTNode otherNode) {
            if (thisNode instanceof Expression) {
                return !(otherNode instanceof Statement);
            }
            if (thisNode instanceof Statement) {
                return !(otherNode instanceof Expression);
            }
            return true;
        }

        public ClassNode getResultingType() {
            return this.resultingType;
        }

        public Set<ClassNode> getCategories() {
            return this.categories;
        }

        public boolean isVisitSuccessful() {
            return this.visitSuccessful;
        }
    }
}

