/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProposalProviderRegistry {
    private static final String APPLIES_TO = "appliesTo";
    private static final String NATURE = "projectNature";
    private static final String PROVIDER = "proposalProvider";
    private static final String FILTER = "proposalFilter";
    private static final String PROPOSAL_PROVIDER_EXTENSION = "org.codehaus.groovy.eclipse.codeassist.completion.completionProposalProvider";
    private static final String PROPOSAL_FILTER_EXTENSION = "org.codehaus.groovy.eclipse.codeassist.completion.completionProposalFilter";
    private static final ProposalProviderRegistry DEFAULT = new ProposalProviderRegistry();
    private Map<String, List<IConfigurationElement>> natureLookupMap = new HashMap<String, List<IConfigurationElement>>();
    private Map<String, List<IConfigurationElement>> filterLookupMap = new HashMap<String, List<IConfigurationElement>>();

    public static ProposalProviderRegistry getRegistry() {
        return DEFAULT;
    }

    List<IProposalProvider> getProvidersFor(IProject project) throws CoreException {
        String[] natures = project.getDescription().getNatureIds();
        ArrayList<IProposalProvider> lookups = new ArrayList<IProposalProvider>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            List<IConfigurationElement> configs = this.natureLookupMap.get(nature);
            if (configs != null) {
                for (IConfigurationElement config : configs) {
                    try {
                        lookups.add((IProposalProvider)config.createExecutableExtension(PROVIDER));
                    }
                    catch (CoreException e) {
                        Util.log((Throwable)e, (String)("Problem creating completion provider for type " + config.getAttribute(PROVIDER)));
                    }
                }
            }
            ++n2;
        }
        return lookups;
    }

    List<IProposalProvider> getProvidersFor(GroovyCompilationUnit unit) throws CoreException {
        return this.getProvidersFor(unit.getResource().getProject());
    }

    List<IProposalFilter> getFiltersFor(IProject project) throws CoreException {
        String[] natures = project.getDescription().getNatureIds();
        ArrayList<IProposalFilter> filters = new ArrayList<IProposalFilter>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            List<IConfigurationElement> configs = this.filterLookupMap.get(nature);
            if (configs != null) {
                for (IConfigurationElement config : configs) {
                    try {
                        filters.add((IProposalFilter)config.createExecutableExtension(FILTER));
                    }
                    catch (CoreException e) {
                        Util.log((Throwable)e, (String)("Problem creating completion provider for type " + config.getAttribute(PROVIDER)));
                    }
                }
            }
            ++n2;
        }
        return filters;
    }

    public List<IProposalFilter> getFiltersFor(GroovyCompilationUnit unit) throws CoreException {
        return this.getFiltersFor(unit.getResource().getProject());
    }

    private ProposalProviderRegistry() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement config;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] configs;
        IExtension ext;
        IExtension[] exts;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PROPOSAL_PROVIDER_EXTENSION);
        IExtension[] iExtensionArray = exts = extPoint.getExtensions();
        int n3 = exts.length;
        int n4 = 0;
        while (n4 < n3) {
            ext = iExtensionArray[n4];
            iConfigurationElementArray = configs = ext.getConfigurationElements();
            n2 = configs.length;
            n = 0;
            while (n < n2) {
                config = iConfigurationElementArray[n];
                this.createLookup(config);
                ++n;
            }
            ++n4;
        }
        extPoint = Platform.getExtensionRegistry().getExtensionPoint(PROPOSAL_FILTER_EXTENSION);
        iExtensionArray = exts = extPoint.getExtensions();
        n3 = exts.length;
        n4 = 0;
        while (n4 < n3) {
            ext = iExtensionArray[n4];
            iConfigurationElementArray = configs = ext.getConfigurationElements();
            n2 = configs.length;
            n = 0;
            while (n < n2) {
                config = iConfigurationElementArray[n];
                this.createFilter(config);
                ++n;
            }
            ++n4;
        }
    }

    private void createLookup(IConfigurationElement config) {
        try {
            if (config.getName().equals(PROVIDER)) {
                if (config.getAttribute(PROVIDER) != null) {
                    IConfigurationElement[] appliesTos;
                    IConfigurationElement[] iConfigurationElementArray = appliesTos = config.getChildren(APPLIES_TO);
                    int n = appliesTos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<Object> elts;
                        IConfigurationElement appliesTo = iConfigurationElementArray[n2];
                        String nature = appliesTo.getAttribute(NATURE);
                        if (this.natureLookupMap.containsKey(nature)) {
                            elts = this.natureLookupMap.get(nature);
                        } else {
                            elts = new ArrayList(3);
                            this.natureLookupMap.put(nature, elts);
                        }
                        elts.add(config);
                        ++n2;
                    }
                } else {
                    Util.log((Throwable)new RuntimeException(), (String)"Type lookup registry extension found with no type lookup class.");
                }
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e, (String)"Problem registering type lookups");
        }
    }

    private void createFilter(IConfigurationElement config) {
        try {
            if (config.getName().equals(FILTER)) {
                if (config.getAttribute(FILTER) != null) {
                    IConfigurationElement[] appliesTos;
                    IConfigurationElement[] iConfigurationElementArray = appliesTos = config.getChildren(APPLIES_TO);
                    int n = appliesTos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<Object> elts;
                        IConfigurationElement appliesTo = iConfigurationElementArray[n2];
                        String nature = appliesTo.getAttribute(NATURE);
                        if (this.filterLookupMap.containsKey(nature)) {
                            elts = this.filterLookupMap.get(nature);
                        } else {
                            elts = new ArrayList(3);
                            this.filterLookupMap.put(nature, elts);
                        }
                        elts.add(config);
                        ++n2;
                    }
                } else {
                    Util.log((Throwable)new RuntimeException(), (String)"Filter lookup registry extension found with no type lookup class.");
                }
            }
        }
        catch (Exception e) {
            Util.log((Throwable)e, (String)"Problem registering type lookups");
        }
    }
}

