/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    public PackageCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ContentAssistContext context = this.getContext();
        char[] packageCompletionText = this.getPackageCompletionText(context.fullCompletionExpression);
        if (this.mightBePackage(packageCompletionText)) {
            int expressionStart = context.completionLocation - context.fullCompletionExpression.trim().length();
            GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), expressionStart, context.completionEnd - expressionStart, this.getNameEnvironment().nameLookup, monitor);
            this.getNameEnvironment().findPackages(packageCompletionText, (ISearchRequestor)requestor);
            List<ICompletionProposal> typeProposals = requestor.processAcceptedPackages();
            boolean alsoLookForTypes = this.shouldLookForTypes(packageCompletionText);
            if (alsoLookForTypes) {
                this.getNameEnvironment().findTypes(packageCompletionText, true, true, this.getSearchFor(), (ISearchRequestor)requestor, monitor);
                typeProposals.addAll(requestor.processAcceptedTypes());
            }
            return typeProposals;
        }
        return Collections.emptyList();
    }

    private boolean shouldLookForTypes(char[] packageCompletionText) {
        return CharOperation.indexOf((char)'.', (char[])packageCompletionText) > -1;
    }

    private boolean mightBePackage(char[] packageCompletionText) {
        String[] splits;
        if (packageCompletionText == null || packageCompletionText.length == 0) {
            return false;
        }
        String text = String.valueOf(packageCompletionText);
        String[] stringArray = splits = text.split("\\.");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            String split = stringArray[n2];
            if (split.length() > 0 && (status = JavaConventions.validateIdentifier((String)split, (String)"1.7", (String)"1.7")).getSeverity() >= 4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private char[] getPackageCompletionText(String fullCompletionExpression) {
        LinkedList<Character> chars = new LinkedList<Character>();
        if (fullCompletionExpression == null) {
            return new char[0];
        }
        char[] fullArray = fullCompletionExpression.toCharArray();
        int i = 0;
        while (i < fullArray.length) {
            if (!Character.isWhitespace(fullArray[i])) {
                if (Character.isJavaIdentifierPart(fullArray[i]) || fullArray[i] == '.') {
                    chars.add(Character.valueOf(fullArray[i]));
                } else {
                    return null;
                }
            }
            ++i;
        }
        char[] res = new char[chars.size()];
        int i2 = 0;
        for (Character c : chars) {
            res[i2] = c.charValue();
            ++i2;
        }
        return res;
    }

    private int getSearchFor() {
        switch (this.getContext().location) {
            case EXTENDS: {
                return 5;
            }
            case IMPLEMENTS: {
                return 6;
            }
            case EXCEPTIONS: {
                return 5;
            }
        }
        return 0;
    }
}

