/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMethodCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private Map<ClassNode, GenericsMapper> mappers = new HashMap<ClassNode, GenericsMapper>();

    public NewMethodCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        List<MethodNode> unimplementedMethods = this.getAllUnimplementedMethods(this.getClassNode());
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        ContentAssistContext context = this.getContext();
        IType enclosingType = context.getEnclosingType();
        if (enclosingType != null) {
            for (MethodNode method : unimplementedMethods) {
                proposals.add(this.createProposal(method, context, enclosingType));
            }
        }
        try {
            List<IProposalProvider> providers = ProposalProviderRegistry.getRegistry().getProvidersFor(context.unit);
            for (IProposalProvider provider : providers) {
                List<MethodNode> newProposals = provider.getNewMethodProposals(context);
                if (newProposals == null) continue;
                for (MethodNode methodNode : newProposals) {
                    proposals.add(this.createProposal(methodNode, context, enclosingType));
                }
            }
        }
        catch (CoreException e) {
            GroovyCore.logException((String)("Exception looking for proposal providers in " + context.unit.getElementName()), (Throwable)e);
        }
        return proposals;
    }

    private ClassNode getClassNode() {
        return this.getContext().containingCodeBlock instanceof ClassNode ? (ClassNode)this.getContext().containingCodeBlock : this.getScript();
    }

    private ClassNode getScript() {
        ModuleNode module = this.getContext().unit.getModuleNode();
        for (ClassNode clazz : module.getClasses()) {
            if (!clazz.isScript()) continue;
            return clazz;
        }
        throw new IllegalArgumentException("Expecting script in current module: " + module.getPackageName());
    }

    private ICompletionProposal createProposal(MethodNode method, ContentAssistContext context, IType enclosingType) {
        int relevance = Relevance.VERY_HIGH.getRelavance();
        GroovyCompletionProposal proposal = this.createProposal(7, context.completionLocation);
        String methodSignature = ProposalUtils.createMethodSignatureStr(method);
        proposal.setSignature(methodSignature.toCharArray());
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(method.getDeclaringClass()));
        proposal.setName(method.getName().toCharArray());
        proposal.setDeclarationTypeName(method.getDeclaringClass().getName().toCharArray());
        proposal.setTypeName(method.getReturnType().getName().toCharArray());
        proposal.setParameterNames(this.getParameterNames(method));
        String[] parameterTypeNamesStr = this.getParameterTypeNames(method);
        char[][] parameterTypeNames = new char[parameterTypeNamesStr.length][];
        int i = 0;
        while (i < parameterTypeNames.length) {
            parameterTypeNames[i] = parameterTypeNamesStr[i].toCharArray();
            ++i;
        }
        proposal.setParameterTypeNames(parameterTypeNames);
        StringBuffer completion = new StringBuffer();
        this.createMethod(method, completion);
        proposal.setCompletion(completion.toString().toCharArray());
        proposal.setDeclarationKey(method.getDeclaringClass().getName().toCharArray());
        proposal.setReplaceRange(context.completionLocation - context.completionExpression.length(), context.completionEnd);
        proposal.setFlags(method.getModifiers());
        proposal.setRelevance(relevance);
        OverrideCompletionProposal override = new OverrideCompletionProposal(context.unit.getJavaProject(), (ICompilationUnit)context.unit, method.getName(), parameterTypeNamesStr, context.completionLocation, context.completionExpression.length(), ProposalUtils.createDisplayString((CompletionProposal)proposal), String.valueOf(proposal.getCompletion()));
        override.setImage(ProposalUtils.getImage((CompletionProposal)proposal));
        override.setRelevance(relevance);
        override.setReplacementOffset(context.completionLocation - context.completionExpression.length());
        override.setReplacementLength(context.completionExpression.length());
        override.setRelevance(proposal.getRelevance());
        return override;
    }

    private char[][] getParameterNames(MethodNode method) {
        Parameter[] parameters = method.getParameters();
        char[][] paramNames = new char[parameters.length][];
        int i = 0;
        while (i < paramNames.length) {
            paramNames[i] = parameters[i].getName().toCharArray();
            ++i;
        }
        return paramNames;
    }

    private String[] getParameterTypeNames(MethodNode method) {
        GenericsMapper mapper = null;
        ClassNode declaringClass = method.getDeclaringClass();
        if (declaringClass.getGenericsTypes() != null && declaringClass.getGenericsTypes().length > 0) {
            if (!this.mappers.containsKey(declaringClass)) {
                ClassNode thiz = this.getClassNode();
                mapper = GenericsMapper.gatherGenerics((ClassNode)this.findResolvedType(thiz, declaringClass), (ClassNode)declaringClass);
            } else {
                mapper = this.mappers.get(declaringClass);
            }
        }
        Parameter[] parameters = method.getParameters();
        String[] paramTypeNames = new String[parameters.length];
        int i = 0;
        while (i < paramTypeNames.length) {
            ClassNode paramType = parameters[i].getType();
            if (mapper != null && paramType.getGenericsTypes() != null && paramType.getGenericsTypes().length > 0) {
                paramType = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (ClassNode)VariableScope.clone((ClassNode)paramType));
            }
            paramTypeNames[i] = paramType.getName();
            if (paramTypeNames[i].startsWith("[")) {
                int cnt = Signature.getArrayCount((String)paramTypeNames[i]);
                String sig = Signature.getElementType((String)paramTypeNames[i]);
                String qualifier = Signature.getSignatureQualifier((String)sig);
                String simple = Signature.getSignatureSimpleName((String)sig);
                StringBuilder sb = new StringBuilder();
                if (qualifier.length() > 0) {
                    sb.append(qualifier).append(".");
                }
                sb.append(simple);
                int j = 0;
                while (j < cnt) {
                    sb.append("[]");
                    ++j;
                }
                paramTypeNames[i] = sb.toString();
            }
            ++i;
        }
        return paramTypeNames;
    }

    private ClassNode findResolvedType(ClassNode target, ClassNode toResolve) {
        if (target != null) {
            if (target.equals((Object)toResolve)) {
                return target;
            }
            ClassNode result = this.findResolvedType(target.getUnresolvedSuperClass(false), toResolve);
            if (result != null) {
                return result;
            }
            ClassNode[] classNodeArray = target.getUnresolvedInterfaces(false);
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode inter = classNodeArray[n2];
                result = this.findResolvedType(inter, toResolve);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
            ClassNode redirect = target.redirect();
            if (redirect != target) {
                return this.findResolvedType(redirect, toResolve);
            }
        }
        return null;
    }

    private List<MethodNode> getAllUnimplementedMethods(ClassNode declaring) {
        List allMethods = declaring.getAllDeclaredMethods();
        List thisClassMethods = declaring.getMethods();
        ArrayList<MethodNode> unimplementedMethods = new ArrayList<MethodNode>(allMethods.size() - thisClassMethods.size());
        for (MethodNode allMethodNode : allMethods) {
            if (!allMethodNode.getName().startsWith(this.getContext().completionExpression) || !this.isOverridableMethod(allMethodNode)) continue;
            boolean found = false;
            block1: for (MethodNode thisClassMethod : thisClassMethods) {
                if (allMethodNode.getParameters().length != thisClassMethod.getParameters().length || !allMethodNode.getName().equals(thisClassMethod.getName())) continue;
                Parameter[] allMethodParams = allMethodNode.getParameters();
                Parameter[] thisClassParams = thisClassMethod.getParameters();
                int i = 0;
                while (i < thisClassParams.length) {
                    if (!allMethodParams[i].getType().getName().equals(thisClassParams[i].getType().getName())) continue block1;
                    ++i;
                }
                found = true;
                break;
            }
            if (!found) {
                unimplementedMethods.add(allMethodNode);
            }
            found = false;
        }
        return unimplementedMethods;
    }

    private boolean isOverridableMethod(MethodNode methodNode) {
        String name = methodNode.getName();
        return !name.contains("$") && !name.contains("<") && !methodNode.isPrivate() && !methodNode.isStatic() && (methodNode.getModifiers() & 0x10) == 0;
    }

    private void createMethod(MethodNode method, StringBuffer completion) {
        int insertedModifiers = method.getModifiers() & 0xFFFFFAFE;
        ASTNode.printModifiers((int)insertedModifiers, (StringBuffer)completion);
        this.createType(method.getReturnType(), completion, false);
        completion.append(' ');
        completion.append(method.getName());
        completion.append('(');
        Parameter[] parameters = method.getParameters();
        int length = parameters.length;
        int i = 0;
        while (i < length) {
            if (i != 0) {
                completion.append(',');
                completion.append(' ');
            }
            this.createType(parameters[i].getType(), completion, true);
            completion.append(' ');
            completion.append(parameters[i].getName());
            ++i;
        }
        completion.append(')');
        ClassNode[] exceptions = method.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            completion.append(' ');
            completion.append("throws");
            completion.append(' ');
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (i2 != 0) {
                    completion.append(' ');
                    completion.append(',');
                }
                this.createType(exceptions[i2], completion, false);
                ++i2;
            }
        }
    }

    private void createType(ClassNode type, StringBuffer completion, boolean isParameter) {
        int arrayCount = 0;
        while (type.getComponentType() != null) {
            ++arrayCount;
            type = type.getComponentType();
        }
        if (type.getName().equals("java.lang.Object") && arrayCount == 0) {
            if (!isParameter) {
                completion.append("def");
            }
        } else {
            completion.append(type.getNameWithoutPackage());
            int i = 0;
            while (i < arrayCount) {
                completion.append("[]");
                ++i;
            }
        }
    }
}

