/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiersCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private static String[] keywords = new String[]{"abstract", "def", "final", "native", "package", "private", "protected", "public", "static", "synchronized", "transient", "volatile", "void"};

    public ModifiersCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        String completionExpression = this.getContext().completionExpression;
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.startsWith(completionExpression)) {
                proposals.add(this.createProposal(keyword, this.getContext()));
            }
            ++n2;
        }
        return proposals;
    }

    private ICompletionProposal createProposal(String keyword, ContentAssistContext context) {
        GroovyCompletionProposal proposal = this.createProposal(3, context.completionLocation);
        proposal.setName(keyword.toCharArray());
        proposal.setCompletion(keyword.toCharArray());
        proposal.setReplaceRange(context.completionLocation - context.completionExpression.length(), context.completionEnd);
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = context.completionExpression.length();
        StyledString label = ProposalUtils.createDisplayString((CompletionProposal)proposal);
        int relevance = Relevance.LOWEST.getRelevance(5.0f);
        JavaCompletionProposal jcp = new JavaCompletionProposal(completion, start, length, null, label, relevance);
        jcp.setImage(ProposalUtils.getImage((CompletionProposal)proposal));
        return jcp;
    }
}

