/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private final int offset;
    private final int replaceLength;
    private final JavaContentAssistInvocationContext javaContext;

    public LocalVariableCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
        this.javaContext = javaContext;
        this.replaceLength = context.completionExpression.length();
        this.offset = context.completionLocation;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        Map<String, ClassNode> localNames = this.findLocalNames(this.extractVariableNameStart());
        List<ICompletionProposal> proposals = this.createProposals(localNames);
        proposals.addAll(this.createClosureProposals());
        return proposals;
    }

    private List<ICompletionProposal> createClosureProposals() {
        if (this.getContext().currentScope.getEnclosingClosure() != null) {
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(1);
            VariableScope.VariableInfo ownerInfo = this.getContext().currentScope.lookupName("owner");
            VariableScope.VariableInfo delegateInfo = this.getContext().currentScope.lookupName("delegate");
            this.maybeAddClosureProperty(proposals, "owner", ownerInfo.declaringType, ownerInfo.type, false);
            this.maybeAddClosureProperty(proposals, "getOwner", ownerInfo.declaringType, ownerInfo.type, true);
            this.maybeAddClosureProperty(proposals, "delegate", delegateInfo.declaringType, delegateInfo.type, false);
            this.maybeAddClosureProperty(proposals, "getDelegate", delegateInfo.declaringType, delegateInfo.type, true);
            this.maybeAddClosureProperty(proposals, "thisObject", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.OBJECT_CLASS_NODE, false);
            this.maybeAddClosureProperty(proposals, "getThisObject", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.OBJECT_CLASS_NODE, true);
            this.maybeAddClosureProperty(proposals, "resolveStrategy", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.INTEGER_CLASS_NODE, false);
            this.maybeAddClosureProperty(proposals, "getResolveStrategy", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.OBJECT_CLASS_NODE, true);
            this.maybeAddClosureProperty(proposals, "directive", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.INTEGER_CLASS_NODE, false);
            this.maybeAddClosureProperty(proposals, "getDirective", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.OBJECT_CLASS_NODE, true);
            this.maybeAddClosureProperty(proposals, "maximumNumberOfParameters", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.INTEGER_CLASS_NODE, false);
            this.maybeAddClosureProperty(proposals, "getMaximumNumberOfParameters", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.OBJECT_CLASS_NODE, true);
            this.maybeAddClosureProperty(proposals, "parameterTypes", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.CLASS_ARRAY_CLASS_NODE, false);
            this.maybeAddClosureProperty(proposals, "getParameterTypes", org.eclipse.jdt.groovy.search.VariableScope.CLOSURE_CLASS, org.eclipse.jdt.groovy.search.VariableScope.CLASS_ARRAY_CLASS_NODE, true);
            return proposals;
        }
        return Collections.emptyList();
    }

    private void maybeAddClosureProperty(List<ICompletionProposal> proposals, String name, ClassNode type, ClassNode declaringType, boolean isMethod) {
        if (ProposalUtils.looselyMatches(this.getContext().completionExpression, name)) {
            AbstractGroovyProposal proposal = isMethod ? this.createMethodProposal(name, declaringType, type) : this.createFieldProposal(name, declaringType, type);
            proposals.add((ICompletionProposal)proposal.createJavaProposal(this.getContext(), this.getJavaContext()));
        }
    }

    private GroovyFieldProposal createFieldProposal(String name, ClassNode declaring, ClassNode type) {
        FieldNode field = new FieldNode(name, 1, type, declaring, null);
        field.setDeclaringClass(declaring);
        return new GroovyFieldProposal(field);
    }

    private GroovyMethodProposal createMethodProposal(String name, ClassNode declaring, ClassNode returnType) {
        MethodNode method = new MethodNode(name, 1, returnType, new Parameter[0], new ClassNode[0], null);
        method.setDeclaringClass(declaring);
        return new GroovyMethodProposal(method);
    }

    private String extractVariableNameStart() {
        String fullExpression = this.getContext().completionExpression;
        if (fullExpression.length() == 0) {
            return "";
        }
        int end = fullExpression.length() - 1;
        while (end >= 0 && Character.isJavaIdentifierPart(fullExpression.charAt(end))) {
            --end;
        }
        if (end >= 0) {
            return fullExpression.substring(++end);
        }
        return fullExpression;
    }

    private Map<String, ClassNode> findLocalNames(String prefix) {
        HashMap<String, ClassNode> nameTypeMap = new HashMap<String, ClassNode>();
        VariableScope scope = this.getVariableScope(this.getContext().containingCodeBlock);
        while (scope != null) {
            Iterator varIter = scope.getDeclaredVariablesIterator();
            while (varIter.hasNext()) {
                Variable var = (Variable)varIter.next();
                boolean inBounds = var instanceof Parameter ? ((Parameter)var).getEnd() < this.offset : (var instanceof VariableExpression ? ((VariableExpression)var).getEnd() < this.offset : true);
                if (!inBounds || !ProposalUtils.looselyMatches(prefix, var.getName())) continue;
                nameTypeMap.put(var.getName(), var.getOriginType() != null ? var.getOriginType() : var.getType());
            }
            scope = scope.getParent();
        }
        return nameTypeMap;
    }

    private VariableScope getVariableScope(ASTNode astNode) {
        ClassNode clazz;
        MethodNode method;
        if (astNode instanceof BlockStatement) {
            return ((BlockStatement)astNode).getVariableScope();
        }
        if (astNode instanceof ClassNode && ((ClassNode)astNode).isScript() && (method = (clazz = (ClassNode)astNode).getMethod("run", new Parameter[0])) != null && method.getCode() instanceof BlockStatement) {
            return ((BlockStatement)method.getCode()).getVariableScope();
        }
        return null;
    }

    private List<ICompletionProposal> createProposals(Map<String, ClassNode> nameTypes) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Map.Entry<String, ClassNode> nameType : nameTypes.entrySet()) {
            proposals.add(this.createProposal(nameType.getKey(), nameType.getValue()));
        }
        return proposals;
    }

    private ICompletionProposal createProposal(String replaceName, ClassNode type) {
        CompletionProposal proposal = CompletionProposal.create((int)5, (int)this.offset);
        proposal.setCompletion(replaceName.toCharArray());
        proposal.setReplaceRange(this.offset - this.replaceLength, this.getContext().completionEnd);
        proposal.setSignature(ProposalUtils.createTypeSignature(type));
        proposal.setRelevance(Relevance.HIGH.getRelavance());
        LazyJavaCompletionProposal completion = new LazyJavaCompletionProposal(proposal, this.javaContext);
        completion.setRelevance(proposal.getRelevance());
        return completion;
    }
}

