/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaMethodCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyImportRewriteFactory;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyNamedArgumentProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.relevance.RelevanceRules;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.RelevanceConstants;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyProposalTypeSearchRequestor
implements ISearchRequestor,
RelevanceConstants {
    private static final char[][] DEFAULT_GROOVY_IMPORTS = new char[][]{"java.math.BigDecimal".toCharArray(), "java.math.BigInteger".toCharArray()};
    private static final char[][] DEFAULT_GROOVY_IMPORTS_SIMPLE_NAMES = new char[][]{"BigDecimal".toCharArray(), "BigInteger".toCharArray()};
    private static final char[][] DEFAULT_GROOVY_ON_DEMAND_IMPORTS = new char[][]{"java.io".toCharArray(), "java.net".toCharArray(), "java.util".toCharArray(), "groovy.lang".toCharArray(), "groovy.util".toCharArray()};
    private static final int CHECK_CANCEL_FREQUENCY = 50;
    private int foundTypesCount = 0;
    private int foundConstructorsCount = 0;
    private final IProgressMonitor monitor;
    private ObjectVector acceptedTypes;
    private Set<String> acceptedPackages;
    private ObjectVector acceptedConstructors;
    private boolean importCachesInitialized;
    private final int offset;
    private final int replaceLength;
    private final int actualCompletionPosition;
    private char[][][] imports;
    private char[][] onDemandimports;
    private final boolean isImport;
    private final JavaContentAssistInvocationContext javaContext;
    private final ModuleNode module;
    private final GroovyCompilationUnit unit;
    private final NameLookup nameLookup;
    private final String completionExpression;
    private GroovyImportRewriteFactory groovyRewriter;
    private boolean shouldAcceptConstructors;
    private CompletionEngine mockEngine;
    private IType[] allTypesInUnit;
    private boolean contextOnly;
    private final ContentAssistContext context;
    private ProposalFormattingOptions groovyProposalPrefs;

    public GroovyProposalTypeSearchRequestor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, int exprStart, int replaceLength, NameLookup nameLookup, IProgressMonitor monitor) {
        this.context = context;
        this.offset = exprStart;
        this.javaContext = javaContext;
        this.module = context.unit.getModuleNode();
        this.unit = context.unit;
        this.replaceLength = replaceLength;
        this.actualCompletionPosition = context.completionLocation;
        this.monitor = monitor;
        this.acceptedTypes = new ObjectVector();
        this.importCachesInitialized = false;
        this.nameLookup = nameLookup;
        this.isImport = context.location == ContentAssistLocation.IMPORT;
        this.shouldAcceptConstructors = context.location == ContentAssistLocation.CONSTRUCTOR || context.location == ContentAssistLocation.METHOD_CONTEXT;
        this.contextOnly = context.location == ContentAssistLocation.METHOD_CONTEXT;
        this.completionExpression = context.location == ContentAssistLocation.METHOD_CONTEXT ? ((MethodInfoContentAssistContext)context).methodName : context.completionExpression;
        this.groovyRewriter = new GroovyImportRewriteFactory(this.unit, this.module);
        try {
            this.allTypesInUnit = this.unit.getAllTypes();
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)"Problem with type completion", (Throwable)e);
            this.allTypesInUnit = new IType[0];
        }
    }

    public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction accessRestriction) {
        if (this.shouldAcceptConstructors) {
            if (this.foundConstructorsCount % 50 == 0) {
                this.checkCancel();
            }
            ++this.foundConstructorsCount;
            if ((typeModifiers & 0x4000) != 0) {
                return;
            }
            int accessibility = 0;
            if (accessRestriction != null) {
                switch (accessRestriction.getProblemId()) {
                    case 0x1000133: {
                        return;
                    }
                    case 0x1000118: {
                        accessibility = 2;
                    }
                }
            }
            if (this.acceptedConstructors == null) {
                this.acceptedConstructors = new ObjectVector();
            }
            this.acceptedConstructors.add((Object)new AcceptedConstructor(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, accessibility));
        }
    }

    public void acceptPackage(char[] packageName) {
        this.checkCancel();
        if (this.acceptedPackages == null) {
            this.acceptedPackages = new HashSet<String>();
        }
        this.acceptedPackages.add(String.valueOf(packageName));
    }

    public void acceptType(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, int modifiers, AccessRestriction accessRestriction) {
        if (this.foundTypesCount % 50 == 0) {
            this.checkCancel();
        }
        ++this.foundTypesCount;
        if (CharOperation.contains((char)'$', (char[])simpleTypeName)) {
            return;
        }
        int accessibility = 0;
        if (accessRestriction != null) {
            switch (accessRestriction.getProblemId()) {
                case 0x1000133: {
                    return;
                }
                case 0x1000118: {
                    accessibility = 2;
                }
            }
        }
        if (this.acceptedTypes == null) {
            this.acceptedTypes = new ObjectVector();
        }
        this.acceptedTypes.add((Object)new AcceptedType(packageName, simpleTypeName, enclosingTypeNames, modifiers, accessibility));
    }

    private void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    List<ICompletionProposal> processAcceptedTypes() {
        this.checkCancel();
        if (this.acceptedTypes == null) {
            return Collections.EMPTY_LIST;
        }
        int length = this.acceptedTypes.size();
        if (length == 0) {
            return Collections.EMPTY_LIST;
        }
        HashtableOfObject onDemandFound = new HashtableOfObject();
        String thisPackageName = this.module.getPackageName() == null ? "" : this.module.getPackageName();
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        try {
            int i = 0;
            while (i < length) {
                block21: {
                    char[] typeName;
                    char[] flatEnclosingTypeNames;
                    if (i % 50 == 0) {
                        this.checkCancel();
                    }
                    AcceptedType acceptedType = (AcceptedType)this.acceptedTypes.elementAt(i);
                    char[] packageName = acceptedType.packageName;
                    char[] simpleTypeName = acceptedType.simpleTypeName;
                    char[][] enclosingTypeNames = acceptedType.enclosingTypeNames;
                    int modifiers = acceptedType.modifiers;
                    int accessibility = acceptedType.accessibility;
                    if (enclosingTypeNames == null || enclosingTypeNames.length == 0) {
                        flatEnclosingTypeNames = null;
                        typeName = simpleTypeName;
                    } else {
                        flatEnclosingTypeNames = CharOperation.concatWith((char[][])acceptedType.enclosingTypeNames, (char)'.');
                        typeName = CharOperation.concat((char[])flatEnclosingTypeNames, (char[])simpleTypeName, (char)'.');
                    }
                    char[] fullyQualifiedName = CharOperation.concat((char[])packageName, (char[])typeName, (char)'.');
                    if (!this.importCachesInitialized) {
                        this.initializeImportCaches();
                    }
                    int j = 0;
                    while (j < this.imports.length) {
                        char[][] importName = this.imports[j];
                        if (CharOperation.equals((char[])typeName, (char[])importName[0])) {
                            proposals.add(this.proposeType(packageName, simpleTypeName, modifiers, accessibility, typeName, fullyQualifiedName, !CharOperation.equals((char[])fullyQualifiedName, (char[])importName[1])));
                            break block21;
                        }
                        ++j;
                    }
                    if ((enclosingTypeNames == null || enclosingTypeNames.length == 0) && CharOperation.equals((char[])thisPackageName.toCharArray(), (char[])packageName)) {
                        proposals.add(this.proposeType(packageName, simpleTypeName, modifiers, accessibility, typeName, fullyQualifiedName, false));
                    } else {
                        char[] fullyQualifiedEnclosingTypeOrPackageName = null;
                        if ((AcceptedType)onDemandFound.get(simpleTypeName) == null) {
                            int j2 = 0;
                            while (j2 < this.onDemandimports.length) {
                                char[] importFlatName = this.onDemandimports[j2];
                                if (fullyQualifiedEnclosingTypeOrPackageName == null) {
                                    fullyQualifiedEnclosingTypeOrPackageName = enclosingTypeNames != null && enclosingTypeNames.length != 0 ? CharOperation.concat((char[])packageName, (char[])flatEnclosingTypeNames, (char)'.') : packageName;
                                }
                                if (CharOperation.equals((char[])fullyQualifiedEnclosingTypeOrPackageName, (char[])importFlatName)) {
                                    acceptedType.qualifiedTypeName = typeName;
                                    acceptedType.fullyQualifiedName = fullyQualifiedName;
                                    onDemandFound.put(simpleTypeName, (Object)acceptedType);
                                    break block21;
                                }
                                ++j2;
                            }
                            proposals.add(this.proposeType(fullyQualifiedEnclosingTypeOrPackageName != null ? fullyQualifiedEnclosingTypeOrPackageName : packageName, simpleTypeName, modifiers, accessibility, typeName, fullyQualifiedName, true));
                        }
                    }
                }
                ++i;
            }
            char[][] keys = onDemandFound.keyTable;
            Object[] values = onDemandFound.valueTable;
            int max = keys.length;
            int i2 = 0;
            while (i2 < max) {
                AcceptedType value;
                if (i2 % 50 == 0) {
                    this.checkCancel();
                }
                if (keys[i2] != null && (value = (AcceptedType)values[i2]) != null) {
                    proposals.add(this.proposeType(value.packageName, value.simpleTypeName, value.modifiers, value.accessibility, value.qualifiedTypeName, value.fullyQualifiedName, value.mustBeQualified));
                }
                ++i2;
            }
        }
        finally {
            this.acceptedTypes = null;
        }
        return proposals;
    }

    private ICompletionProposal proposeNoImportType(char[] packageName, char[] simpleTypeName, int modifiers, int accessibility, char[] qualifiedTypeName, char[] fullyQualifiedName, boolean isQualified) {
        char[] completionName = isQualified ? fullyQualifiedName : simpleTypeName;
        GroovyCompletionProposal proposal = this.createProposal(9, this.actualCompletionPosition - this.offset);
        proposal.setDeclarationSignature(packageName);
        proposal.setSignature(CompletionEngine.createNonGenericTypeSignature((char[])packageName, (char[])simpleTypeName));
        proposal.setCompletion(completionName);
        proposal.setFlags(modifiers);
        proposal.setReplaceRange(this.offset, this.offset + this.replaceLength);
        proposal.setTokenRange(this.offset, this.actualCompletionPosition);
        proposal.setRelevance(RelevanceRules.ALL_RULES.getRelevance(fullyQualifiedName, this.allTypesInUnit, accessibility, modifiers));
        proposal.setTypeName(simpleTypeName);
        proposal.setAccessibility(accessibility);
        proposal.setPackageName(packageName);
        String completionString = new String(completionName);
        JavaTypeCompletionProposal javaCompletionProposal = new JavaTypeCompletionProposal(completionString, null, this.offset, this.replaceLength, ProposalUtils.getImage((CompletionProposal)proposal), ProposalUtils.createDisplayString((CompletionProposal)proposal), proposal.getRelevance(), completionString, this.javaContext);
        javaCompletionProposal.setRelevance(proposal.getRelevance());
        return javaCompletionProposal;
    }

    private ICompletionProposal proposeType(char[] packageName, char[] simpleTypeName, int modifiers, int accessibility, char[] qualifiedTypeName, char[] fullyQualifiedName, boolean isQualified) {
        return this.isImport ? this.proposeNoImportType(packageName, simpleTypeName, modifiers, accessibility, qualifiedTypeName, fullyQualifiedName, isQualified) : this.proposeImportableType(packageName, simpleTypeName, modifiers, accessibility, qualifiedTypeName, fullyQualifiedName, isQualified);
    }

    private ICompletionProposal proposeImportableType(char[] packageName, char[] simpleTypeName, int modifiers, int accessibility, char[] qualifiedTypeName, char[] fullyQualifiedName, boolean isQualified) {
        char[] completionName = isQualified ? fullyQualifiedName : simpleTypeName;
        GroovyCompletionProposal proposal = this.createProposal(9, this.actualCompletionPosition - this.offset);
        proposal.setDeclarationSignature(packageName);
        proposal.setSignature(CompletionEngine.createNonGenericTypeSignature((char[])packageName, (char[])simpleTypeName));
        proposal.setCompletion(completionName);
        proposal.setFlags(modifiers);
        proposal.setReplaceRange(this.offset, this.offset + this.replaceLength);
        proposal.setTokenRange(this.offset, this.actualCompletionPosition);
        proposal.setRelevance(RelevanceRules.ALL_RULES.getRelevance(fullyQualifiedName, this.allTypesInUnit, accessibility, modifiers));
        proposal.setNameLookup(this.nameLookup);
        proposal.setTypeName(simpleTypeName);
        proposal.setAccessibility(accessibility);
        proposal.setPackageName(packageName);
        LazyGenericTypeProposal javaCompletionProposal = new LazyGenericTypeProposal((CompletionProposal)proposal, this.javaContext);
        javaCompletionProposal.setTriggerCharacters(ProposalUtils.TYPE_TRIGGERS);
        javaCompletionProposal.setRelevance(proposal.getRelevance());
        ImportRewrite r = this.groovyRewriter.getImportRewrite(this.monitor);
        if (r != null) {
            ReflectionUtils.setPrivateField(LazyJavaTypeCompletionProposal.class, (String)"fImportRewrite", (Object)javaCompletionProposal, (Object)r);
        }
        return javaCompletionProposal;
    }

    private void initializeImportCaches() {
        this.importCachesInitialized = true;
        List importPackages = this.module.getStarImports();
        this.onDemandimports = new char[importPackages.size() + DEFAULT_GROOVY_ON_DEMAND_IMPORTS.length][];
        int i = 0;
        for (ImportNode importPackage : importPackages) {
            char[] onDemand = importPackage.getPackageName().toCharArray();
            int length = onDemand.length;
            if (length > 0 && onDemand[length - 1] == '.') {
                onDemand = CharOperation.subarray((char[])onDemand, (int)0, (int)(length - 1));
            }
            this.onDemandimports[i++] = onDemand;
        }
        char[][] cArray = DEFAULT_GROOVY_ON_DEMAND_IMPORTS;
        int n = DEFAULT_GROOVY_ON_DEMAND_IMPORTS.length;
        int n2 = 0;
        while (n2 < n) {
            char[] defaultOnDemand = cArray[n2];
            this.onDemandimports[i++] = defaultOnDemand;
            ++n2;
        }
        List importClasses = this.module.getImports();
        this.imports = new char[importClasses.size() + DEFAULT_GROOVY_IMPORTS.length][][];
        i = 0;
        for (ImportNode importNode : importClasses) {
            this.imports[i] = new char[2][];
            this.imports[i][0] = importNode.getAlias().toCharArray();
            this.imports[i][1] = importNode.getType().getName().toCharArray();
            ++i;
        }
        int j = 0;
        while (j < DEFAULT_GROOVY_IMPORTS.length) {
            this.imports[i] = new char[2][];
            this.imports[i][0] = DEFAULT_GROOVY_IMPORTS_SIMPLE_NAMES[j];
            this.imports[i][1] = DEFAULT_GROOVY_IMPORTS[j];
            ++i;
            ++j;
        }
    }

    List<ICompletionProposal> processAcceptedPackages() {
        this.checkCancel();
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        if (this.acceptedPackages != null && this.acceptedPackages.size() > 0) {
            for (String packageNameStr : this.acceptedPackages) {
                char[] packageName = packageNameStr.toCharArray();
                GroovyCompletionProposal proposal = this.createProposal(8, this.actualCompletionPosition);
                proposal.setDeclarationSignature(packageName);
                proposal.setPackageName(packageName);
                proposal.setCompletion(packageName);
                proposal.setReplaceRange(this.offset, this.actualCompletionPosition);
                proposal.setTokenRange(this.offset, this.actualCompletionPosition);
                proposal.setRelevance(Relevance.LOWEST.getRelavance());
                LazyJavaCompletionProposal javaProposal = new LazyJavaCompletionProposal((CompletionProposal)proposal, this.javaContext);
                proposals.add((ICompletionProposal)javaProposal);
                javaProposal.setRelevance(proposal.getRelevance());
            }
        }
        return proposals;
    }

    List<ICompletionProposal> processAcceptedConstructors(Set<String> usedParams, JDTResolver resolver) {
        char[] currentPackageName;
        this.checkCancel();
        if (this.acceptedConstructors == null) {
            return Collections.emptyList();
        }
        int length = this.acceptedConstructors.size();
        if (length == 0) {
            return Collections.emptyList();
        }
        String currentPackageNameStr = this.module.getPackageName();
        if (currentPackageNameStr == null) {
            currentPackageName = CharOperation.NO_CHAR;
        } else {
            currentPackageName = currentPackageNameStr.toCharArray();
            if (currentPackageName[currentPackageName.length - 1] == '.') {
                char[] newPackageName = new char[currentPackageName.length - 1];
                System.arraycopy(currentPackageName, 0, newPackageName, 0, newPackageName.length);
                currentPackageName = newPackageName;
            }
        }
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        try {
            int i = 0;
            while (i < length) {
                if (i % 50 == 0) {
                    this.checkCancel();
                }
                AcceptedConstructor acceptedConstructor = (AcceptedConstructor)this.acceptedConstructors.elementAt(i);
                int typeModifiers = acceptedConstructor.typeModifiers;
                if (!this.isInterfaceAnnotationAbstractOrEnum(typeModifiers)) {
                    ICompletionProposal constructorProposal;
                    char[] packageName = acceptedConstructor.packageName;
                    char[] simpleTypeName = acceptedConstructor.simpleTypeName;
                    int modifiers = acceptedConstructor.modifiers;
                    int parameterCount = acceptedConstructor.parameterCount;
                    char[] signature = acceptedConstructor.signature;
                    char[][] parameterTypes = acceptedConstructor.parameterTypes;
                    char[][] parameterNames = acceptedConstructor.parameterNames;
                    int extraFlags = acceptedConstructor.extraFlags;
                    int accessibility = acceptedConstructor.accessibility;
                    char[] fullyQualifiedName = CharOperation.concat((char[])packageName, (char[])simpleTypeName, (char)'.');
                    if (!this.importCachesInitialized) {
                        this.initializeImportCaches();
                    }
                    if (!Flags.isEnum((int)typeModifiers) && (constructorProposal = this.proposeConstructor(simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, modifiers, packageName, typeModifiers, accessibility, simpleTypeName, fullyQualifiedName, false, extraFlags)) != null) {
                        List constructors;
                        ClassNode resolved;
                        proposals.add(constructorProposal);
                        if (this.contextOnly && (resolved = resolver.resolve(String.valueOf(fullyQualifiedName))) != null && (constructors = resolved.getDeclaredConstructors()) != null && constructors.size() == 1) {
                            ConstructorNode constructor = (ConstructorNode)constructors.get(0);
                            Parameter[] parameters = constructor.getParameters();
                            if (constructor.getStart() <= 0 && (parameters == null || parameters.length == 0)) {
                                for (PropertyNode prop : resolved.getProperties()) {
                                    if (prop.getName().equals("metaClass") || usedParams.contains(prop.getName())) continue;
                                    GroovyNamedArgumentProposal namedProp = new GroovyNamedArgumentProposal(prop.getName(), prop.getType(), null, null);
                                    proposals.add((ICompletionProposal)namedProp.createJavaProposal(this.context, this.javaContext));
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.acceptedTypes = null;
        }
        return proposals;
    }

    private boolean isInterfaceAnnotationAbstractOrEnum(int typeModifiers) {
        return (typeModifiers & 0x6200) != 0;
    }

    private ICompletionProposal proposeConstructor(char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int modifiers, char[] packageName, int typeModifiers, int accessibility, char[] typeName, char[] fullyQualifiedName, boolean isQualified, int extraFlags) {
        char[] typeCompletion;
        String simpleTypeNameStr = String.valueOf(simpleTypeName);
        String fullyQualifiedNameStr = String.valueOf(fullyQualifiedName);
        if (this.contextOnly && !this.completionExpression.equals(simpleTypeNameStr) && !this.completionExpression.equals(fullyQualifiedNameStr)) {
            return null;
        }
        if (isQualified) {
            typeCompletion = fullyQualifiedName;
            if (packageName == null || packageName.length == 0) {
                typeCompletion = simpleTypeName;
            }
        } else {
            typeCompletion = simpleTypeName;
        }
        float relevanceMultiplier = 1.0f;
        relevanceMultiplier += (float)(accessibility == 0 ? 2 : -1);
        relevanceMultiplier += (float)this.computeRelevanceForCaseMatching(this.completionExpression.toCharArray(), simpleTypeName);
        int augmentedModifiers = modifiers;
        if (Flags.isDeprecated((int)typeModifiers)) {
            augmentedModifiers |= 0x100000;
        }
        if (parameterCount == -1) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        } else {
            int parameterNamesLength;
            int n = parameterNamesLength = parameterNames == null ? 0 : parameterNames.length;
            if (parameterCount != parameterNamesLength) {
                parameterNames = null;
            }
        }
        GroovyCompletionProposal proposal = this.createProposal(this.contextOnly ? 6 : 26, this.offset - 1);
        char[] declarationSignature = CompletionEngine.createNonGenericTypeSignature((char[])packageName, (char[])typeName);
        proposal.setDeclarationSignature(declarationSignature);
        if (this.contextOnly) {
            proposal.setReplaceRange(this.actualCompletionPosition, this.actualCompletionPosition);
            proposal.setTokenRange(this.actualCompletionPosition, this.actualCompletionPosition);
            proposal.setCompletion(CharOperation.NO_CHAR);
        } else {
            proposal.setCompletion(this.completionExpression.toCharArray());
            proposal.setReplaceRange(this.offset + this.replaceLength, this.offset + this.replaceLength);
            proposal.setTokenRange(this.offset, this.actualCompletionPosition);
            char[] completion = new char[]{'(', ')'};
            try {
                if (this.javaContext.getDocument().getChar(this.actualCompletionPosition) == '(') {
                    completion = new char[]{};
                }
            }
            catch (BadLocationException badLocationException) {}
            proposal.setCompletion(completion);
            GroovyCompletionProposal typeProposal = this.createTypeProposal(packageName, typeModifiers, accessibility, typeName, fullyQualifiedName, isQualified, typeCompletion, augmentedModifiers, declarationSignature);
            proposal.setRequiredProposals(new CompletionProposal[]{typeProposal});
        }
        if (signature == null) {
            proposal.setSignature(this.createConstructorSignature((char[][])parameterTypes, isQualified));
        } else {
            char[] copy = new char[signature.length];
            System.arraycopy(signature, 0, copy, 0, copy.length);
            CharOperation.replace((char[])copy, (char)'/', (char)'.');
            proposal.setSignature(copy);
        }
        if (parameterNames != null) {
            proposal.setParameterNames(parameterNames);
        } else {
            proposal.setHasNoParameterNamesFromIndex(true);
            if (this.mockEngine == null) {
                this.mockEngine = new CompletionEngine(null, new CompletionRequestor(){

                    public void accept(CompletionProposal proposal) {
                    }
                }, null, this.javaContext.getProject(), null, null);
            }
            proposal.setCompletionEngine(this.mockEngine);
        }
        if (parameterTypes == null) {
            parameterTypes = new char[parameterCount][];
            int i = 0;
            while (i < parameterCount) {
                parameterTypes[i] = "def".toCharArray();
                ++i;
            }
        }
        proposal.setParameterTypeNames((char[][])parameterTypes);
        proposal.setDeclarationPackageName(packageName);
        proposal.setDeclarationTypeName(simpleTypeName);
        proposal.setName(simpleTypeName);
        proposal.setIsContructor(true);
        proposal.setRelevance(Relevance.MEDIUM_HIGH.getRelevance(relevanceMultiplier));
        proposal.setFlags(augmentedModifiers);
        proposal.setTypeName(simpleTypeName);
        proposal.setAccessibility(typeModifiers);
        proposal.setPackageName(packageName);
        GroovyJavaMethodCompletionProposal lazyProposal = new GroovyJavaMethodCompletionProposal(proposal, this.javaContext, this.getProposalOptions());
        lazyProposal.setRelevance(proposal.getRelevance());
        if (proposal.hasParameters()) {
            lazyProposal.setTriggerCharacters(ProposalUtils.METHOD_WITH_ARGUMENTS_TRIGGERS);
        } else {
            lazyProposal.setTriggerCharacters(ProposalUtils.METHOD_TRIGGERS);
        }
        ImportRewrite r = this.groovyRewriter.getImportRewrite(this.monitor);
        if (r != null) {
            ReflectionUtils.setPrivateField(LazyJavaTypeCompletionProposal.class, (String)"fImportRewrite", (Object)((Object)lazyProposal), (Object)r);
        }
        if (this.contextOnly) {
            lazyProposal.contextOnly();
        }
        return lazyProposal;
    }

    private GroovyCompletionProposal createTypeProposal(char[] packageName, int typeModifiers, int accessibility, char[] typeName, char[] fullyQualifiedName, boolean isQualified, char[] typeCompletion, int augmentedModifiers, char[] declarationSignature) {
        GroovyCompletionProposal typeProposal = this.createProposal(9, this.actualCompletionPosition - 1);
        typeProposal.setNameLookup(this.nameLookup);
        typeProposal.setDeclarationSignature(declarationSignature);
        typeProposal.setSignature(CompletionEngine.createNonGenericTypeSignature((char[])packageName, (char[])typeName));
        typeProposal.setPackageName(packageName);
        typeProposal.setTypeName(typeName);
        typeProposal.setFlags(typeModifiers);
        typeProposal.setCompletion(typeCompletion);
        typeProposal.setReplaceRange(this.offset, this.offset + this.replaceLength);
        typeProposal.setTokenRange(this.offset, this.offset + this.replaceLength);
        typeProposal.setRelevance(RelevanceRules.ALL_RULES.getRelevance(fullyQualifiedName, this.allTypesInUnit, accessibility, augmentedModifiers));
        return typeProposal;
    }

    private ProposalFormattingOptions getProposalOptions() {
        if (this.groovyProposalPrefs == null) {
            this.groovyProposalPrefs = ProposalFormattingOptions.newFromOptions();
        }
        return this.groovyProposalPrefs;
    }

    private char[] createConstructorSignature(char[][] parameterTypes, boolean isQualified) {
        Object parameterTypeSigs;
        if (parameterTypes == null) {
            parameterTypeSigs = CharOperation.NO_CHAR_CHAR;
        } else {
            parameterTypeSigs = new char[parameterTypes.length][];
            int i = 0;
            while (i < parameterTypes.length) {
                char[] copy = new char[parameterTypes[i].length];
                System.arraycopy(parameterTypes[i], 0, copy, 0, copy.length);
                CharOperation.replace((char[])copy, (char)'/', (char)'.');
                parameterTypeSigs[i] = Signature.createCharArrayTypeSignature((char[])copy, (boolean)isQualified);
                ++i;
            }
        }
        return Signature.createMethodSignature((char[][])parameterTypeSigs, (char[])new char[]{'V'});
    }

    int computeRelevanceForCaseMatching(char[] token, char[] proposalName) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        return 0;
    }

    protected final GroovyCompletionProposal createProposal(int kind, int completionOffset) {
        GroovyCompletionProposal proposal = new GroovyCompletionProposal(kind, completionOffset);
        proposal.setNameLookup(this.nameLookup);
        return proposal;
    }

    private static class AcceptedConstructor {
        public int modifiers;
        public char[] simpleTypeName;
        public int parameterCount;
        public char[] signature;
        public char[][] parameterTypes;
        public char[][] parameterNames;
        public int typeModifiers;
        public char[] packageName;
        public int extraFlags;
        public int accessibility;

        public AcceptedConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, int accessibility) {
            this.modifiers = modifiers;
            this.simpleTypeName = simpleTypeName;
            this.parameterCount = parameterCount;
            this.signature = signature;
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
            this.typeModifiers = typeModifiers;
            this.packageName = packageName;
            this.extraFlags = extraFlags;
            this.accessibility = accessibility;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('{');
            buffer.append(this.packageName);
            buffer.append(',');
            buffer.append(this.simpleTypeName);
            buffer.append('}');
            return buffer.toString();
        }
    }

    private class AcceptedType {
        public char[] packageName;
        public char[] simpleTypeName;
        public char[][] enclosingTypeNames;
        public int modifiers;
        public int accessibility;
        public boolean mustBeQualified = false;
        public char[] fullyQualifiedName = null;
        public char[] qualifiedTypeName = null;

        AcceptedType(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, int modifiers, int accessibility) {
            this.packageName = packageName;
            this.simpleTypeName = simpleTypeName;
            this.enclosingTypeNames = enclosingTypeNames;
            this.modifiers = modifiers;
            this.accessibility = accessibility;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            buffer.append(this.packageName);
            buffer.append(',');
            buffer.append(this.simpleTypeName);
            buffer.append(',');
            buffer.append(CharOperation.concatWith((char[][])this.enclosingTypeNames, (char)'.'));
            buffer.append('}');
            return buffer.toString();
        }
    }
}

