/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSetMethodCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    public GetSetMethodCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        ContentAssistContext context = this.getContext();
        IType enclosingType = context.getEnclosingType();
        if (enclosingType != null) {
            try {
                IField[] iFieldArray = enclosingType.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    proposals.addAll(this.createProposal(field, context));
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)("Exception looking for proposal providers in " + context.unit.getElementName()), (Throwable)e);
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> createProposal(IField field, ContentAssistContext context) throws JavaModelException {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(2);
        int relevance = Relevance.HIGH.getRelavance();
        IMethod getter = GetterSetterUtil.getGetter((IField)field);
        if (getter == null || !getter.exists()) {
            proposals.add((ICompletionProposal)new GetterSetterCompletionProposal(field, context.completionLocation - context.completionExpression.length(), context.completionExpression.length(), true, relevance));
        }
        IMethod setter = GetterSetterUtil.getSetter((IField)field);
        if (!((field.getFlags() & 0x10) != 0 || setter != null && setter.exists())) {
            proposals.add((ICompletionProposal)new GetterSetterCompletionProposal(field, context.completionLocation - context.completionExpression.length(), context.completionExpression.length(), false, relevance));
        }
        return proposals;
    }
}

