/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCompletionProcessor
extends AbstractGroovyCompletionProcessor
implements ITypeResolver {
    private JDTResolver resolver;

    public ConstructorCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        ContentAssistContext context = this.getContext();
        char[] constructorCompletionText = this.getCompletionText(context.fullCompletionExpression);
        if (constructorCompletionText == null) {
            return Collections.emptyList();
        }
        int completionExprStart = context.location == ContentAssistLocation.METHOD_CONTEXT ? ((MethodInfoContentAssistContext)context).methodNameEnd - ((MethodInfoContentAssistContext)context).methodName.length() : context.completionLocation - constructorCompletionText.length;
        if (completionExprStart < 0) {
            return Collections.emptyList();
        }
        GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), completionExprStart, context.completionEnd - completionExprStart, this.getNameEnvironment().nameLookup, monitor);
        this.getNameEnvironment().findConstructorDeclarations(constructorCompletionText, true, (ISearchRequestor)requestor, monitor);
        List<ICompletionProposal> constructorProposals = requestor.processAcceptedConstructors(this.findUsedParameters(context), this.resolver);
        return constructorProposals;
    }

    private Set<String> findUsedParameters(ContentAssistContext context) {
        if (context.location != ContentAssistLocation.METHOD_CONTEXT) {
            return Collections.emptySet();
        }
        HashSet<String> usedParams = new HashSet<String>();
        ASTNode completionNode = context.completionNode;
        if (completionNode instanceof ConstructorCallExpression) {
            ConstructorCallExpression call = (ConstructorCallExpression)completionNode;
            Expression arguments = call.getArguments();
            if (arguments instanceof TupleExpression) {
                for (Expression maybeArg : ((TupleExpression)arguments).getExpressions()) {
                    if (!(maybeArg instanceof MapExpression)) continue;
                    arguments = maybeArg;
                    break;
                }
            }
            if (arguments instanceof MapExpression) {
                MapExpression enclosingCallArgs = (MapExpression)arguments;
                for (MapEntryExpression entry : enclosingCallArgs.getMapEntryExpressions()) {
                    usedParams.add(entry.getKeyExpression().getText());
                }
            }
        }
        return usedParams;
    }

    private char[] getCompletionText(String fullCompletionExpression) {
        LinkedList<Character> chars = new LinkedList<Character>();
        if (fullCompletionExpression == null) {
            return new char[0];
        }
        char[] fullArray = fullCompletionExpression.toCharArray();
        int newIndex = CharOperation.indexOf((char[])"new ".toCharArray(), (char[])fullArray, (boolean)true) + 4;
        if (newIndex == -1) {
            return null;
        }
        int i = newIndex;
        while (i < fullArray.length) {
            if (!Character.isWhitespace(fullArray[i])) {
                if (Character.isJavaIdentifierPart(fullArray[i]) || fullArray[i] == '.') {
                    chars.add(Character.valueOf(fullArray[i]));
                } else {
                    return null;
                }
            }
            ++i;
        }
        char[] res = new char[chars.size()];
        int i2 = 0;
        for (Character c : chars) {
            res[i2] = c.charValue();
            ++i2;
        }
        return res;
    }

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.resolver = resolver;
    }
}

