/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.preferences;

import java.util.Arrays;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssistActivator;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ContentAssistPreferencesPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    public ContentAssistPreferencesPage() {
        super(0);
        this.setPreferenceStore(GroovyContentAssistActivator.getDefault().getPreferenceStore());
    }

    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.codeassist.completion.editor";
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new CompletionFilterListEditor("Filtered DGMs", "Configure which DefaultGroovyMethods will be filtered from content asist.", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private class CompletionFilterListEditor
    extends ListEditor {
        private Button addMultipleButton;

        public CompletionFilterListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setPreferenceName("org.codehaus.groovy.eclipse.codeassist.completion.filtereddgms");
        }

        protected String createList(String[] items) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                sb.append(String.valueOf(item) + ",");
                ++n2;
            }
            return sb.toString();
        }

        protected String getNewInputObject() {
            InputDialog dialog = new InputDialog(ContentAssistPreferencesPage.this.getFieldEditorParent().getShell(), "Add new DGM to filter", "Select the name of a DefaultGroovyMethod to filter from content assist", "", (IInputValidator)new DGMValidator(null, null));
            int res = dialog.open();
            if (res == 0) {
                return dialog.getValue();
            }
            return null;
        }

        public Composite getButtonBoxControl(Composite parent) {
            Composite buttonBox = super.getButtonBoxControl(parent);
            if (this.addMultipleButton == null) {
                this.addMultipleButton = this.createAddMultipleButton(buttonBox, "Add multiple...");
            }
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return buttonBox;
        }

        private Button createAddMultipleButton(Composite parent, String name) {
            Button button = new Button(parent, 8);
            button.setText(name);
            button.setFont(parent.getFont());
            GridData data = new GridData(768);
            int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
            data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompletionFilterListEditor.this.addMultiple();
                }
            });
            return button;
        }

        protected void addMultiple() {
            Object[] items = this.getList().getItems();
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = objectArray[n2];
                sb.append(String.valueOf(item) + "\n");
                ++n2;
            }
            InputDialog input = new InputDialog(this.getShell(), "Add multiple", "Add/remove multiple entrie.  Enter one DGM name per line.", sb.toString(), new MultiDGMValidator()){

                protected int getInputTextStyle() {
                    return 2050;
                }

                protected Control createDialogArea(Composite parent) {
                    Control child = super.createDialogArea(parent);
                    this.getText().setLayoutData((Object)new GridData(1808));
                    return child;
                }
            };
            int res = input.open();
            if (res == 0) {
                String text = input.getValue();
                items = text.split("\\n");
                Arrays.sort(items);
                this.getList().setItems((String[])items);
                this.getList().deselectAll();
                this.selectionChanged();
            }
        }

        protected String[] parseString(String stringList) {
            Object[] split = stringList.split(",");
            Arrays.sort(split);
            return split;
        }
    }

    private class DGMValidator
    implements IInputValidator {
        private DGMValidator() {
        }

        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "";
            }
            String[] complianceLevels = JavaConventionsUtil.getSourceComplianceLevels(null);
            IStatus s = JavaConventions.validateMethodName((String)newText, (String)complianceLevels[0], (String)complianceLevels[1]);
            if (s.getSeverity() > 0) {
                return s.getMessage();
            }
            return null;
        }

        /* synthetic */ DGMValidator(DGMValidator dGMValidator, DGMValidator dGMValidator2) {
            this();
        }
    }

    private class MultiDGMValidator
    extends DGMValidator {
        private MultiDGMValidator() {
        }

        public String isValid(String newText) {
            String[] splits = newText.split("\\n");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = splits;
            int n = splits.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                String res = super.isValid(split);
                if (res != null) {
                    sb.append(res);
                }
                ++n2;
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }
}

