/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodProposalCreator
extends AbstractProposalCreator
implements IProposalCreator {
    ProposalFormattingOptions options = ProposalFormattingOptions.newFromOptions();
    private Set<ClassNode> alreadySeen = Collections.emptySet();

    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode type, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        ClassNode enclosingTypeDeclaration;
        boolean firstTime = this.alreadySeen.isEmpty();
        List<MethodNode> allMethods = this.getAllMethods(type);
        LinkedList<IGroovyProposal> groovyProposals = new LinkedList<IGroovyProposal>();
        HashSet<String> alreadySeenFields = new HashSet<String>();
        if (isStatic) {
            alreadySeenFields.add("class");
        }
        for (MethodNode method : allMethods) {
            String mockFieldName;
            AccessorSupport accessor;
            String methodName = method.getName();
            if (isStatic && !method.isStatic() && method.getDeclaringClass() != VariableScope.OBJECT_CLASS_NODE || !this.checkName(methodName)) continue;
            boolean isInterestingType = false;
            isInterestingType = isStatic && method.isStatic() ? true : this.isInterestingType(method.getReturnType());
            if (ProposalUtils.looselyMatches(prefix, methodName)) {
                GroovyMethodProposal methodProposal = new GroovyMethodProposal(method, "Groovy", this.options);
                float relevanceMultiplier = isInterestingType ? 101.0f : 1.0f;
                relevanceMultiplier *= method.isStatic() ? 0.1f : 1.0f;
                methodProposal.setRelevanceMultiplier(relevanceMultiplier *= !this.alreadySeen.isEmpty() ? 0.1f : 1.0f);
                groovyProposals.add(methodProposal);
            }
            if (!(accessor = this.findLooselyMatchedAccessorKind(prefix, methodName, false)).isAccessorKind(method, false) || alreadySeenFields.contains(mockFieldName = ProposalUtils.createMockFieldName(methodName))) continue;
            alreadySeenFields.add(mockFieldName);
            if (!this.hasNoField(method.getDeclaringClass(), methodName)) continue;
            GroovyFieldProposal fieldProposal = new GroovyFieldProposal(this.createMockField(method));
            fieldProposal.setRelevanceMultiplier(isInterestingType ? 11 : 1);
            groovyProposals.add(fieldProposal);
        }
        if (this.currentScope != null && (enclosingTypeDeclaration = this.currentScope.getEnclosingTypeDeclaration()) != null && firstTime && isPrimary && type.getModule() != null) {
            groovyProposals.addAll(this.getStaticImportProposals(prefix, type.getModule()));
        }
        return groovyProposals;
    }

    protected List<MethodNode> getAllMethods(ClassNode thisType) {
        HashSet<ClassNode> types = new HashSet<ClassNode>();
        List allMethods = thisType.getAllDeclaredMethods();
        if (!this.alreadySeen.isEmpty()) {
            Iterator methodIter = allMethods.iterator();
            while (methodIter.hasNext()) {
                if (!this.alreadySeen.contains(((MethodNode)methodIter.next()).getDeclaringClass())) continue;
                methodIter.remove();
            }
        }
        this.getAllSupers(thisType, types, this.alreadySeen);
        if (this.alreadySeen.isEmpty()) {
            this.alreadySeen = types;
        } else {
            this.alreadySeen.addAll(types);
        }
        return allMethods;
    }

    private List<IGroovyProposal> getStaticImportProposals(String prefix, ModuleNode module) {
        ArrayList<IGroovyProposal> staticProposals = new ArrayList<IGroovyProposal>();
        Map staticImports = ImportNodeCompatibilityWrapper.getStaticImports((ModuleNode)module);
        for (Map.Entry entry : staticImports.entrySet()) {
            List methods;
            String fieldName = ((ImportNode)entry.getValue()).getFieldName();
            if (fieldName == null || !ProposalUtils.looselyMatches(prefix, fieldName) || (methods = ((ImportNode)entry.getValue()).getType().getDeclaredMethods(fieldName)) == null) continue;
            for (MethodNode method : methods) {
                staticProposals.add(new GroovyMethodProposal(method, "Groovy", this.options));
            }
        }
        Map staticStarImports = ImportNodeCompatibilityWrapper.getStaticStarImports((ModuleNode)module);
        for (Map.Entry entry : staticStarImports.entrySet()) {
            ClassNode type = ((ImportNode)entry.getValue()).getType();
            if (type == null) continue;
            for (MethodNode method : type.getMethods()) {
                if (!method.isStatic() || !ProposalUtils.looselyMatches(prefix, method.getName())) continue;
                staticProposals.add(new GroovyMethodProposal(method, "Groovy", this.options));
            }
        }
        return staticProposals;
    }
}

