/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldProposalCreator
extends AbstractProposalCreator
implements IProposalCreator {
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private static final ClassNode[] NO_CLASSES = new ClassNode[0];
    private static final GroovyFieldProposal CLASS_PROPOSAL = FieldProposalCreator.createClassProposal();
    private Set<ClassNode> alreadySeen = Collections.emptySet();

    private static GroovyFieldProposal createClassProposal() {
        FieldNode field = new FieldNode("class", 0, VariableScope.CLASS_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, null);
        field.setDeclaringClass(VariableScope.OBJECT_CLASS_NODE);
        return new GroovyFieldProposal(field);
    }

    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode type, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        ClassNode enclosingTypeDeclaration;
        boolean isFirstTime = this.alreadySeen.isEmpty();
        Collection<FieldNode> allFields = this.getAllFields(type);
        LinkedList<IGroovyProposal> groovyProposals = new LinkedList<IGroovyProposal>();
        for (FieldNode field : allFields) {
            if (isStatic && !field.isStatic() || !ProposalUtils.looselyMatches(prefix, field.getName())) continue;
            GroovyFieldProposal fieldProposal = new GroovyFieldProposal(field);
            float relevanceMultiplier = this.isInterestingType(field.getType()) ? 101.0f : 1.0f;
            relevanceMultiplier = (float)((double)relevanceMultiplier * (field.isStatic() ? 0.1 : 1.0));
            relevanceMultiplier = (float)((double)relevanceMultiplier * (!isFirstTime ? 0.1 : 1.0));
            fieldProposal.setRelevanceMultiplier(relevanceMultiplier);
            groovyProposals.add(fieldProposal);
            if (!(field.getInitialExpression() instanceof ClosureExpression)) continue;
            groovyProposals.add(new GroovyMethodProposal(this.convertToMethodProposal(field)));
        }
        if (isStatic && "class".startsWith(prefix)) {
            groovyProposals.add(CLASS_PROPOSAL);
        }
        if (this.currentScope != null && (enclosingTypeDeclaration = this.currentScope.getEnclosingTypeDeclaration()) != null && isFirstTime && isPrimary && type.getModule() != null) {
            groovyProposals.addAll(this.getStaticImportProposals(prefix, type.getModule()));
        }
        return groovyProposals;
    }

    private MethodNode convertToMethodProposal(FieldNode field) {
        MethodNode method = new MethodNode(field.getName(), field.getModifiers(), field.getType(), this.extractParameters(field.getInitialExpression()), NO_CLASSES, (Statement)new BlockStatement());
        method.setDeclaringClass(field.getDeclaringClass());
        return method;
    }

    private Parameter[] extractParameters(Expression expr) {
        if (expr instanceof ClosureExpression) {
            return ((ClosureExpression)expr).getParameters();
        }
        return NO_PARAMETERS;
    }

    private List<IGroovyProposal> getStaticImportProposals(String prefix, ModuleNode module) {
        ArrayList<IGroovyProposal> staticProposals = new ArrayList<IGroovyProposal>();
        Map staticImports = ImportNodeCompatibilityWrapper.getStaticImports((ModuleNode)module);
        for (Map.Entry entry : staticImports.entrySet()) {
            FieldNode field;
            String fieldName = ((ImportNode)entry.getValue()).getFieldName();
            if (fieldName == null || !ProposalUtils.looselyMatches(prefix, fieldName) || (field = ((ImportNode)entry.getValue()).getType().getField(fieldName)) == null) continue;
            staticProposals.add(new GroovyFieldProposal(field));
        }
        Map staticStarImports = ImportNodeCompatibilityWrapper.getStaticStarImports((ModuleNode)module);
        for (Map.Entry entry : staticStarImports.entrySet()) {
            ClassNode type = ((ImportNode)entry.getValue()).getType();
            if (type == null) continue;
            for (FieldNode field : type.getFields()) {
                if (!field.isStatic() || !ProposalUtils.looselyMatches(prefix, field.getName())) continue;
                staticProposals.add(new GroovyFieldProposal(field));
            }
        }
        return staticProposals;
    }

    private Collection<FieldNode> getAllFields(ClassNode thisType) {
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        this.getAllSupers(thisType, types, this.alreadySeen);
        HashMap<String, FieldNode> nameFieldMap = new HashMap<String, FieldNode>();
        for (ClassNode type : types) {
            for (FieldNode field : type.getFields()) {
                FieldNode existing;
                if (!this.checkName(field.getName()) || (existing = (FieldNode)nameFieldMap.get(field.getName())) != null && !this.leftIsMoreAccessible(field, existing)) continue;
                nameFieldMap.put(field.getName(), field);
            }
        }
        if (this.alreadySeen.isEmpty()) {
            this.alreadySeen = types;
        } else {
            this.alreadySeen.addAll(types);
        }
        return nameFieldMap.values();
    }

    private boolean leftIsMoreAccessible(FieldNode field, FieldNode existing) {
        int rightAcc;
        int leftAcc;
        switch (field.getModifiers() & 7) {
            case 1: {
                leftAcc = 0;
                break;
            }
            case 4: {
                leftAcc = 1;
                break;
            }
            case 2: {
                leftAcc = 3;
                break;
            }
            default: {
                leftAcc = 2;
            }
        }
        switch (existing.getModifiers() & 7) {
            case 1: {
                rightAcc = 0;
                break;
            }
            case 4: {
                rightAcc = 1;
                break;
            }
            case 2: {
                rightAcc = 3;
                break;
            }
            default: {
                rightAcc = 2;
            }
        }
        return leftAcc < rightAcc;
    }
}

