/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.preferences.DGMProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyCategoryMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryProposalCreator
extends AbstractProposalCreator {
    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode type, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        ClassNode candidate = GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)type);
        HashSet<String> set = new HashSet<String>();
        this.getAllSupersAsStrings(candidate, set);
        set.add("java.lang.Object");
        List<IGroovyProposal> groovyProposals = this.findAllProposals(set, categories, prefix, candidate);
        return groovyProposals;
    }

    private List<IGroovyProposal> findAllProposals(Set<String> set, Set<ClassNode> categories, String prefix, ClassNode declaringClass) {
        DGMProposalFilter filter = new DGMProposalFilter();
        LinkedList<IGroovyProposal> groovyProposals = new LinkedList<IGroovyProposal>();
        HashSet<String> existingFieldProposals = new HashSet<String>();
        HashMap<String, List<MethodNode>> existingMethodProposals = new HashMap<String, List<MethodNode>>();
        for (ClassNode category : categories) {
            List allMethods = category.getAllDeclaredMethods();
            boolean isDGMCategory = this.isDGMCategory(category);
            for (MethodNode method : allMethods) {
                if (isDGMCategory && filter.isFiltered(method)) continue;
                String methodName = method.getName();
                if (!method.isStatic() || !method.isPublic()) continue;
                Parameter[] params = method.getParameters();
                if (ProposalUtils.looselyMatches(prefix, methodName)) {
                    if (params == null || params.length <= 0 || !set.contains(params[0].getType().getName()) || this.dupMethod(method, existingMethodProposals)) continue;
                    GroovyCategoryMethodProposal methodProposal = new GroovyCategoryMethodProposal(method);
                    methodProposal.setRelevanceMultiplier(this.isInterestingType(method.getReturnType()) ? 101 : 1);
                    groovyProposals.add(methodProposal);
                    ArrayList<MethodNode> methodList = (ArrayList<MethodNode>)existingMethodProposals.get(methodName);
                    if (methodList == null) {
                        methodList = new ArrayList<MethodNode>(2);
                        existingMethodProposals.put(methodName, methodList);
                    }
                    methodList.add(method);
                    continue;
                }
                if (params.length != 1 || !this.findLooselyMatchedAccessorKind(prefix, methodName, true).isAccessorKind(method, true) || existingFieldProposals.contains(methodName) || !this.hasNoField(declaringClass, methodName)) continue;
                GroovyFieldProposal fieldProposal = new GroovyFieldProposal(this.createMockField(method));
                fieldProposal.setRelevanceMultiplier(1.0f);
                groovyProposals.add(fieldProposal);
                existingFieldProposals.add(methodName);
            }
        }
        return groovyProposals;
    }

    private boolean dupMethod(MethodNode newMethod, Map<String, List<MethodNode>> existingMethodProposals) {
        List<MethodNode> otherMethods = existingMethodProposals.get(newMethod.getName());
        if (otherMethods != null) {
            Parameter[] newParameters = newMethod.getParameters();
            for (MethodNode otherMethod : otherMethods) {
                Parameter[] otherParameters = otherMethod.getParameters();
                if (otherParameters.length != newParameters.length) continue;
                int i = 1;
                while (i < otherParameters.length) {
                    if (!otherParameters[i].getType().getName().equals(newParameters[i].getType().getName())) {
                        // empty if block
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isDGMCategory(ClassNode category) {
        String className = category.getName();
        for (ClassNode dgClass : VariableScope.ALL_DEFAULT_CATEGORIES) {
            if (!dgClass.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean redoForLoopClosure() {
        return true;
    }
}

