/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProposalCreator
implements IProposalCreator {
    protected ClassNode lhsType;
    protected VariableScope currentScope;

    protected boolean checkName(String name) {
        return name.charAt(0) != '<' && !name.contains("$");
    }

    protected void getAllSupers(ClassNode type, Set<ClassNode> set, Set<ClassNode> except) {
        if (type == null) {
            return;
        }
        if (!except.contains(type)) {
            set.add(type);
        }
        this.getAllSupers(type.getSuperClass(), set, except);
        for (ClassNode inter : type.getAllInterfaces()) {
            if (inter.getName().equals(type.getName())) continue;
            this.getAllSupers(inter, set, except);
        }
    }

    protected boolean isInterestingType(ClassNode type) {
        return this.lhsType != null && ClassHelper.getUnwrapper((ClassNode)type).equals((Object)this.lhsType);
    }

    protected void getAllSupersAsStrings(ClassNode type, Set<String> set) {
        if (type == null) {
            return;
        }
        set.add(type.getName());
        this.getAllSupersAsStrings(type.getSuperClass(), set);
        for (ClassNode inter : type.getAllInterfaces()) {
            if (inter.getName().equals(type.getName())) continue;
            this.getAllSupersAsStrings(inter, set);
        }
    }

    public void setLhsType(ClassNode lhsType) {
        this.lhsType = lhsType;
    }

    public void setCurrentScope(VariableScope currentScope) {
        this.currentScope = currentScope;
    }

    protected boolean hasNoField(ClassNode declaringClass, String methodName) {
        return declaringClass.getField(ProposalUtils.createMockFieldName(methodName)) == null && declaringClass.getField(ProposalUtils.createCapitalMockFieldName(methodName)) == null;
    }

    protected FieldNode createMockField(MethodNode method) {
        FieldNode field = new FieldNode(ProposalUtils.createMockFieldName(method.getName()), method.getModifiers(), method.getReturnType(), method.getDeclaringClass(), null);
        field.setDeclaringClass(method.getDeclaringClass());
        field.setSourcePosition((ASTNode)method);
        return field;
    }

    protected AccessorSupport findLooselyMatchedAccessorKind(String prefix, String methodName, boolean isCategory) {
        AccessorSupport accessor = AccessorSupport.create((String)methodName, (boolean)isCategory);
        if (accessor.isAccessor()) {
            String newName = ProposalUtils.createMockFieldName(methodName);
            return ProposalUtils.looselyMatches(prefix, newName) ? accessor : AccessorSupport.NONE;
        }
        return AccessorSupport.NONE;
    }

    @Override
    public boolean redoForLoopClosure() {
        return true;
    }
}

