/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import java.lang.reflect.Method;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ParameterGuesserDelegate {
    private static final String CLOSURE_TEXT = "{  }";
    private static final String EMPTY_STRING = "\"\"";
    private static final String NULL_TEXT = "null";
    private ParameterGuesser guesser;
    private static Method parameterProposalsMethod;

    public ParameterGuesserDelegate(IJavaElement enclosingElement) {
        this.guesser = new ParameterGuesser(enclosingElement);
    }

    public ICompletionProposal[] parameterProposals(String parameterType, String paramName, Position position, IJavaElement[] assignable, boolean fillBestGuess) {
        parameterType = this.convertToPrimitive(parameterType);
        Method method = ParameterGuesserDelegate.findParameterProposalsMethod();
        try {
            IType declaring;
            ICompletionProposal[] allCompletions = method.getParameterTypes().length == 5 ? (ICompletionProposal[])method.invoke((Object)this.guesser, parameterType, paramName, position, assignable, fillBestGuess) : (ICompletionProposal[])method.invoke((Object)this.guesser, parameterType, paramName, position, assignable, fillBestGuess, false);
            if (allCompletions != null && allCompletions.length > 0 && assignable != null && assignable.length > 0 && (declaring = (IType)assignable[0].getAncestor(7)) != null && declaring.isEnum()) {
                boolean useFull = true;
                int i = 0;
                while (i < assignable.length && i < allCompletions.length) {
                    if (assignable[i].getElementType() == 8) {
                        if (useFull) {
                            String newReplacement = String.valueOf(declaring.getElementName()) + '.' + assignable[i].getElementName();
                            ReflectionUtils.setPrivateField(PositionBasedCompletionProposal.class, (String)"fReplacementString", (Object)allCompletions[i], (Object)newReplacement);
                            ReflectionUtils.setPrivateField(PositionBasedCompletionProposal.class, (String)"fDisplayString", (Object)allCompletions[i], (Object)newReplacement);
                            useFull = false;
                        } else {
                            useFull = true;
                        }
                    }
                    ++i;
                }
            }
            return this.addExtras(allCompletions, parameterType, position);
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Exception trying to reflectively invoke 'parameterProposals' method.", (Throwable)e);
            return ProposalUtils.NO_COMPLETIONS;
        }
    }

    private String convertToPrimitive(String parameterType) {
        if ("java.lang.Short".equals(parameterType)) {
            return "short";
        }
        if ("java.lang.Integer".equals(parameterType)) {
            return "int";
        }
        if ("java.lang.Long".equals(parameterType)) {
            return "long";
        }
        if ("java.lang.Float".equals(parameterType)) {
            return "float";
        }
        if ("java.lang.Double".equals(parameterType)) {
            return "double";
        }
        if ("java.lang.Character".equals(parameterType)) {
            return "char";
        }
        if ("java.lang.Byte".equals(parameterType)) {
            return "byte";
        }
        if ("java.lang.Boolean".equals(parameterType)) {
            return "boolean";
        }
        return parameterType;
    }

    private static Method findParameterProposalsMethod() {
        if (parameterProposalsMethod == null) {
            try {
                parameterProposalsMethod = ParameterGuesser.class.getMethod("parameterProposals", String.class, String.class, Position.class, IJavaElement[].class, Boolean.TYPE);
            }
            catch (SecurityException e) {
                GroovyCore.logException((String)"Exception trying to reflectively find 'parameterProposals' method.", (Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    parameterProposalsMethod = ParameterGuesser.class.getMethod("parameterProposals", String.class, String.class, Position.class, IJavaElement[].class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (SecurityException e1) {
                    GroovyCore.logException((String)"Exception trying to reflectively find 'parameterProposals' method.", (Throwable)e1);
                }
                catch (NoSuchMethodException e1) {
                    GroovyCore.logException((String)"Exception trying to reflectively find 'parameterProposals' method.", (Throwable)e1);
                }
            }
        }
        return parameterProposalsMethod;
    }

    private ICompletionProposal[] addExtras(ICompletionProposal[] parameterProposals, String expectedType, Position position) {
        PositionBasedCompletionProposal proposal = null;
        if (expectedType.equals(VariableScope.STRING_CLASS_NODE.getName())) {
            proposal = new PositionBasedCompletionProposal(EMPTY_STRING, position, 1);
        } else if (expectedType.equals(VariableScope.CLOSURE_CLASS.getName())) {
            proposal = new PositionBasedCompletionProposal(CLOSURE_TEXT, position, 2);
        }
        if (proposal != null) {
            int origLen = parameterProposals.length;
            if (parameterProposals[origLen - 1].getDisplayString().equals(NULL_TEXT)) {
                parameterProposals[origLen - 1] = proposal;
            } else {
                ICompletionProposal[] newProps = new ICompletionProposal[origLen + 1];
                System.arraycopy(parameterProposals, 0, newProps, 0, origLen);
                parameterProposals = newProps;
                parameterProposals[origLen] = proposal;
            }
        }
        return parameterProposals;
    }
}

