/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.ParameterGuesserDelegate;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class NamedParameterProposal
extends JavaCompletionProposal {
    private static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private IRegion selectedRegion;
    private final CompletionContext coreContext;
    private final boolean tryParamGuessing;
    private ICompletionProposal[] choices;
    private Position paramNamePosition;
    private IPositionUpdater updater;
    private String paramSignature;
    private final String paramName;

    public NamedParameterProposal(String paramName, String paramSignature, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc, JavaContentAssistInvocationContext invocationContext, boolean tryParamGuessing) {
        super(NamedParameterProposal.computeReplacementString(paramName), replacementOffset, replacementLength, image, displayString, relevance, inJavadoc, invocationContext);
        this.tryParamGuessing = tryParamGuessing;
        this.coreContext = invocationContext.getCoreContext();
        this.paramName = paramName;
        this.paramSignature = paramSignature;
        this.setTriggerCharacters(ProposalUtils.VAR_TRIGGER);
    }

    private String computeReplacementChoices(String name) {
        if (this.shouldDoGuessing()) {
            try {
                this.choices = this.guessParameters(this.paramName.toCharArray());
            }
            catch (JavaModelException e) {
                this.paramNamePosition = null;
                this.choices = null;
                JavaPlugin.log((Throwable)e);
                this.openErrorDialog((Exception)((Object)e));
            }
        }
        return NamedParameterProposal.computeReplacementString(name);
    }

    private static String computeReplacementString(String name) {
        return String.valueOf(name) + ": __, ";
    }

    private IRegion calculateArgumentRegion() {
        String repl = this.getReplacementString();
        int replOffset = this.getReplacementOffset();
        int start = replOffset + repl.indexOf(": ") + 2;
        int end = replOffset + repl.indexOf(",");
        if (start > 0 && end > 0) {
            return new Region(start, end - start);
        }
        return null;
    }

    private boolean shouldDoGuessing() {
        return this.tryParamGuessing && this.coreContext.isExtended();
    }

    private ICompletionProposal[] guessParameters(char[] parameterName) throws JavaModelException {
        if (this.paramSignature == null) {
            return NO_COMPLETIONS;
        }
        String type = Signature.toString((String)this.paramSignature);
        IJavaElement[] assignableElements = this.getAssignableElements();
        Position position = new Position(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
        ICompletionProposal[] argumentProposals = new ParameterGuesserDelegate(this.getEnclosingElement()).parameterProposals(type, this.paramName, position, assignableElements, this.tryParamGuessing);
        if (argumentProposals.length == 0) {
            argumentProposals = new ICompletionProposal[]{new JavaCompletionProposal(this.paramName, 0, this.paramName.length(), null, this.paramName, 0)};
        }
        this.paramNamePosition = position;
        this.choices = argumentProposals;
        return argumentProposals;
    }

    private IJavaElement getEnclosingElement() {
        return this.coreContext.getEnclosingElement();
    }

    private IJavaElement[] getAssignableElements() {
        return this.coreContext.getVisibleElements(this.paramSignature);
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        if (this.selectedRegion == null) {
            this.selectedRegion = this.calculateArgumentRegion();
        }
        this.setUpLinkedMode(document, ',');
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        ITextViewer textViewer = this.getTextViewer();
        if (textViewer != null) {
            int baseOffset = this.getReplacementOffset();
            String replacement = this.computeReplacementChoices(this.paramName);
            try {
                LinkedModeModel model = new LinkedModeModel();
                IRegion argRegion = this.calculateArgumentRegion();
                LinkedPositionGroup group = new LinkedPositionGroup();
                if (this.shouldDoGuessing()) {
                    this.ensurePositionCategoryInstalled(document, model);
                    document.addPosition(this.getCategory(), this.paramNamePosition);
                    group.addPosition((LinkedPosition)new ProposalPosition(document, this.paramNamePosition.getOffset(), this.paramNamePosition.getLength(), -1, this.choices));
                } else {
                    group.addPosition(new LinkedPosition(document, argRegion.getOffset(), argRegion.getLength(), -1));
                }
                model.addGroup(group);
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, textViewer);
                ui.setExitPosition(textViewer, baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(closingCharacter, document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.selectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                this.ensurePositionCategoryRemoved(document);
                JavaPlugin.log((Throwable)e);
                this.openErrorDialog((Exception)((Object)e));
            }
            catch (BadPositionCategoryException e) {
                this.ensurePositionCategoryRemoved(document);
                JavaPlugin.log((Throwable)e);
                this.openErrorDialog((Exception)((Object)e));
            }
        }
    }

    public Point getSelection(IDocument document) {
        if (this.selectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)"Error inserting parameters", (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    NamedParameterProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.updater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    public ICompletionProposal[] getChoices() throws JavaModelException {
        this.selectedRegion = this.calculateArgumentRegion();
        return this.guessParameters(this.paramName.toCharArray());
    }
}

