/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.Statement;

public class NamedArgsMethodNode
extends MethodNode {
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private final Parameter[] regularParams;
    private final Parameter[] namedParams;
    private final Parameter[] optionalParams;
    private Parameter[] visibleParams;

    public NamedArgsMethodNode(String name, int modifiers, ClassNode returnType, Parameter[] regularParams, Parameter[] namedParams, Parameter[] optionalParams, ClassNode[] exceptions, Statement code) {
        super(name, modifiers, returnType, NamedArgsMethodNode.concatParams(regularParams, namedParams, optionalParams), exceptions, code);
        this.regularParams = regularParams;
        this.namedParams = namedParams;
        this.optionalParams = optionalParams;
    }

    private static Parameter[] concatParams(Parameter[] regularParams, Parameter[] namedParams, Parameter[] optionalParams) {
        regularParams = regularParams == null ? NO_PARAMETERS : regularParams;
        namedParams = namedParams == null ? NO_PARAMETERS : namedParams;
        optionalParams = optionalParams == null ? NO_PARAMETERS : optionalParams;
        Parameter[] allParams = new Parameter[regularParams.length + namedParams.length + optionalParams.length];
        System.arraycopy(regularParams, 0, allParams, 0, regularParams.length);
        System.arraycopy(namedParams, 0, allParams, regularParams.length, namedParams.length);
        System.arraycopy(optionalParams, 0, allParams, regularParams.length + namedParams.length, optionalParams.length);
        return allParams;
    }

    public Parameter[] getRegularParams() {
        return this.regularParams;
    }

    public Parameter[] getNamedParams() {
        return this.namedParams;
    }

    public Parameter[] getOptionalParams() {
        return this.optionalParams;
    }

    public Parameter[] getVisibleParams() {
        if (this.visibleParams == null) {
            this.visibleParams = new Parameter[this.regularParams.length + this.namedParams.length];
            System.arraycopy(this.regularParams, 0, this.visibleParams, 0, this.regularParams.length);
            System.arraycopy(this.namedParams, 0, this.visibleParams, this.regularParams.length, this.namedParams.length);
        }
        return this.visibleParams;
    }
}

