/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class GroovyJavaMethodCompletionProposal
extends JavaMethodCompletionProposal {
    private static final String CLOSURE_TEXT = "{  }";
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;
    private IRegion fSelectedRegion;
    private final ProposalFormattingOptions proposalOptions;
    private String contributor;
    private boolean contextOnly;

    public GroovyJavaMethodCompletionProposal(GroovyCompletionProposal proposal, JavaContentAssistInvocationContext context, ProposalFormattingOptions groovyFormatterPrefs) {
        super((CompletionProposal)proposal, context);
        this.proposalOptions = groovyFormatterPrefs;
        this.contributor = "Groovy";
        this.setRelevance(proposal.getRelevance());
        if (proposal.hasParameters()) {
            this.setTriggerCharacters(ProposalUtils.METHOD_WITH_ARGUMENTS_TRIGGERS);
        } else {
            this.setTriggerCharacters(ProposalUtils.METHOD_TRIGGERS);
        }
    }

    public GroovyJavaMethodCompletionProposal(GroovyCompletionProposal proposal, JavaContentAssistInvocationContext context, ProposalFormattingOptions groovyFormatterPrefs, String contributor) {
        this(proposal, context, groovyFormatterPrefs);
        this.contributor = contributor;
    }

    public void contextOnly() {
        this.contextOnly = true;
    }

    protected StyledString computeDisplayString() {
        return super.computeDisplayString().append(this.getStyledGroovy());
    }

    protected IContextInformation computeContextInformation() {
        if ((this.fProposal.getKind() == 6 || this.fProposal.getKind() == 26) && this.hasParameters()) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    private StyledString getStyledGroovy() {
        return new StyledString(" (" + this.contributor + ")", StyledString.DECORATIONS_STYLER);
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
                this.openErrorDialog(e);
            }
        }
    }

    protected String computeReplacementString() {
        if (this.contextOnly) {
            return "";
        }
        char[] proposalName = this.fProposal.getName();
        boolean hasWhitespace = false;
        int i = 0;
        while (i < proposalName.length) {
            if (CharOperation.isWhitespace((char)proposalName[i])) {
                hasWhitespace = true;
            }
            ++i;
        }
        if (!(this.hasParameters() && this.hasArgumentList() || hasWhitespace)) {
            String replacementString = super.computeReplacementString();
            if (replacementString.endsWith(");")) {
                replacementString = replacementString.substring(0, replacementString.length() - 1);
            }
            return replacementString;
        }
        StringBuffer buffer = new StringBuffer();
        char[] newProposalName = hasWhitespace ? CharOperation.concat((char[])new char[]{'\"'}, (char[])CharOperation.append((char[])proposalName, (char)'\"')) : proposalName;
        this.fProposal.setName(newProposalName);
        this.appendMethodNameReplacement(buffer);
        this.fProposal.setName(proposalName);
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (this.hasParameters()) {
            int indexOfLastClosure = -1;
            char[][] regularParameterTypes = ((GroovyCompletionProposal)this.fProposal).getRegularParameterTypeNames();
            char[][] namedParameterTypes = ((GroovyCompletionProposal)this.fProposal).getNamedParameterTypeNames();
            if (this.proposalOptions.noParensAroundClosures) {
                if (this.lastArgIsClosure(regularParameterTypes, namedParameterTypes)) {
                    indexOfLastClosure = regularParameterTypes.length + namedParameterTypes.length - 1;
                }
                if (indexOfLastClosure == 0) {
                    buffer.replace(buffer.length() - 1, buffer.length(), "");
                    if (!prefs.beforeOpeningParen) {
                        buffer.append(" ");
                    }
                }
            } else if (prefs.afterOpeningParen) {
                buffer.append(" ");
            }
            char[][] namedParameterNames = ((GroovyCompletionProposal)this.fProposal).getNamedParameterNames();
            char[][] regularParameterNames = ((GroovyCompletionProposal)this.fProposal).getRegularParameterNames();
            int namedCount = namedParameterNames.length;
            int argCount = regularParameterNames.length;
            int allCount = argCount + namedCount;
            this.fArgumentOffsets = new int[allCount];
            this.fArgumentLengths = new int[allCount];
            int i2 = 0;
            while (i2 < allCount) {
                char[] nextTypeName;
                char[] nextName;
                if (i2 < namedCount) {
                    nextName = namedParameterNames[i2];
                    nextTypeName = namedParameterNames[i2];
                } else {
                    nextTypeName = regularParameterTypes[i2 - namedCount];
                    nextName = regularParameterNames[i2 - namedCount];
                }
                if (this.proposalOptions.useNamedArguments || i2 < namedCount) {
                    buffer.append(nextName).append(":");
                }
                this.fArgumentOffsets[i2] = buffer.length();
                if (i2 == 0) {
                    this.setCursorPosition(buffer.length());
                }
                if (this.proposalOptions.useBracketsForClosures && CharOperation.equals((char[])"Closure".toCharArray(), (char[])nextTypeName)) {
                    this.fArgumentOffsets[i2] = buffer.length() + 2;
                    this.fArgumentLengths[i2] = 0;
                    buffer.append(CLOSURE_TEXT);
                } else {
                    this.fArgumentOffsets[i2] = buffer.length();
                    buffer.append(nextName);
                    this.fArgumentLengths[i2] = nextName.length;
                }
                if (i2 == indexOfLastClosure - 1 || i2 != indexOfLastClosure && i2 == allCount - 1) {
                    if (prefs.beforeClosingParen) {
                        buffer.append(" ");
                    }
                    buffer.append(")");
                    if (i2 == indexOfLastClosure - 1) {
                        buffer.append(" ");
                    }
                } else if (i2 < allCount - 1) {
                    if (prefs.beforeComma) {
                        buffer.append(" ");
                    }
                    buffer.append(",");
                    if (prefs.afterComma) {
                        buffer.append(" ");
                    }
                }
                ++i2;
            }
        } else {
            if (prefs.inEmptyList) {
                buffer.append(" ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    private boolean lastArgIsClosure(char[][] regularparameterTypes, char[][] namedParameterTypes) {
        char[] lastArgType;
        if (namedParameterTypes != null && namedParameterTypes.length > 0) {
            lastArgType = namedParameterTypes[namedParameterTypes.length - 1];
        } else if (regularparameterTypes != null && regularparameterTypes.length > 0) {
            lastArgType = regularparameterTypes[regularparameterTypes.length - 1];
        } else {
            return false;
        }
        return CharOperation.equals((char[])"Closure".toCharArray(), (char[])lastArgType);
    }

    protected boolean needsLinkedMode() {
        return super.needsLinkedMode();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)"Error inserting parameters", (String)e.getMessage());
    }
}

