/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import org.codehaus.groovy.eclipse.codeassist.completions.ParameterGuesserDelegate;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class GroovyJavaGuessingCompletionProposal
extends JavaMethodCompletionProposal {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ResultCollector"));
    private static final String LAST_CLOSURE_TEXT = "{";
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;
    private final boolean fFillBestGuess;
    private final CompletionContext fCoreContext;
    private final ProposalFormattingOptions proposalOptions;
    private final String contributor;
    private String[] cachedVisibleParameterTypes = null;

    public static GroovyJavaGuessingCompletionProposal createProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, boolean fillBestGuess, String contributor, ProposalFormattingOptions options) {
        CompletionContext coreContext = context.getCoreContext();
        if (coreContext != null && coreContext.isExtended()) {
            return new GroovyJavaGuessingCompletionProposal(proposal, context, coreContext, fillBestGuess, contributor, options);
        }
        return null;
    }

    private GroovyJavaGuessingCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, CompletionContext coreContext, boolean fillBestGuess, String contributor, ProposalFormattingOptions proposalOptions) {
        super(proposal, context);
        this.fCoreContext = coreContext;
        this.fFillBestGuess = fillBestGuess;
        this.contributor = contributor;
        this.proposalOptions = proposalOptions;
    }

    protected int computeRelevance() {
        return this.fProposal.getRelevance();
    }

    private IJavaElement getEnclosingElement() {
        return this.fCoreContext.getEnclosingElement();
    }

    private String[] getParameterTypes() {
        if (this.cachedVisibleParameterTypes == null) {
            char[] signature = SignatureUtil.fix83600((char[])this.fProposal.getSignature());
            char[][] types = Signature.getParameterTypes((char[])signature);
            String[] ret = new String[types.length];
            int i = 0;
            while (i < types.length) {
                ret[i] = new String(Signature.toCharArray((char[])types[i]));
                ++i;
            }
            this.cachedVisibleParameterTypes = ret;
        }
        return this.cachedVisibleParameterTypes;
    }

    private IJavaElement[][] getAssignableElements() {
        String[] parameterTypes = this.getParameterTypes();
        IJavaElement[][] assignableElements = new IJavaElement[parameterTypes.length][];
        int i = 0;
        while (i < parameterTypes.length) {
            String typeName = new String(parameterTypes[i]);
            assignableElements[i] = this.fCoreContext.getVisibleElements(Signature.createTypeSignature((String)typeName, (boolean)true));
            ++i;
        }
        return assignableElements;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            if (this.fPositions != null && this.getTextViewer() != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < this.fPositions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = this.fPositions[i].getOffset();
                    int positionLength = this.fPositions[i].getLength();
                    if (this.fChoices[i].length < 2) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), this.fPositions[i]);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', document));
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
            }
        }
        catch (BadLocationException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log((Throwable)e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log((Throwable)e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected StyledString computeDisplayString() {
        return super.computeDisplayString().append(this.getStyledGroovy());
    }

    private StyledString getStyledGroovy() {
        return new StyledString(" (" + this.contributor + ")", StyledString.DECORATIONS_STYLER);
    }

    protected String computeReplacementString() {
        String replacement;
        if (!this.hasParameters() || !this.hasArgumentList()) {
            if (this.proposalOptions.noParens) {
                char[] proposalName = this.fProposal.getName();
                boolean hasWhitespace = false;
                int i = 0;
                while (i < proposalName.length) {
                    if (CharOperation.isWhitespace((char)proposalName[i])) {
                        hasWhitespace = true;
                    }
                    ++i;
                }
                String newProposalName = hasWhitespace ? "\"" + String.valueOf(proposalName) + "\"" : String.valueOf(proposalName);
                return newProposalName;
            }
            String replacementString = super.computeReplacementString();
            if (replacementString.endsWith(");")) {
                replacementString = replacementString.substring(0, replacementString.length() - 1);
            }
            return replacementString;
        }
        long millis = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            replacement = this.computeGuessingCompletion();
        }
        catch (JavaModelException x) {
            this.fPositions = null;
            this.fChoices = null;
            JavaPlugin.log((Throwable)x);
            this.openErrorDialog((Exception)((Object)x));
            return super.computeReplacementString();
        }
        if (DEBUG) {
            System.err.println("Parameter Guessing: " + (System.currentTimeMillis() - millis));
        }
        return replacement;
    }

    private String computeGuessingCompletion() throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        char[] proposalName = this.fProposal.getName();
        boolean hasWhitespace = false;
        int i = 0;
        while (i < proposalName.length) {
            if (CharOperation.isWhitespace((char)proposalName[i])) {
                hasWhitespace = true;
            }
            ++i;
        }
        char[] newProposalName = hasWhitespace ? CharOperation.concat((char[])new char[]{'\"'}, (char[])CharOperation.append((char[])proposalName, (char)'\"')) : proposalName;
        this.fProposal.setName(newProposalName);
        this.appendMethodNameReplacement(buffer);
        this.fProposal.setName(proposalName);
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (this.proposalOptions.noParens) {
            buffer.replace(buffer.length() - 1, buffer.length(), prefs.beforeOpeningParen ? "" : " ");
        }
        this.setCursorPosition(buffer.length());
        char[][] regularParameterTypes = ((GroovyCompletionProposal)this.fProposal).getRegularParameterTypeNames();
        boolean lastArgIsClosure = this.lastArgIsClosure(regularParameterTypes);
        int indexOfLastClosure = lastArgIsClosure ? regularParameterTypes.length - 1 : -1;
        char[][] namedParameterNames = ((GroovyCompletionProposal)this.fProposal).getNamedParameterNames();
        char[][] regularParameterNames = ((GroovyCompletionProposal)this.fProposal).getRegularParameterNames();
        int namedCount = namedParameterNames.length;
        int argCount = regularParameterNames.length;
        int allCount = argCount + namedCount;
        if (this.proposalOptions.noParensAroundClosures) {
            if (indexOfLastClosure == 0 && namedCount == 0) {
                buffer.replace(buffer.length() - 1, buffer.length(), "");
                if (!prefs.beforeOpeningParen) {
                    buffer.append(" ");
                }
            } else if (prefs.afterOpeningParen) {
                buffer.append(" ");
            }
        } else if (prefs.afterOpeningParen) {
            buffer.append(" ");
        }
        if (this.fCoreContext.getEnclosingElement() != null && !(this.fCoreContext.getEnclosingElement().getParent() instanceof ImportContainer)) {
            int replacementOffset = this.getReplacementOffset();
            this.fChoices = this.guessParameters(namedParameterNames, regularParameterNames);
            int i2 = 0;
            while (i2 < allCount) {
                if (i2 != indexOfLastClosure) {
                    char[] nextName = i2 < argCount ? regularParameterNames[i2] : namedParameterNames[i2 - argCount];
                    if (i2 >= argCount || this.proposalOptions.useNamedArguments) {
                        buffer.append(nextName).append(":");
                    }
                    ICompletionProposal proposal = this.fChoices[i2][0];
                    String argument = proposal.getDisplayString();
                    Position position = this.fPositions[i2];
                    position.setOffset(replacementOffset + buffer.length());
                    position.setLength(argument.length());
                    if (proposal instanceof JavaCompletionProposal) {
                        ((JavaCompletionProposal)proposal).setReplacementOffset(replacementOffset + buffer.length());
                    }
                    buffer.append(argument);
                    if (i2 == allCount - 1 || i2 == allCount - 2 && i2 == indexOfLastClosure - 1) {
                        if (prefs.beforeClosingParen || this.proposalOptions.noParens) {
                            buffer.append(" ");
                        }
                        if (!this.proposalOptions.noParens) {
                            buffer.append(")");
                        }
                    } else if (i2 < allCount - 1) {
                        if (prefs.beforeComma) {
                            buffer.append(" ");
                        }
                        buffer.append(",");
                        if (prefs.afterComma) {
                            buffer.append(" ");
                        }
                    }
                }
                ++i2;
            }
            if (indexOfLastClosure >= 0) {
                if (allCount > 1) {
                    if (!this.proposalOptions.noParensAroundClosures) {
                        buffer.append(",");
                    }
                    buffer.append(" ");
                }
                Position position = this.fPositions[indexOfLastClosure];
                position.setOffset(replacementOffset + buffer.length());
                position.setLength(LAST_CLOSURE_TEXT.length());
                buffer.append(LAST_CLOSURE_TEXT);
                if (!this.proposalOptions.noParensAroundClosures) {
                    buffer.append(" }");
                    buffer.append(")");
                }
            }
        }
        return buffer.toString();
    }

    private boolean lastArgIsClosure(char[][] regularParameterTypes) {
        if (regularParameterTypes != null && regularParameterTypes.length > 0) {
            char[] lastArgType = regularParameterTypes[regularParameterTypes.length - 1];
            return CharOperation.equals((char[])"Closure".toCharArray(), (char[])lastArgType);
        }
        return false;
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private ICompletionProposal[][] guessParameters(char[][] firstParameterNames, char[][] secondParameterNames) throws JavaModelException {
        char[][] parameterNames = new char[firstParameterNames.length + secondParameterNames.length][];
        System.arraycopy(firstParameterNames, 0, parameterNames, 0, firstParameterNames.length);
        System.arraycopy(secondParameterNames, 0, parameterNames, firstParameterNames.length, secondParameterNames.length);
        int count = parameterNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        String[] parameterTypes = this.getParameterTypes();
        IJavaElement[][] assignableElements = this.getAssignableElements();
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            Position position = new Position(0, 0);
            ICompletionProposal[] argumentProposals = new ParameterGuesserDelegate(this.getEnclosingElement()).parameterProposals(parameterTypes[i], paramName, position, assignableElements[i], this.fFillBestGuess);
            if (argumentProposals.length == 0) {
                argumentProposals = new ICompletionProposal[]{new JavaCompletionProposal(paramName, 0, paramName.length(), null, paramName, 0)};
            }
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            --i;
        }
        return this.fChoices;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)"Error guessing parameters for content assist proposal", (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    GroovyJavaGuessingCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    public ICompletionProposal[][] getChoices() {
        return this.fChoices;
    }
}

