/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyProjectFacade;
import org.codehaus.jdt.groovy.internal.SimplifiedExtendedCompletionContext;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyExtendedCompletionContext
extends SimplifiedExtendedCompletionContext {
    private static final IJavaElement[] NO_ELEMENTS = new IJavaElement[0];
    private final ContentAssistContext context;
    private final VariableScope currentScope;
    private IJavaElement enclosingElement;
    private final Map<String, IJavaElement[]> visibleElements;

    private static String toFieldName(IMethod method) {
        return ProposalUtils.createMockFieldName(method.getElementName());
    }

    public GroovyExtendedCompletionContext(ContentAssistContext context, VariableScope currentScope) {
        this.context = context;
        this.currentScope = currentScope;
        this.visibleElements = new HashMap<String, IJavaElement[]>();
    }

    public IJavaElement getEnclosingElement() {
        if (this.enclosingElement == null) {
            try {
                this.enclosingElement = this.context.unit.getElementAt(this.context.completionLocation);
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Exception computing content assist proposals", (Throwable)e);
            }
            if (this.enclosingElement == null) {
                this.enclosingElement = this.context.unit;
            }
        }
        return this.enclosingElement;
    }

    public IJavaElement[] getVisibleElements(String typeSignature) {
        IJavaElement[] elements = this.visibleElements.get(typeSignature = Signature.getTypeErasure((String)typeSignature));
        if (elements == null) {
            elements = this.computeVisibleElements(typeSignature);
            this.visibleElements.put(typeSignature, elements);
        }
        return elements;
    }

    private IJavaElement[] computeVisibleElements(String typeSignature) {
        IType enclosingType;
        ClassNode targetType = this.toClassNode(typeSignature);
        boolean isInterface = targetType.isInterface();
        boolean isEnum = targetType.isEnum();
        LinkedHashMap<String, IJavaElement> nameElementMap = new LinkedHashMap<String, IJavaElement>();
        if (this.currentScope != null) {
            Iterator variablesIter = this.currentScope.variablesIterator();
            while (variablesIter.hasNext()) {
                ClassNode type;
                Map.Entry entry = (Map.Entry)variablesIter.next();
                String varName = (String)entry.getKey();
                if (varName.startsWith("get") || varName.startsWith("set") || varName.equals("super") || varName.startsWith("<") || nameElementMap.containsKey(varName) || !this.isAssignableTo(type = ((VariableScope.VariableInfo)entry.getValue()).type, targetType, isInterface)) continue;
                nameElementMap.put(varName, (IJavaElement)ReflectionUtils.createLocalVariable((IJavaElement)this.getEnclosingElement(), (String)varName, (int)0, (String)typeSignature));
            }
        }
        if ((enclosingType = (IType)this.getEnclosingElement().getAncestor(7)) != null) {
            try {
                IType[] allTypes;
                this.addFields(targetType, isInterface, nameElementMap, enclosingType);
                ITypeHierarchy typeHierarchy = enclosingType.newSupertypeHierarchy(null);
                IType[] iTypeArray = allTypes = typeHierarchy.getAllSupertypes(enclosingType);
                int n = allTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superType = iTypeArray[n2];
                    this.addFields(targetType, isInterface, nameElementMap, superType);
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"", (Throwable)e);
            }
        }
        if (isEnum) {
            IType targetIType = new GroovyProjectFacade(this.enclosingElement).groovyClassToJavaType(targetType);
            List fields = targetType.getFields();
            for (FieldNode enumVal : fields) {
                String name = enumVal.getName();
                if (name.equals("MIN_VALUE") || name.equals("MAX_VALUE") || !enumVal.getType().equals((Object)targetType)) continue;
                nameElementMap.put(String.valueOf(targetIType.getElementName()) + "." + name, (IJavaElement)targetIType.getField(name));
                nameElementMap.put(name, (IJavaElement)targetIType.getField(name));
            }
        }
        return nameElementMap.values().toArray(NO_ELEMENTS);
    }

    public void addFields(ClassNode targetType, boolean isInterface, Map<String, IJavaElement> nameElementMap, IType type) throws JavaModelException {
        IMethod[] methods;
        IField[] fields;
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            ClassNode fieldTypeClassNode = this.toClassNode(field.getTypeSignature());
            if (this.isAssignableTo(fieldTypeClassNode, targetType, isInterface)) {
                nameElementMap.put(field.getElementName(), (IJavaElement)field);
            }
            ++n2;
        }
        IMethod[] iMethodArray = methods = type.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod method = iMethodArray[n];
            ClassNode methodReturnTypeClassNode = this.toClassNode(method.getReturnType());
            if (this.isAssignableTo(methodReturnTypeClassNode, targetType, isInterface) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0) && (method.getElementName().startsWith("get") || method.getElementName().startsWith("is"))) {
                nameElementMap.put(method.getElementName(), (IJavaElement)method);
                PropertyVariant field = new PropertyVariant(method);
                nameElementMap.put(field.getElementName(), (IJavaElement)field);
            }
            ++n;
        }
    }

    private ClassNode toClassNode(String typeSignature) {
        ClassNode resolved;
        int dims = Signature.getArrayCount((String)typeSignature);
        String noArray = Signature.getElementType((String)typeSignature);
        String qualifiedName = this.getQualifiedName(noArray);
        if (typeSignature.length() == 1 + dims) {
            resolved = ClassHelper.getWrapper((ClassNode)ClassHelper.make((String)qualifiedName));
        } else {
            try {
                resolved = this.context.unit.getModuleInfo((boolean)false).resolver.resolve(qualifiedName);
            }
            catch (NullPointerException nullPointerException) {
                resolved = VariableScope.OBJECT_CLASS_NODE;
            }
        }
        int i = 0;
        while (i < dims) {
            resolved = resolved.makeArray();
            ++i;
        }
        return resolved;
    }

    private boolean isAssignableTo(ClassNode type, ClassNode superType, boolean isInterface) {
        while (type.isArray() && superType.isArray()) {
            type = type.getComponentType();
            superType = superType.getComponentType();
        }
        if (type.isArray() || superType.isArray()) {
            return false;
        }
        if ((type = ClassHelper.getWrapper((ClassNode)type)).equals((Object)superType)) {
            return true;
        }
        if (isInterface) {
            return type.implementsInterface(superType);
        }
        return type.isDerivedFrom(superType);
    }

    private String getQualifiedName(String typeSignature) {
        String qualifier = Signature.getSignatureQualifier((String)typeSignature);
        String qualifiedName = Signature.getSignatureSimpleName((String)typeSignature);
        if (qualifier.length() > 0) {
            qualifiedName = String.valueOf(qualifier) + "." + qualifiedName;
        }
        return qualifiedName;
    }

    class PropertyVariant
    extends SourceField
    implements IField {
        private final IMethod baseMethod;

        PropertyVariant(IMethod method) {
            super((JavaElement)method.getParent(), GroovyExtendedCompletionContext.toFieldName(method));
            this.baseMethod = method;
        }

        public boolean exists() {
            return true;
        }

        public String getTypeSignature() throws JavaModelException {
            return this.baseMethod.getReturnType();
        }

        public int getFlags() throws JavaModelException {
            return this.baseMethod.getFlags();
        }
    }
}

