/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.completions.NamedArgsMethodNode;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.text.java.CompletionProposalLabelProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ProposalUtils {
    public static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    public static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    public static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' ', '\t', ' ', ';'};
    public static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    public static final List<IGroovyProposal> NO_PROPOSALS = Collections.emptyList();
    public static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static ImageDescriptorRegistry registry;
    private static final CompletionProposalLabelProvider labelProvider;

    static {
        try {
            registry = JavaPlugin.getImageDescriptorRegistry();
        }
        catch (Exception e) {
            e.printStackTrace();
            registry = null;
        }
        labelProvider = new CompletionProposalLabelProvider();
    }

    public static char[] createTypeSignature(ClassNode node) {
        return ProposalUtils.createTypeSignatureStr(node).toCharArray();
    }

    public static String createTypeSignatureStr(ClassNode node) {
        String name;
        if (node == null) {
            node = VariableScope.OBJECT_CLASS_NODE;
        }
        if ((name = node.getName()).startsWith("[")) {
            return name;
        }
        return Signature.createTypeSignature((String)name, (boolean)true);
    }

    public static String createUnresolvedTypeSignatureStr(ClassNode node) {
        String name = node.getNameWithoutPackage();
        if (name.startsWith("[")) {
            return name;
        }
        return Signature.createTypeSignature((String)name, (boolean)false);
    }

    public static AccessRestriction getTypeAccessibility(IType type) {
        PackageFragmentRoot root = (PackageFragmentRoot)type.getAncestor(3);
        try {
            AccessRuleSet accessRuleSet;
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            if (entry instanceof ClasspathEntry && (accessRuleSet = ((ClasspathEntry)entry).getAccessRuleSet()) != null) {
                char[] packageName = type.getPackageFragment().getElementName().toCharArray();
                char[][] packageChars = CharOperation.splitOn((char)'.', (char[])packageName);
                char[] fileWithoutExtension = type.getElementName().toCharArray();
                return accessRuleSet.getViolatedRestriction(CharOperation.concatWith((char[][])packageChars, (char[])fileWithoutExtension, (char)'/'));
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static char[] createMethodSignature(MethodNode node) {
        return ProposalUtils.createMethodSignatureStr(node, 0).toCharArray();
    }

    public static String createMethodSignatureStr(MethodNode node) {
        return ProposalUtils.createMethodSignatureStr(node, 0);
    }

    public static char[] createMethodSignature(MethodNode node, int ignoreParameters) {
        return ProposalUtils.createMethodSignatureStr(node, ignoreParameters).toCharArray();
    }

    public static String createMethodSignatureStr(MethodNode node, int ignoreParameters) {
        String returnType = ProposalUtils.createTypeSignatureStr(node.getReturnType());
        Parameter[] parameters = node instanceof NamedArgsMethodNode ? ((NamedArgsMethodNode)node).getVisibleParams() : node.getParameters();
        String[] parameterTypes = new String[parameters.length - ignoreParameters];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = ProposalUtils.createTypeSignatureStr(parameters[i + ignoreParameters].getType());
            ++i;
        }
        return Signature.createMethodSignature((String[])parameterTypes, (String)returnType);
    }

    public static char[] createSimpleTypeName(ClassNode node) {
        String name = node.getName();
        if (name.startsWith("[")) {
            int arrayCount = Signature.getArrayCount((String)name);
            String noArrayName = Signature.getElementType((String)name);
            String simpleName = Signature.getSignatureSimpleName((String)noArrayName);
            StringBuilder sb = new StringBuilder();
            sb.append(simpleName);
            int i = 0;
            while (i < arrayCount) {
                sb.append("[]");
                ++i;
            }
            return sb.toString().toCharArray();
        }
        return node.getNameWithoutPackage().toCharArray();
    }

    public static Image getImage(CompletionProposal proposal) {
        return registry.get(labelProvider.createImageDescriptor(proposal));
    }

    public static Image getParameterImage() {
        return registry.get(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE);
    }

    public static StyledString createDisplayString(CompletionProposal proposal) {
        return labelProvider.createStyledLabel(proposal);
    }

    public static boolean looselyMatches(String prefix, String target) {
        String[] targetParts;
        if (target == null || prefix == null) {
            return false;
        }
        if (prefix.length() == 0) {
            return true;
        }
        if (prefix.charAt(0) != target.charAt(0)) {
            return false;
        }
        if (target.startsWith(prefix)) {
            return true;
        }
        String lowerCase = target.toLowerCase();
        if (lowerCase.startsWith(prefix)) {
            return true;
        }
        if (prefix.equals(prefix.toLowerCase())) {
            return false;
        }
        String[] prefixParts = ProposalUtils.toCamelCaseParts(prefix);
        if (prefixParts.length > (targetParts = ProposalUtils.toCamelCaseParts(target)).length) {
            return false;
        }
        int i = 0;
        while (i < prefixParts.length) {
            if (!targetParts[i].startsWith(prefixParts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String[] toCamelCaseParts(String str) {
        List parts = ListUtil.newEmptyList();
        int i = str.length() - 1;
        while (i >= 0) {
            if (Character.isUpperCase(str.charAt(i))) {
                parts.add(str.substring(i));
                str = str.substring(0, i);
            }
            --i;
        }
        if (str.length() != 0) {
            parts.add(str);
        }
        Collections.reverse(parts);
        return parts.toArray(new String[parts.size()]);
    }

    public static String createMockFieldName(String methodName) {
        int prefix;
        int n = prefix = methodName.startsWith("is") ? 2 : 3;
        if (methodName.length() > prefix) {
            if (methodName.length() > prefix + 1 && Character.isUpperCase(methodName.charAt(prefix + 1))) {
                return methodName.substring(prefix);
            }
            return String.valueOf(Character.toLowerCase(methodName.charAt(prefix))) + methodName.substring(prefix + 1);
        }
        return "$$$$$";
    }

    public static String createCapitalMockFieldName(String methodName) {
        return methodName.length() > 3 ? methodName.substring(3) : "$$$$$";
    }
}

