/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.application;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.console.addons.MacOSAddon;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.custom.addon.CustomBundleActivator;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.console.ConsoleMain;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.greenrobot.eventbus.EventBus;
import org.osgi.framework.BundleException;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) {
        if (!this.activeLoggingBundle()) {
            return IApplication.EXIT_OK;
        }
        this.preRunInit();
        Map args = context.getArguments();
        String[] appArgs = (String[])args.get("application.args");
        return Application.runConsole(appArgs);
    }

    private void preRunInit() {
        MacOSAddon.initMacOSConfig();
        ApplicationInfo.setAppInfoIntoUserHomeDir();
        this.initEnvironment();
    }

    protected void initEnvironment() {
        CustomBundleActivator.class.getName();
    }

    public static int runConsole(String[] arguments) {
        block3: {
            System.setProperty("eclipse.exitdata", "");
            try {
                Application.init();
                if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild() || Application.checkConsoleActivation(arguments)) break block3;
                return 0;
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e, (String)ConsoleMessageConstants.ERR_CONSOLE_MODE);
                return 2;
            }
        }
        Trackings.trackOpenApplication((!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)"console");
        return ConsoleMain.launch((String[])arguments);
    }

    private static void init() {
        EventBusSingleton.getInstance().setEventBus(EventBus.builder().installDefaultEventBus());
        int trackingTime = TrackingManager.getInstance().getTrackingTime();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)"console"), trackingTime, trackingTime, TimeUnit.SECONDS);
    }

    public static boolean checkConsoleActivation(String[] arguments) {
        if (ActivationInfoCollector.isActivated()) {
            return true;
        }
        return true;
    }

    private static String[] getEmailAndPassword(String[] arguments) {
        OptionParser parser = new OptionParser(false);
        parser.allowsUnrecognizedOptions();
        parser.accepts("email").withRequiredArg().ofType(String.class);
        parser.accepts("password").withRequiredArg().ofType(String.class);
        OptionSet argumentSet = parser.parse(arguments);
        String[] emailPass = new String[2];
        if (argumentSet.has("email")) {
            emailPass[0] = argumentSet.valueOf("email").toString();
        }
        if (argumentSet.has("password")) {
            emailPass[1] = argumentSet.valueOf("password").toString();
        }
        return emailPass;
    }

    public void stop() {
    }

    private boolean activeLoggingBundle() {
        try {
            Platform.getBundle((String)"com.kms.katalon.logging").start();
            return true;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }
}

