/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.addons;

import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class MacOSAddon {
    private static final String SWT_SMALL_FONT_SYSTEM_PROPERTIES = "org.eclipse.swt.internal.carbon.smallFonts";
    private static final String JRE = "jre";
    private static final String MAC_OSX_JRE = "MacOSX JRE";
    private static final String MAC_JRE_HOME_RELATIVE_PATH = "jre" + File.separator + "Contents" + File.separator + "Home" + File.separator + "jre";
    private static final String UPDATED_PREF_VM_XML_KEY = "UPDATED_PREF_VM_XML_LOCATION";

    public static void initMacOSConfig() {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        MacOSAddon.initSmallFonts();
        MacOSAddon.initDefaultJRE();
    }

    private static void initSmallFonts() {
        System.setProperty(SWT_SMALL_FONT_SYSTEM_PROPERTIES, "");
    }

    private static void initDefaultJRE() {
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.jdt.launching");
        if (prefStore == null) {
            return;
        }
        try {
            String lastConfigurationLocation = prefStore.getString(UPDATED_PREF_VM_XML_KEY);
            String currentConfigurationLocation = MacOSAddon.getConfigurationFolder().getAbsolutePath();
            if (StringUtils.equals((CharSequence)lastConfigurationLocation, (CharSequence)currentConfigurationLocation)) {
                return;
            }
            File jreFolder = MacOSAddon.getJREFolder();
            if (jreFolder == null || !jreFolder.exists()) {
                return;
            }
            MacOSAddon.makeJREFilesExecutable(jreFolder);
            prefStore.setValue(JavaRuntime.PREF_VM_XML, MacOSAddon.createXMLDefinitionForVM(jreFolder));
            prefStore.setValue(UPDATED_PREF_VM_XML_KEY, currentConfigurationLocation);
            prefStore.save();
        }
        catch (IOException | CoreException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static String createXMLDefinitionForVM(File jreFolder) throws CoreException {
        IVMInstallType standardVMType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        if (standardVMType == null) {
            return null;
        }
        VMStandin vmStandin = new VMStandin(standardVMType, String.valueOf(System.currentTimeMillis()));
        vmStandin.setInstallLocation(jreFolder);
        vmStandin.setName(MAC_OSX_JRE);
        IVMInstall defaultJRE = vmStandin.convertToRealVM();
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        vmContainer.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE));
        vmContainer.addVM(defaultJRE);
        return vmContainer.getAsXML();
    }

    private static File getJREFolder() throws IOException {
        return new File(MacOSAddon.getConfigurationFolder().getParentFile(), MAC_JRE_HOME_RELATIVE_PATH);
    }

    private static File getConfigurationFolder() throws IOException {
        File configurationFolder = new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile());
        return configurationFolder;
    }

    private static void makeJREFilesExecutable(File jreFolder) throws IOException {
        File[] fileArray = jreFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isFile()) {
                if (file.isDirectory()) {
                    MacOSAddon.makeJREFilesExecutable(file);
                }
            } else {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                PosixFilePermission[] posixFilePermissionArray = PosixFilePermission.values();
                int n3 = posixFilePermissionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PosixFilePermission permission = posixFilePermissionArray[n4];
                    perms.add(permission);
                    ++n4;
                }
                Files.setPosixFilePermissions(file.toPath(), perms);
            }
            ++n2;
        }
    }
}

