/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.integration;

import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import java.util.List;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResource;

public class Step {
    private String text;
    private IResource source;
    private int lineNumber;
    private String lang;
    private Expression expression;
    private String sourceName;
    private String packageName;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        Locale locale = this.lang == null ? Locale.getDefault() : new Locale(this.lang);
        try {
            this.expression = new ExpressionFactory(new ParameterTypeRegistry(locale)).createExpression(text);
        }
        catch (UndefinedParameterTypeException undefinedParameterTypeException) {
            this.expression = null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.expression = null;
        }
    }

    public IResource getSource() {
        return this.source;
    }

    public void setSource(IResource source) {
        this.source = source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean matches(String s) {
        if (this.expression == null) {
            return false;
        }
        List match = this.expression.match(s);
        return match != null;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        if (this.lineNumber != 0) {
            return "Step [text=" + this.text + ", source=" + this.source + ", lineNumber=" + this.lineNumber + "]";
        }
        return "Step [text=" + this.text + ", source=" + this.sourceName + ", package=" + this.packageName + "]";
    }
}

