/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.importproject.handlers;

import com.kms.katalon.composer.components.impl.thread.ImportExportProgressThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.importproject.components.DuplicateEntityDialog;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.controller.ImportProjectIntoProjectController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.util.ImportDuplicateEntityParameter;
import com.kms.katalon.entity.util.ImportDuplicateEntityResult;
import com.kms.katalon.entity.util.ImportType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.UUID;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportProjectIntoProjectHandler
implements PropertyChangeListener {
    private static final int IMPORT_PROJECT_INTO_PROJECT_MAX_PROGRESS = 17;
    private static final String DUPLICATE_ENTITY_EVENT = "duplicateentity";
    private ImportProjectIntoProjectController importProjectController;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(Shell shell) {
        try {
            if (ProjectController.getInstance().getCurrentProject() != null) {
                File importDirectory;
                DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                directoryDialog.open();
                if (directoryDialog.getFilterPath() != null && (importDirectory = new File(directoryDialog.getFilterPath())) != null && importDirectory.exists() && importDirectory.isDirectory()) {
                    this.importProjectController = new ImportProjectIntoProjectController(UUID.randomUUID().toString(), ProjectController.getInstance().getCurrentProject(), importDirectory.getAbsolutePath(), LoggerSingleton.getInstance().getLogger(), (PropertyChangeListener)this);
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                    progressDialog.run(true, true, (IRunnableWithProgress)new ImportExportProgressThread(17, (IImportExportController)this.importProjectController));
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private ImportType getImportTypeResult(DuplicateEntityDialog dialog) {
        switch (dialog.getReturnCode()) {
            case 2: {
                return ImportType.New;
            }
            case 3: {
                return ImportType.Override;
            }
            case 4: {
                return ImportType.Merge;
            }
            case 1: {
                return ImportType.Cancel;
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(DUPLICATE_ENTITY_EVENT)) {
            try {
                final Object object = propertyChangeEvent.getNewValue();
                if (object != null && object instanceof ImportDuplicateEntityParameter) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DuplicateEntityDialog dialog = new DuplicateEntityDialog(null, (ImportDuplicateEntityParameter)object);
                                dialog.open();
                                ImportProjectIntoProjectHandler.this.importProjectController.setImportDuplicateEntityResult(new ImportDuplicateEntityResult(ImportProjectIntoProjectHandler.this.getImportTypeResult(dialog), dialog.getIsApplyToAll()));
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

