/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.importproject.handlers;

import com.kms.katalon.composer.components.impl.thread.ImportExportProgressThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.importproject.constants.StringConstants;
import com.kms.katalon.controller.IImportExportController;
import com.kms.katalon.controller.ImportProjectAsNewProjectController;
import java.io.File;
import java.util.UUID;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportProjectAsNewProjectHandler {
    private static final String PROJECT_NAME_DIALOG_MESSAGE = StringConstants.HAND_NEW_PROJECT_NAME_MSG;
    private static final String PROJECT_NAME_DIALOG_TITLE = StringConstants.HAND_NEW_PROJECT_NAME_TITLE;
    private static final int IMPORT_PROJECT_AS_NEW_PROJECT_MAX_PROGRESS = 17;

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell shell) {
        try {
            File importDirectory;
            DirectoryDialog directoryDialog = new DirectoryDialog(shell);
            directoryDialog.open();
            if (directoryDialog.getFilterPath() != null && (importDirectory = new File(directoryDialog.getFilterPath())) != null && importDirectory.exists() && importDirectory.isDirectory()) {
                InputDialog projectNameDialog = new InputDialog(shell, PROJECT_NAME_DIALOG_TITLE, PROJECT_NAME_DIALOG_MESSAGE, "", null);
                projectNameDialog.open();
                if (projectNameDialog.getValue() != null && !projectNameDialog.getValue().isEmpty()) {
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                    progressDialog.run(true, true, (IRunnableWithProgress)new ImportExportProgressThread(17, (IImportExportController)new ImportProjectAsNewProjectController(UUID.randomUUID().toString(), null, importDirectory.getAbsolutePath(), LoggerSingleton.getInstance().getLogger(), projectNameDialog.getValue())));
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

