/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.refactoring;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class KeywordMethodRenamingParticipant
extends RenameParticipant {
    private IMethod keywordMethod;

    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            String filePath = ((IMethod)element).getParent().getResource().getRawLocation().toString();
            if (GroovyUtil.isKeywordFile((String)filePath, (ProjectEntity)ProjectController.getInstance().getCurrentProject()) && method.getAnnotation(Keyword.class.getName()) != null) {
                this.keywordMethod = method;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return "Rename Keyword Method";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String className = this.keywordMethod.getCompilationUnit().getElementName().replace(".groovy", "");
        String packageName = this.keywordMethod.getCompilationUnit().getParent().getElementName();
        String classQualifier = packageName.isEmpty() ? className : String.valueOf(packageName) + "." + className;
        RenameArguments arguments = this.getArguments();
        String oldScript = "CustomKeywords.'" + classQualifier + "." + this.keywordMethod.getElementName() + "'";
        String newScript = "CustomKeywords.'" + classQualifier + "." + arguments.getNewName() + "'";
        try {
            GroovyRefreshUtil.updateScriptReferencesInTestCaseAndCustomScripts((String)oldScript, (String)newScript, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            PartServiceSingleton.getInstance().getPartService().saveAll(false);
        }
        catch (IOException e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
        return null;
    }
}

