/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.handlers.ExportFolderHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.osgi.framework.FrameworkUtil;

public class ExportKeyWordsPopupMenuContribution {
    private static final String CONTRIBUTOR_URI = FrameworkUtil.getBundle(ExportKeyWordsPopupMenuContribution.class).getSymbolicName();
    public static final String CM_EXPORT_COMPOSER_BUNDLE_URI = "bundleclass://com.kms.katalon.composer.keyword/";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            boolean isPackageLevelSelected;
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null) {
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null || selectedObjects.length != 1) {
                return;
            }
            Object selectedObject = selectedObjects[0];
            FolderEntity keywordRootFolder = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject());
            boolean isKeywordFolderSelected = selectedObject instanceof FolderTreeEntity && ((FolderTreeEntity)selectedObject).getObject() instanceof FolderEntity && FolderEntity.FolderType.KEYWORD.equals((Object)((FolderTreeEntity)selectedObject).getObject().getFolderType());
            boolean bl = isPackageLevelSelected = selectedObject instanceof PackageTreeEntity && ((PackageTreeEntity)selectedObject).getParent().getObject().equals(keywordRootFolder);
            if (isKeywordFolderSelected || isPackageLevelSelected) {
                MDirectMenuItem importMenu = this.getExportMenu();
                importMenu.setContributionURI(CM_EXPORT_COMPOSER_BUNDLE_URI + ExportFolderHandler.class.getName());
                menuItems.add(0, (MMenuElement)importMenu);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MDirectMenuItem getExportMenu() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.MSG_EXPORT);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }
}

