/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.dialogs.RenameKeywordDialog;
import com.kms.katalon.composer.keyword.handlers.RenamePackageHandler;
import com.kms.katalon.composer.keyword.refactoring.KeywordClassRenamingParticipant;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameKeywordHandler
extends RenamePackageHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @Override
    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof KeywordTreeEntity) {
                    RenameKeywordHandler.this.execute((KeywordTreeEntity)object);
                }
            }
        });
    }

    private void execute(KeywordTreeEntity keywordTreeEntity) {
        try {
            ITreeEntity parentTreeEntity = keywordTreeEntity.getParent();
            if (parentTreeEntity instanceof PackageTreeEntity) {
                IFile keywordFile = (IFile)((ICompilationUnit)keywordTreeEntity.getObject()).getResource();
                IPackageFragment packageFragment = (IPackageFragment)((PackageTreeEntity)parentTreeEntity).getObject();
                RenameKeywordDialog dialog = new RenameKeywordDialog(this.parentShell, packageFragment);
                String kwName = StringUtils.removeEndIgnoreCase((String)keywordTreeEntity.getText(), (String)".groovy");
                dialog.setName(kwName);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                    KeywordController.getInstance().removeMethodNodesCustomKeywordFile(keywordFile, project);
                    GroovyCompilationUnit cu = (GroovyCompilationUnit)keywordTreeEntity.getObject();
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    cu.rename(String.valueOf(dialog.getName()) + ".groovy", false, (IProgressMonitor)monitor);
                    KeywordClassRenamingParticipant.updateReferences(this.getClassName(packageFragment, kwName), this.getClassName(packageFragment, dialog.getName()));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity);
                    this.refreshParentAndSelect(parentTreeEntity, String.valueOf(dialog.getName()) + ".groovy");
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String getClassName(IPackageFragment pkg, String clazz) {
        clazz = StringUtils.removeEnd((String)clazz, (String)".groovy");
        return pkg.getElementName().isEmpty() ? clazz : String.valueOf(pkg.getElementName()) + "." + clazz;
    }
}

