/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jdt.core.IPackageFragment;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshPackageHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object selectedObject = event.getProperty("org.eclipse.e4.data");
                    if (selectedObject != null && selectedObject instanceof PackageTreeEntity) {
                        PackageTreeEntity packageTreeEntity = (PackageTreeEntity)selectedObject;
                        IPackageFragment packageFragment = (IPackageFragment)packageTreeEntity.getObject();
                        if (packageFragment != null && packageFragment.exists()) {
                            RefreshPackageHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)packageTreeEntity);
                            KeywordController.getInstance().parseCustomKeywordInPackage(packageFragment, ProjectController.getInstance().getCurrentProject());
                        } else {
                            RefreshPackageHandler.this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)packageTreeEntity.getParent());
                        }
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.getInstance().getLogger().error((Throwable)e);
                }
            }
        });
    }
}

