/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.NewStepDefinitionDialog;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewStepDefinitionHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    ESelectionService selectionService;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects == null) {
            return null;
        }
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object entity = objectArray[n2];
            if (entity instanceof ITreeEntity) {
                PackageTreeEntity parentPackage;
                FolderEntity parentFolder;
                Object entityObject = ((ITreeEntity)entity).getObject();
                if (entityObject instanceof IPackageFragment) {
                    PackageTreeEntity treeEntity = (PackageTreeEntity)entity;
                    FolderEntity parent = (FolderEntity)treeEntity.getParent().getObject();
                    if (parent.getFolderType() == FolderEntity.FolderType.INCLUDE) {
                        return (ITreeEntity)entity;
                    }
                    return null;
                }
                if (entityObject instanceof FolderEntity && FolderController.getInstance().isSourceFolder(ProjectController.getInstance().getCurrentProject(), (FolderEntity)entityObject)) {
                    return (ITreeEntity)entity;
                }
                if (entity instanceof KeywordTreeEntity && (parentFolder = (FolderEntity)(parentPackage = (PackageTreeEntity)((KeywordTreeEntity)entity).getParent()).getParent().getObject()).getFolderType() == FolderEntity.FolderType.INCLUDE) {
                    return parentPackage;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean isUnderSourceFolder(Object[] selectedObjects) throws Exception {
        if (selectedObjects == null) {
            return false;
        }
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object entity = objectArray[n2];
            if (entity instanceof ITreeEntity) {
                PackageTreeEntity treeEntity;
                FolderEntity parent;
                Object entityObject = ((ITreeEntity)entity).getObject();
                if (entityObject instanceof IPackageFragment && (parent = (FolderEntity)(treeEntity = (PackageTreeEntity)entity).getParent().getObject()).getFolderType() == FolderEntity.FolderType.INCLUDE) {
                    return true;
                }
                if (entityObject instanceof FolderEntity && ((FolderEntity)entityObject).getFolderType() == FolderEntity.FolderType.INCLUDE) {
                    return true;
                }
                if (entity instanceof KeywordTreeEntity && (parent = (FolderEntity)(treeEntity = (PackageTreeEntity)((KeywordTreeEntity)entity).getParent()).getParent().getObject()).getFolderType() == FolderEntity.FolderType.INCLUDE) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            ITreeEntity parentTreeEntity = this.getParentTreeEntity();
            FolderTreeEntity rootParentFolder = null;
            IPackageFragment packageFragment = null;
            IPackageFragmentRoot rootPackage = null;
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
            if (parentTreeEntity instanceof FolderTreeEntity) {
                FolderEntity folder = (FolderEntity)parentTreeEntity.getObject();
                rootPackage = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(folder.getRelativePath()));
                String packagePath = groovyProject.getFolder(folder.getRelativePath()).getFullPath().toString().replaceFirst(rootPackage.getPath().toString(), "");
                packageFragment = rootPackage.getPackageFragment(packagePath);
                rootParentFolder = (FolderTreeEntity)parentTreeEntity;
            } else if (parentTreeEntity instanceof PackageTreeEntity) {
                packageFragment = (IPackageFragment)parentTreeEntity.getObject();
                rootPackage = (IPackageFragmentRoot)packageFragment.getParent();
                rootParentFolder = (FolderTreeEntity)parentTreeEntity.getParent();
            }
            if (packageFragment != null) {
                NewStepDefinitionDialog dialog = new NewStepDefinitionDialog(parentShell, rootPackage, packageFragment);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ICompilationUnit createdCompilationUnit;
                    int kwFilePathLength = dialog.getParentPackage().getElementName().length() + dialog.getName().length();
                    if (kwFilePathLength > 255) {
                        MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_EXCEED_CLASS_NAME_LENGTH, kwFilePathLength, 255));
                        return;
                    }
                    packageFragment = dialog.getParentPackage();
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    monitor.setTaskName("Create Step Definition");
                    if (!packageFragment.exists()) {
                        monitor.subTask("Create Package");
                        packageFragment = rootPackage.createPackageFragment(packageFragment.getElementName(), true, (IProgressMonitor)monitor);
                        ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                        int n = iCompilationUnitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICompilationUnit compicationUnit = iCompilationUnitArray[n2];
                            compicationUnit.discardWorkingCopy();
                            ++n2;
                        }
                    }
                    if (dialog.getSampleKeywordType() != 0) {
                        SampleCustomKeywordScriptBuilder sampleScriptBuilder = new SampleCustomKeywordScriptBuilder(dialog);
                        String sampleScript = sampleScriptBuilder.build();
                        createdCompilationUnit = GroovyGuiUtil.createGroovyScriptForCustomKeywordFromTemplate((IPackageFragment)packageFragment, (String)dialog.getName(), (String)sampleScript);
                    } else {
                        createdCompilationUnit = GroovyGuiUtil.createGroovyScriptForCustomKeyword((IPackageFragment)packageFragment, (String)dialog.getName());
                    }
                    Trackings.trackCreatingObject((String)"groovyScriptFile");
                    if (createdCompilationUnit instanceof GroovyCompilationUnit && createdCompilationUnit.getParent() instanceof IPackageFragment) {
                        PackageTreeEntity newPackageTreeEntity = new PackageTreeEntity(packageFragment, (ITreeEntity)rootParentFolder);
                        KeywordTreeEntity keywordTreeEntity = new KeywordTreeEntity(createdCompilationUnit, (ITreeEntity)newPackageTreeEntity);
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)rootParentFolder);
                        this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)keywordTreeEntity);
                        this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)createdCompilationUnit);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private ITreeEntity getParentTreeEntity() throws Exception {
        Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
        ITreeEntity parentTreeEntity = NewStepDefinitionHandler.findParentTreeEntity(selectedObjects);
        if (parentTreeEntity == null) {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            FolderEntity includeRootFolder = FolderController.getInstance().getIncludeRoot(project);
            FolderEntity groovyScriptFolder = FolderController.getInstance().getGroovyScriptRoot(project);
            FolderTreeEntity treeEntity = new FolderTreeEntity(groovyScriptFolder, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)groovyScriptFolder.getParentFolder(), (FolderEntity)includeRootFolder));
            parentTreeEntity = treeEntity;
        }
        return parentTreeEntity;
    }

    private class SampleCustomKeywordScriptBuilder {
        private static final String COMMON_IMPORTS_FILE = "resources/template/step_definition/step_definition_imports.tpl";
        private static final String SAMPLE_STEP_DEFINTION = "resources/template/step_definition/step_definition.tpl";
        private final NewStepDefinitionDialog dialog;

        public SampleCustomKeywordScriptBuilder(NewStepDefinitionDialog dialog) {
            this.dialog = dialog;
        }

        public String build() {
            String imports = this.getFileContent(COMMON_IMPORTS_FILE);
            String keywords = this.buildKeywordScript();
            StringBuilder scriptBuilder = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)this.dialog.getParentPackage().getElementName())) {
                scriptBuilder.append(String.format("package %s\n", this.dialog.getParentPackage().getElementName()));
            }
            scriptBuilder.append(imports).append("\n\n").append(String.format("class %s {\n %s \n}", this.dialog.getName(), keywords));
            return scriptBuilder.toString();
        }

        private String buildKeywordScript() {
            StringBuilder keywordScriptBuilder = new StringBuilder();
            int sampleKeywordType = this.dialog.getSampleKeywordType();
            if ((sampleKeywordType & 1) != 0) {
                String webCustomKeywordScript = this.getFileContent(SAMPLE_STEP_DEFINTION);
                keywordScriptBuilder.append(webCustomKeywordScript).append("\n\n");
            }
            return keywordScriptBuilder.toString();
        }

        private String getFileContent(String filePath) {
            URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(NewStepDefinitionHandler.class), (IPath)new Path(filePath), null);
            try {
                return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
                return "";
            }
        }
    }
}

