/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.folder.dialogs.NewFolderDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.folder.FolderEntity;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;

public class NewFolderHandler {
    @Inject
    ESelectionService selectionService;
    @Inject
    IEventBroker eventBroker;

    protected FolderTreeEntity getSelectedTreeEntity(Object[] selectedObjects) {
        ITreeEntity parent;
        block5: {
            if (selectedObjects == null || selectedObjects.length != 1 || !(selectedObjects[0] instanceof ITreeEntity)) {
                return null;
            }
            if (selectedObjects[0] instanceof FolderTreeEntity) {
                FolderTreeEntity parentFolder = (FolderTreeEntity)selectedObjects[0];
                return this.isIncludeFolder(parentFolder) ? parentFolder : null;
            }
            ITreeEntity treeEntity = (ITreeEntity)selectedObjects[0];
            try {
                parent = treeEntity.getParent();
                if (parent instanceof FolderTreeEntity) break block5;
                return null;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        FolderTreeEntity parentFolder = (FolderTreeEntity)parent;
        return this.isIncludeFolder(parentFolder) ? parentFolder : null;
    }

    private boolean isIncludeFolder(FolderTreeEntity folderTree) {
        try {
            return folderTree.getObject().getFolderType() == FolderEntity.FolderType.INCLUDE;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Execute
    public void execute() {
        FolderTreeEntity parentFolderTreeEntity = this.getSelectedTreeEntity((Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer"));
        try {
            FolderEntity parentFolder = parentFolderTreeEntity.getObject();
            String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, "New Folder");
            NewFolderDialog newFolderDialog = new NewFolderDialog(Display.getCurrent().getActiveShell(), parentFolder);
            newFolderDialog.setName(suggestedName);
            newFolderDialog.open();
            if (newFolderDialog.getReturnCode() == 0) {
                FolderEntity newEntity = FolderController.getInstance().addNewFolder(parentFolder, newFolderDialog.getName());
                FolderTreeEntity newFolderTree = new FolderTreeEntity(newEntity, (ITreeEntity)parentFolderTreeEntity);
                this.eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentFolderTreeEntity);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)newFolderTree);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

