/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.util.groovy.editor;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EditorSavedHandler
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EDITORS_SAVED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        Object object = event.getProperty("org.eclipse.e4.data");
        switch (topic) {
            case "EDITORS_SAVED": {
                if (!(object instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)object;
                if (!editor.isGroovyEditorPart((MPart)part)) {
                    return;
                }
                IFile file = ((FileEditorInput)editor.getEditor((MPart)part).getEditorInput()).getFile();
                Executors.newSingleThreadExecutor().submit(() -> {
                    if (!this.isScriptRightFormat(file)) {
                        return;
                    }
                    try {
                        KeywordController.getInstance().parseCustomKeywordFile(file, ProjectController.getInstance().getCurrentProject());
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                    UISynchronizeService.syncExec(() -> {
                        try {
                            this.refreshKeywordTreeEntity(file);
                        }
                        catch (Exception ex) {
                            LoggerSingleton.logError((Throwable)ex);
                        }
                    });
                });
            }
        }
    }

    private boolean isScriptRightFormat(IFile file) {
        if (!ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            return true;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            return false;
        }
        return !this.scriptContainsErrors(file);
    }

    private boolean scriptContainsErrors(IFile file) {
        try {
            IMarker[] problemMarkers = file.findMarkers("org.eclipse.jdt.core.problem", false, 0);
            return problemMarkers != null && problemMarkers.length > 0;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return true;
        }
    }

    private void refreshKeywordTreeEntity(IFile file) throws Exception {
        file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        KeywordTreeEntity keywordTreeEntity = TreeEntityUtil.getKeywordTreeEntity((String)file.getProjectRelativePath().toString(), (ProjectEntity)ProjectController.getInstance().getCurrentProject());
        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordTreeEntity);
    }
}

