/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.handlers.DeleteKeywordHandler;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeletePackageHandler
extends DeleteKeywordHandler {
    @Inject
    private IEventBroker eventBroker;

    @Override
    public Class<? extends ITreeEntity> entityType() {
        return PackageTreeEntity.class;
    }

    @Override
    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        if (treeEntity == null || !(treeEntity instanceof PackageTreeEntity)) {
            return false;
        }
        try {
            if (treeEntity.getObject() instanceof IPackageFragment) {
                String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
                Object[] children = treeEntity.getChildren();
                monitor.beginTask(taskName, children.length + 1);
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    super.execute((ITreeEntity)child, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++n2;
                }
                IPackageFragment packageFragment = (IPackageFragment)treeEntity.getObject();
                String parentPath = String.valueOf(packageFragment.getParent().getElementName()) + '/';
                String packageName = packageFragment.getElementName().isEmpty() ? StringConstants.DEFAULT_PACKAGE_NAME : packageFragment.getElementName();
                packageFragment.delete(true, null);
                this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)(String.valueOf(parentPath) + packageName));
                monitor.worked(1);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_KEYWORD);
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

