/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.git;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.git.components.wizards.CustomRepositorySelectionPage;
import com.kms.katalon.composer.integration.git.components.wizards.CustomSourceBranchPage;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.composer.keyword.git.CustomCloneDestinationPage;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.op.ConfigureFetchAfterCloneTask;
import org.eclipse.egit.core.op.ConfigureGerritAfterCloneTask;
import org.eclipse.egit.core.op.ConfigurePushAfterCloneTask;
import org.eclipse.egit.core.op.SetRepositoryConfigPropertyTask;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.egit.ui.internal.clone.RememberHostTask;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

public class CustomGitCloneWizard
extends Wizard {
    protected CustomSourceBranchPage validSource;
    protected CustomCloneDestinationPage cloneDestination;
    protected String alreadyClonedInto;
    protected boolean callerRunsCloneOperation;
    protected IRepositorySearchResult currentSearchResult;
    private CloneOperation cloneOperation;

    public CustomGitCloneWizard() {
        this((IRepositorySearchResult)new CustomRepositorySelectionPage());
    }

    public CustomGitCloneWizard(IRepositorySearchResult searchResult) {
        this.setNeedsProgressMonitor(true);
        this.validSource = new CustomSourceBranchPage(){

            public void setVisible(boolean visible) {
                RepositorySelection selection = CustomGitCloneWizard.this.getRepositorySelection();
                if (selection != null && visible) {
                    this.setSelection(selection);
                    this.setCredentials(CustomGitCloneWizard.this.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.cloneDestination = new CustomCloneDestinationPage(){

            @Override
            public void setVisible(boolean visible) {
                RepositorySelection selection = CustomGitCloneWizard.this.getRepositorySelection();
                if (selection != null && visible) {
                    this.setSelection(selection, CustomGitCloneWizard.this.validSource.getAvailableBranches(), CustomGitCloneWizard.this.validSource.getSelectedBranches(), CustomGitCloneWizard.this.validSource.getHEAD());
                }
                super.setVisible(visible);
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.setWindowTitle(UIText.GitCloneWizard_title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
    }

    public CustomGitCloneWizard setShowProjectImport(boolean show) {
        this.cloneDestination.setShowProjectImport(show);
        return this;
    }

    public boolean performCancel() {
        if (this.alreadyClonedInto == null) {
            return true;
        }
        File test = new File(this.alreadyClonedInto);
        if (test.exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.GitCloneWizard_abortingCloneTitle, (String)UIText.GitCloneWizard_abortingCloneMsg)) {
            try {
                FileUtils.delete((File)test, (int)3);
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return true;
    }

    public boolean canFinish() {
        return this.cloneDestination.isPageComplete();
    }

    public boolean performFinish() {
        try {
            boolean bl = this.performClone(this.currentSearchResult.getGitRepositoryInfo());
            return bl;
        }
        catch (URISyntaxException e) {
            Activator.error((String)UIText.GitImportWizard_errorParsingURI, (Throwable)e);
        }
        catch (NoRepositoryInfoException e) {
            Activator.error((String)UIText.GitImportWizard_noRepositoryInfo, (Throwable)e);
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            this.setWindowTitle(UIText.GitCloneWizard_title);
        }
        return false;
    }

    public final void addPages() {
        this.addPage((IWizardPage)new CustomRepositorySelectionPage());
        this.addPage((IWizardPage)this.validSource);
        this.addPage((IWizardPage)this.cloneDestination);
    }

    protected boolean hasSearchResult() {
        return this.currentSearchResult != null;
    }

    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        return GitCloneSourceProviderExtension.getCloneSourceProvider();
    }

    protected boolean performClone(GitRepositoryInfo gitRepositoryInfo) throws Exception {
        List selectedBranches;
        boolean allSelected;
        Trackings.trackImportKeywords((String)"git");
        URIish uri = new URIish(gitRepositoryInfo.getCloneUri());
        UserPasswordCredentials credentials = gitRepositoryInfo.getCredentials();
        this.setWindowTitle(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString()));
        if (this.validSource.isSourceRepoEmpty()) {
            allSelected = true;
            selectedBranches = Collections.emptyList();
        } else {
            allSelected = this.validSource.isAllSelected();
            selectedBranches = this.validSource.getSelectedBranches();
        }
        String tempDir = ProjectController.getInstance().getTempDir();
        File workdir = new File(tempDir, "git_tmp");
        Ref ref = this.cloneDestination.getInitialBranch();
        String remoteName = this.cloneDestination.getRemote();
        boolean created = workdir.exists();
        if (workdir.exists()) {
            org.apache.commons.io.FileUtils.deleteDirectory((File)workdir);
        }
        if (!(created = workdir.mkdirs()) || !workdir.isDirectory()) {
            String errorMessage = NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)workdir.getPath());
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)UIText.GitCloneWizard_failed, (IStatus)new Status(4, Activator.getPluginId(), 0, errorMessage, null));
            return false;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        CloneOperation op = new CloneOperation(uri, allSelected, (Collection)selectedBranches, workdir, ref != null ? ref.getName() : null, remoteName, timeout);
        EGitCredentialsProvider credentialsProvider = null;
        credentialsProvider = credentials != null ? new EGitCredentialsProvider(credentials.getUser(), credentials.getPassword()) : new EGitCredentialsProvider();
        op.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        op.setCloneSubmodules(this.cloneDestination.isCloneSubmodules());
        this.rememberHttpHost(op, uri);
        this.configureFetchSpec(op, gitRepositoryInfo, remoteName);
        this.configurePush(op, gitRepositoryInfo, remoteName);
        this.configureRepositoryConfig(op, gitRepositoryInfo);
        this.configureGerrit(op, gitRepositoryInfo, (CredentialsProvider)credentialsProvider, remoteName, timeout);
        if (this.cloneDestination.isImportProjects()) {
            final IWorkingSet[] sets = this.cloneDestination.getWorkingSets();
            op.addPostCloneTask(new CloneOperation.PostCloneTask(){

                public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
                    CustomGitCloneWizard.this.importProjects(repository, sets);
                }
            });
        }
        this.alreadyClonedInto = workdir.getPath();
        if (!this.callerRunsCloneOperation) {
            this.runAsJob(uri, op, gitRepositoryInfo, workdir);
        } else {
            this.cloneOperation = op;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof IRepositorySearchResult) {
            this.currentSearchResult = (IRepositorySearchResult)page;
            return this.validSource;
        }
        return super.getNextPage(page);
    }

    @Nullable
    protected RepositorySelection getRepositorySelection() {
        try {
            return new RepositorySelection(new URIish(this.currentSearchResult.getGitRepositoryInfo().getCloneUri()), null);
        }
        catch (URISyntaxException e) {
            Activator.error((String)UIText.GitImportWizard_errorParsingURI, (Throwable)e);
            return null;
        }
        catch (NoRepositoryInfoException e) {
            Activator.error((String)UIText.GitImportWizard_noRepositoryInfo, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected UserPasswordCredentials getCredentials() {
        try {
            return this.currentSearchResult.getGitRepositoryInfo().getCredentials();
        }
        catch (NoRepositoryInfoException e) {
            Activator.error((String)UIText.GitImportWizard_noRepositoryInfo, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void rememberHttpHost(CloneOperation op, URIish uri) {
        String host;
        String scheme = uri.getScheme();
        if (scheme != null && scheme.toLowerCase().startsWith("http") && (host = uri.getHost()) != null) {
            op.addPostCloneTask((CloneOperation.PostCloneTask)new RememberHostTask(host));
        }
    }

    private void configureFetchSpec(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, String remoteName) {
        for (String fetchRefSpec : gitRepositoryInfo.getFetchRefSpecs()) {
            op.addPostCloneTask((CloneOperation.PostCloneTask)new ConfigureFetchAfterCloneTask(remoteName, fetchRefSpec));
        }
    }

    private void configurePush(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, String remoteName) {
        for (GitRepositoryInfo.PushInfo pushInfo : gitRepositoryInfo.getPushInfos()) {
            try {
                URIish uri = pushInfo.getPushUri() != null ? new URIish(pushInfo.getPushUri()) : null;
                ConfigurePushAfterCloneTask task = new ConfigurePushAfterCloneTask(remoteName, pushInfo.getPushRefSpec(), uri);
                op.addPostCloneTask((CloneOperation.PostCloneTask)task);
            }
            catch (URISyntaxException e) {
                Activator.handleError((String)UIText.GitCloneWizard_failed, (Throwable)e, (boolean)true);
            }
        }
    }

    private void configureRepositoryConfig(CloneOperation op, GitRepositoryInfo gitRepositoryInfo) {
        for (GitRepositoryInfo.RepositoryConfigProperty p : gitRepositoryInfo.getRepositoryConfigProperties()) {
            SetRepositoryConfigPropertyTask task = new SetRepositoryConfigPropertyTask(p.getSection(), p.getSubsection(), p.getName(), p.getValue());
            op.addPostCloneTask((CloneOperation.PostCloneTask)task);
        }
    }

    private void configureGerrit(CloneOperation op, GitRepositoryInfo gitRepositoryInfo, CredentialsProvider credentialsProvider, String remoteName, int timeout) {
        ConfigureGerritAfterCloneTask task = new ConfigureGerritAfterCloneTask(gitRepositoryInfo.getCloneUri(), remoteName, credentialsProvider, timeout);
        op.addPostCloneTask((CloneOperation.PostCloneTask)task);
    }

    private void importProjects(final Repository repository, final IWorkingSet[] sets) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        WorkspaceJob importJob = new WorkspaceJob(MessageFormat.format(UIText.GitCloneWizard_jobImportProjects, repoName)){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ArrayList files = new ArrayList();
                ProjectUtil.findProjectFiles(files, (File)repository.getWorkTree(), (boolean)true, (IProgressMonitor)monitor);
                if (files.isEmpty()) {
                    return Status.OK_STATUS;
                }
                LinkedHashSet<ProjectRecord> records = new LinkedHashSet<ProjectRecord>();
                for (File file : files) {
                    records.add(new ProjectRecord(file));
                }
                try {
                    ProjectUtils.createProjects(records, (IWorkingSet[])sets, (IProgressMonitor)monitor);
                }
                catch (InvocationTargetException e) {
                    Activator.logError((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    Activator.logError((String)e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        importJob.schedule();
    }

    public void runCloneOperation(IWizardContainer container, final GitRepositoryInfo repositoryInfo, final File destination) {
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CustomGitCloneWizard.this.executeCloneOperation(CustomGitCloneWizard.this.cloneOperation, repositoryInfo, monitor, destination);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError((String)UIText.GitCloneWizard_failed, (Throwable)e.getCause(), (boolean)true);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void runAsJob(URIish uri, final CloneOperation op, final GitRepositoryInfo repositoryInfo, final File destination) throws InterruptedException {
        Job job = new Job(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return CustomGitCloneWizard.this.executeCloneOperation(op, repositoryInfo, monitor, destination);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    Throwable thr = e.getCause();
                    return new Status(4, Activator.getPluginId(), 0, thr.getMessage(), thr);
                }
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CLONE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                HashMap<String, String> repInfo = new HashMap<String, String>();
                repInfo.put("repoUrl", repositoryInfo.getCloneUri());
                repInfo.put("commitId", CustomGitCloneWizard.this.validSource.getHEAD().getObjectId().getName());
                EventBrokerSingleton.getInstance().getEventBroker().post("GIT/KEYWORD_CLONE_FINISHED", repInfo);
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private IStatus executeCloneOperation(CloneOperation op, GitRepositoryInfo repositoryInfo, IProgressMonitor monitor, File destination) throws InvocationTargetException, InterruptedException {
        try {
            RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
            op.run(monitor);
            util.addConfiguredRepository(op.getGitDir());
            if (repositoryInfo.shouldSaveCredentialsInSecureStore()) {
                SecureStoreUtils.storeCredentials((UserPasswordCredentials)repositoryInfo.getCredentials(), (URIish)new URIish(repositoryInfo.getCloneUri()));
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            UISynchronizeService.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)CustomGitCloneWizard.this.getShell(), (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_CLONE);
                }
            });
        }
        return Status.OK_STATUS;
    }

    public void setCallerRunsCloneOperation(boolean newValue) {
        this.callerRunsCloneOperation = newValue;
    }
}

