/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.git;

import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class CustomCloneDestinationPage
extends WizardPage {
    private static final boolean DEFAULT_CLONE_SUBMODULES_FLAG = false;
    private final List<Ref> availableRefs = new ArrayList<Ref>();
    private RepositorySelection validatedRepoSelection;
    private List<Ref> validatedSelectedBranches;
    private Ref validatedHEAD;
    private boolean showProjectImport;
    private ComboViewer initialBranch;
    private Text directoryText;
    private Button importProjectsButton;
    private WorkingSetGroup workingSetGroup;
    private File clonedDestination;
    private Ref clonedInitialBranch;
    private String clonedRemote;

    public CustomCloneDestinationPage() {
        super(CustomCloneDestinationPage.class.getName());
        this.setTitle(UIText.CloneDestinationPage_title);
        this.showProjectImport = false;
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.createDestinationGroup(panel);
        if (this.showProjectImport) {
            this.createProjectGroup(panel);
        }
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    public void setVisible(boolean visible) {
        if (visible && this.availableRefs.isEmpty()) {
            this.initialBranch.getCombo().setEnabled(false);
        }
        super.setVisible(visible);
        if (visible) {
            this.directoryText.setFocus();
        }
    }

    public void setSelection(@NonNull RepositorySelection repositorySelection, List<Ref> availableRefs, List<Ref> branches, Ref head) {
        this.availableRefs.clear();
        this.availableRefs.addAll(availableRefs);
        this.checkPreviousPagesSelections(repositorySelection, branches, head);
        this.revalidate(repositorySelection, branches, head);
    }

    private void checkPreviousPagesSelections(@NonNull RepositorySelection repositorySelection, List<Ref> branches, Ref head) {
        if (!repositorySelection.equals((Object)this.validatedRepoSelection) || !branches.equals(this.validatedSelectedBranches) || head != null && !head.equals(this.validatedHEAD)) {
            this.setPageComplete(false);
        } else {
            this.checkPage();
        }
    }

    private void createDestinationGroup(Composite parent) {
        Group g = CustomCloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupDestination);
        Label dirLabel = new Label((Composite)g, 0);
        dirLabel.setText(String.valueOf(UIText.CloneDestinationPage_promptDirectory) + ":");
        dirLabel.setToolTipText(UIText.CloneDestinationPage_DefaultRepoFolderTooltip);
        Composite p = new Composite((Composite)g, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 2;
        p.setLayout((Layout)grid);
        p.setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.directoryText = new Text(p, 2048);
        this.directoryText.setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomCloneDestinationPage.this.checkPage();
            }
        });
        CustomCloneDestinationPage.newLabel(g, String.valueOf(UIText.CloneDestinationPage_promptInitialBranch) + ":");
        this.initialBranch = new ComboViewer((Composite)g, 12);
        this.initialBranch.getCombo().setLayoutData((Object)CustomCloneDestinationPage.createFieldGridData());
        this.initialBranch.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCloneDestinationPage.this.checkPage();
            }
        });
        this.initialBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.initialBranch.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof Ref)) {
                    return "";
                }
                String elementName = ((Ref)element).getName();
                if (elementName.startsWith("refs/heads/")) {
                    return elementName.substring("refs/heads/".length());
                }
                return elementName;
            }
        });
    }

    private void createProjectGroup(Composite parent) {
        Group group = CustomCloneDestinationPage.createGroup(parent, UIText.CloneDestinationPage_groupProjects);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        this.importProjectsButton = new Button((Composite)group, 32);
        this.importProjectsButton.setText(UIText.CloneDestinationPage_importButton);
        this.importProjectsButton.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("CloneWizard_ImportProjects"));
        this.importProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.getDefault().getPreferenceStore().setValue("CloneWizard_ImportProjects", CustomCloneDestinationPage.this.importProjectsButton.getSelection());
            }
        });
        String[] workingSetTypes = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup((Composite)group, null, workingSetTypes);
    }

    private static Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private static GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    public boolean isImportProjects() {
        return this.importProjectsButton != null && this.importProjectsButton.getSelection();
    }

    public boolean isCloneSubmodules() {
        return false;
    }

    public IWorkingSet[] getWorkingSets() {
        if (this.workingSetGroup == null) {
            return new IWorkingSet[0];
        }
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    public File getDestinationFile() {
        return FileUtils.canonicalize((File)new File(this.directoryText.getText()));
    }

    public Ref getInitialBranch() {
        IStructuredSelection selection = (IStructuredSelection)this.initialBranch.getSelection();
        return (Ref)selection.getFirstElement();
    }

    public String getRemote() {
        return "origin";
    }

    private void checkPage() {
        if (!this.cloneSettingsChanged()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            return;
        }
        String dstpath = this.directoryText.getText();
        if (dstpath.length() == 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorDirectoryRequired);
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!CustomCloneDestinationPage.canCreateSubdir(absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!this.availableRefs.isEmpty() && this.initialBranch.getCombo().getSelectionIndex() < 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorInitialBranchRequired);
            this.setPageComplete(false);
            return;
        }
        String remoteName = this.getRemote();
        if (remoteName.length() == 0) {
            this.setErrorMessage(UIText.CloneDestinationPage_errorRemoteNameRequired);
            this.setPageComplete(false);
            return;
        }
        if (!Repository.isValidRefName((String)("refs/remotes/" + remoteName))) {
            this.setErrorMessage(NLS.bind((String)UIText.CloneDestinationPage_errorInvalidRemoteName, (Object)remoteName));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    void saveSettingsForClonedRepo() {
        this.clonedDestination = this.getDestinationFile();
        this.clonedInitialBranch = this.getInitialBranch();
        this.clonedRemote = this.getRemote();
    }

    public boolean cloneSettingsChanged() {
        boolean cloneSettingsChanged = false;
        if (!(this.clonedDestination != null && this.clonedDestination.equals(this.getDestinationFile()) && this.clonedInitialBranch != null && this.clonedInitialBranch.equals(this.getInitialBranch()) && this.clonedRemote != null && this.clonedRemote.equals(this.getRemote()))) {
            cloneSettingsChanged = true;
        }
        return cloneSettingsChanged;
    }

    private static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    private static boolean canCreateSubdir(File parent) {
        if (parent == null) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return CustomCloneDestinationPage.canCreateSubdir(parent.getParentFile());
    }

    private void revalidate(@NonNull RepositorySelection repoSelection, List<Ref> branches, Ref head) {
        if (repoSelection.equals((Object)this.validatedRepoSelection) && branches.equals(this.validatedSelectedBranches) && head != null && head.equals(this.validatedHEAD)) {
            this.checkPage();
            return;
        }
        if (!repoSelection.equals((Object)this.validatedRepoSelection)) {
            this.validatedRepoSelection = repoSelection;
            String n = this.validatedRepoSelection.getURI().getHumanishName();
            this.setDescription(NLS.bind((String)UIText.CloneDestinationPage_description, (Object)n));
            String defaultRepoDir = "";
            try {
                defaultRepoDir = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()).getLocation();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File parentDir = new File(defaultRepoDir);
            this.directoryText.setText(parentDir.getAbsolutePath());
            this.directoryText.setEnabled(false);
        }
        this.validatedSelectedBranches = branches;
        this.validatedHEAD = head;
        this.initialBranch.setInput(branches);
        if (head != null && branches.contains(head)) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)head));
        } else if (branches.size() > 0) {
            this.initialBranch.setSelection((ISelection)new StructuredSelection((Object)branches.get(0)));
        }
        this.checkPage();
    }

    public CustomCloneDestinationPage setShowProjectImport(boolean show) {
        this.showProjectImport = show;
        return this;
    }
}

