/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.dialogs;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.keyword.constants.ComposerKeywordMessageConstants;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.CommonAbstractKeywordDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewKeywordDialog
extends CommonAbstractKeywordDialog {
    public static final int SAMPLE_WEB_KEYWORD = 1;
    public static final int SAMPLE_MOBILE_KEYWORD = 2;
    public static final int SAMPLE_API_KEYWORD = 4;
    private IPackageFragment parentPackage;
    private IPackageFragmentRoot rootPackage;
    private Text txtPackage;
    private Button btnBrowse;
    private Button btnGenerateSampleWebKeyword;
    private Button btnGenerateSampleMobileKeyword;
    private Button btnGenerateSampleAPIKeyword;
    private Composite helpComposite;
    private int sampleKeywordType = 0;
    private ValidatorManager validatorManager;
    private Validator packageValidator;
    private Validator nameValidator;

    public NewKeywordDialog(Shell parentShell, IPackageFragmentRoot rootPackage, IPackageFragment parentPackage) {
        super(parentShell, null);
        this.setDialogTitle(StringConstants.DIA_TITLE_KEYWORD);
        this.setDialogMsg(StringConstants.DIA_MSG_CREATE_KEYWORD);
        this.rootPackage = rootPackage;
        this.parentPackage = parentPackage;
    }

    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        this.setInput();
        this.addControlModifyListeners();
        return area;
    }

    private void setInput() {
        this.txtName.forceFocus();
    }

    public Control createDialogBodyArea(Composite parent) {
        if (this.container == null) {
            this.container = new Composite(parent, 0);
        }
        this.createPackageNameControl(this.container, 3);
        super.setLblName(StringConstants.MSG_CLASS_NAME_TITLE);
        return super.createDialogBodyArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.helpComposite = new Composite(parent, 0);
        this.helpComposite.setLayout((Layout)new GridLayout(1, false));
        this.helpComposite.setLayoutData((Object)new GridData(131072, 4, false, true));
        new HelpComposite(this.helpComposite, DocumentationMessageConstants.CUSTOM_KEYWORD);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createEntityCustomControl(Composite parent, int column, int span) {
        return this.createSampleKeywordControl(parent, column);
    }

    private void addControlModifyListeners() {
        this.prepareValidators();
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewKeywordDialog.this.choosePackage()) {
                    NewKeywordDialog.this.txtPackage.setText(NewKeywordDialog.this.getParentPackage().getElementName());
                }
            }
        });
        this.txtPackage.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newName = NewKeywordDialog.this.getTextFromVerifyEvent(event);
                NewKeywordDialog.this.validatePackageName(newName);
                NewKeywordDialog.this.updateStatus();
            }
        });
        this.txtName.removeListener(24, this.txtName.getListeners(24)[0]);
        this.txtName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String newName = NewKeywordDialog.this.getTextFromVerifyEvent(event);
                if (!newName.equals(NewKeywordDialog.this.txtName)) {
                    NewKeywordDialog.this.validateKeywordName(newName, NewKeywordDialog.this.parentPackage);
                    NewKeywordDialog.this.updateStatus();
                    NewKeywordDialog.this.setName(newName);
                }
            }
        });
        BiFunction<Integer, Button, SelectionAdapter> selectionAdapterCreator = (sampleType, sampleButton) -> new SelectionAdapter((Button)sampleButton, (Integer)sampleType){
            private final /* synthetic */ Button val$sampleButton;
            private final /* synthetic */ Integer val$sampleType;
            {
                this.val$sampleButton = button;
                this.val$sampleType = n;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.val$sampleButton.getSelection()) {
                    NewKeywordDialog newKeywordDialog = NewKeywordDialog.this;
                    newKeywordDialog.sampleKeywordType = newKeywordDialog.sampleKeywordType | this.val$sampleType;
                } else {
                    NewKeywordDialog newKeywordDialog = NewKeywordDialog.this;
                    newKeywordDialog.sampleKeywordType = newKeywordDialog.sampleKeywordType & ~this.val$sampleType.intValue();
                }
            }
        };
        this.btnGenerateSampleWebKeyword.addSelectionListener((SelectionListener)selectionAdapterCreator.apply(1, this.btnGenerateSampleWebKeyword));
        this.btnGenerateSampleMobileKeyword.addSelectionListener((SelectionListener)selectionAdapterCreator.apply(2, this.btnGenerateSampleMobileKeyword));
        this.btnGenerateSampleAPIKeyword.addSelectionListener((SelectionListener)selectionAdapterCreator.apply(4, this.btnGenerateSampleAPIKeyword));
    }

    private void prepareValidators() {
        this.validatorManager = new ValidatorManager();
        this.nameValidator = new Validator(this.getDialogMsg());
        this.nameValidator.setOK(false);
        this.validatorManager.addValidator(this.nameValidator);
        this.packageValidator = new Validator();
        this.packageValidator.setOK(true);
        this.validatorManager.addValidator(this.packageValidator);
    }

    @Override
    public void updateStatus() {
        this.setMessage(this.validatorManager.getMessage(), this.validatorManager.getType());
        super.getButton(0).setEnabled(this.validatorManager.isOK());
    }

    private String getTextFromVerifyEvent(VerifyEvent event) {
        Text txt = (Text)event.widget;
        StringBuilder builder = new StringBuilder(txt.getText());
        return builder.replace(event.start, event.end, event.text).toString();
    }

    private Control createSampleKeywordControl(Composite parent, int column) {
        Composite sampleKeywordComposite = new Composite(parent, 0);
        sampleKeywordComposite.setLayoutData((Object)new GridData(4, 4, true, true, column, 1));
        sampleKeywordComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnGenerateSampleWebKeyword = new Button(sampleKeywordComposite, 32);
        this.btnGenerateSampleWebKeyword.setText(ComposerKeywordMessageConstants.DIA_LBL_GENERATE_SAMPLE_FOR_WEB);
        this.btnGenerateSampleMobileKeyword = new Button(sampleKeywordComposite, 32);
        this.btnGenerateSampleMobileKeyword.setText(ComposerKeywordMessageConstants.DIA_LBL_GENERATE_SAMPLE_FOR_MOBILE);
        this.btnGenerateSampleAPIKeyword = new Button(sampleKeywordComposite, 32);
        this.btnGenerateSampleAPIKeyword.setText(ComposerKeywordMessageConstants.DIA_LBL_GENERATE_SAMPLE_FOR_API);
        return parent;
    }

    private Control createPackageNameControl(Composite parent, int column) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(column, false));
        Label labelName = new Label(parent, 0);
        labelName.setText(StringConstants.PACKAGE);
        this.txtPackage = new Text(parent, 2048);
        this.txtPackage.setLayoutData((Object)new GridData(768));
        this.txtPackage.setText(this.getParentPackage().getElementName());
        this.txtPackage.selectAll();
        this.btnBrowse = new Button(parent, 8);
        this.btnBrowse.setText(StringConstants.BROWSE);
        return parent;
    }

    @Override
    public void validateEntityName(String entityName) throws Exception {
        this.validatePackageName(this.txtPackage.getText());
        this.validateKeywordName(entityName, this.parentPackage);
    }

    private void validatePackageName(String packageName) {
        try {
            this.packageValidator.reset();
            if (packageName.isEmpty()) {
                this.packageValidator.setMessage(StringConstants.DIA_WARN_DEFAULT_PACKAGE, 2);
                this.packageValidator.setOK(false);
                return;
            }
            IPackageFragment pkg = this.rootPackage.getPackageFragment(packageName);
            this.validatePackageName(packageName, pkg);
            this.parentPackage = pkg;
            this.packageValidator.setOK(true);
        }
        catch (Exception e) {
            this.packageValidator.setMessage(e.getMessage(), 3);
            this.packageValidator.setOK(false);
        }
    }

    @Override
    protected void validateKeywordName(String name, IPackageFragment parentPackage) {
        try {
            this.nameValidator.reset();
            if (name.isEmpty()) {
                this.nameValidator.setOK(false);
                return;
            }
            super.validateKeywordName(name, parentPackage);
            this.nameValidator.setOK(true);
        }
        catch (Exception e) {
            this.nameValidator.setMessage(e.getMessage(), 3);
            this.nameValidator.setOK(false);
        }
    }

    protected boolean choosePackage() {
        int dialogStatus;
        Object[] packages = null;
        try {
            if (this.rootPackage != null && this.rootPackage.exists()) {
                packages = this.rootPackage.getChildren();
            }
        }
        catch (JavaModelException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(StringConstants.DIA_TITLE_PACKAGE_SELECTION);
        dialog.setMessage(StringConstants.DIA_MSG_CHOOSE_A_PACKAGE);
        dialog.setEmptyListMessage(StringConstants.DIA_MSG_NO_PACKAGE);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        if (this.parentPackage != null) {
            dialog.setInitialSelections(new Object[]{this.parentPackage});
        }
        if (this.isOK(dialogStatus = dialog.open())) {
            this.parentPackage = (IPackageFragment)dialog.getFirstResult();
        }
        return this.isOK(dialogStatus);
    }

    private boolean isOK(int dialogStatus) {
        return dialogStatus == 0;
    }

    public IPackageFragment getParentPackage() {
        return this.parentPackage;
    }

    public int getSampleKeywordType() {
        return this.sampleKeywordType;
    }

    private void openBrowserToLink(String url) {
        Program.launch((String)url);
    }

    private class Validator {
        private String message;
        private String defaultMessage;
        private int serverity;
        private boolean ok;

        public Validator() {
            this("");
        }

        public Validator(String defaultMessage) {
            this.defaultMessage = defaultMessage;
            this.reset();
        }

        public void reset() {
            this.setMessage(this.defaultMessage);
            this.setOK(false);
            this.getServerity(1);
        }

        public void setMessage(String message, int serverity) {
            this.setMessage(message);
            this.getServerity(serverity);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getServerity() {
            return this.serverity;
        }

        public void getServerity(int serverity) {
            this.serverity = serverity;
        }

        public boolean isOK() {
            return this.ok;
        }

        public void setOK(boolean ok) {
            this.ok = ok;
        }
    }

    private class ValidatorManager {
        private List<Validator> validators = new ArrayList<Validator>();

        private void addValidator(Validator newValidator) {
            this.validators.add(newValidator);
        }

        public String getMessage() {
            return this.getHighestServerityValidator().getMessage();
        }

        public int getType() {
            return this.getHighestServerityValidator().getServerity();
        }

        public boolean isOK() {
            if (this.validators.isEmpty()) {
                return true;
            }
            for (Validator validator : this.validators) {
                if (validator.isOK()) continue;
                return false;
            }
            return true;
        }

        private Validator getHighestServerityValidator() {
            if (this.validators.isEmpty()) {
                return null;
            }
            Validator highest = this.validators.get(0);
            for (Validator validator : this.validators) {
                if (highest.getServerity() >= validator.getServerity()) continue;
                highest = validator;
            }
            return highest;
        }
    }
}

