/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.preferences;

import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.NewProjectDialog;
import com.kms.katalon.composer.integration.analytics.handlers.AnalyticsAuthorizationHandler;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AnalyticsPreferencesPage
extends FieldEditorPreferencePageWithHelp {
    private Composite container;
    private Composite enablerComposite;
    private Composite mainComposite;
    private Button btnConnect;
    private Button enableAnalyticsIntegration;
    private Button cbxAutoSubmit;
    private Button cbxAttachScreenshot;
    private Button cbxAttachCaptureVideo;
    private Text txtServerUrl;
    private Text txtEmail;
    private Text txtPassword;
    private Label lblStatus;
    private Combo cbbProjects;
    private Combo cbbTeams;
    private List<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
    private List<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
    private Button btnCreate;
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
    private Button chckEncrypt;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.enablerComposite = new Composite(this.container, 0);
        this.enablerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.enablerComposite.setLayout((Layout)new GridLayout());
        this.enableAnalyticsIntegration = new Button(this.enablerComposite, 32);
        this.enableAnalyticsIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.enableAnalyticsIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_ANALYTICS_INTEGRATION);
        this.mainComposite = new Composite(this.container, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.marginWidth = 0;
        glMainComposite.marginHeight = 0;
        this.mainComposite.setLayout((Layout)glMainComposite);
        this.createAuthenticationGroup();
        this.createSelectGroup();
        this.createTestResultGroup();
        this.addListeners();
        this.initialize();
        return this.container;
    }

    private void createAuthenticationGroup() {
        Group grpAuthentication = new Group(this.mainComposite, 0);
        grpAuthentication.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpAuthentication = new GridLayout(2, false);
        glGrpAuthentication.horizontalSpacing = 15;
        grpAuthentication.setLayout((Layout)glGrpAuthentication);
        grpAuthentication.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_AUTHENTICATE_GROUP);
        Label lblServerUrl = new Label((Composite)grpAuthentication, 0);
        lblServerUrl.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SERVER_URL);
        this.txtServerUrl = new Text((Composite)grpAuthentication, 2048);
        this.txtServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblEmail = new Label((Composite)grpAuthentication, 0);
        lblEmail.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_EMAIL);
        this.txtEmail = new Text((Composite)grpAuthentication, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label((Composite)grpAuthentication, 0);
        lblPassword.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PASSWORD);
        Composite passwordComposite = new Composite((Composite)grpAuthentication, 0);
        passwordComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glPassword = new GridLayout(2, false);
        glPassword.marginWidth = 0;
        glPassword.marginHeight = 0;
        passwordComposite.setLayout((Layout)glPassword);
        this.txtPassword = new Text(passwordComposite, 2048);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chckEncrypt = new Button((Composite)grpAuthentication, 32);
        this.chckEncrypt.setLayoutData((Object)new GridData(16384, 128, false, true, 2, 1));
        this.chckEncrypt.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_ANTHENTICATION_ENCRYPTION);
        Composite compConnect = new Composite((Composite)grpAuthentication, 0);
        compConnect.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout glConnect = new GridLayout(2, false);
        glConnect.marginHeight = 0;
        glConnect.marginWidth = 0;
        compConnect.setLayout((Layout)glConnect);
        this.btnConnect = new Button(compConnect, 0);
        this.btnConnect.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnConnect.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_CONNECT);
        this.lblStatus = new Label(compConnect, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
    }

    private void createSelectGroup() {
        Group grpSelect = new Group(this.mainComposite, 0);
        grpSelect.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpSelect = new GridLayout(4, false);
        grpSelect.setLayout((Layout)glGrpSelect);
        grpSelect.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SELECT_GROUP);
        Label lblTeam = new Label((Composite)grpSelect, 0);
        lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
        this.cbbTeams = new Combo((Composite)grpSelect, 8);
        this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblProject = new Label((Composite)grpSelect, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo((Composite)grpSelect, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnCreate = new Button((Composite)grpSelect, 0);
        this.btnCreate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnCreate.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
    }

    private void createTestResultGroup() {
        Group grpTestResult = new Group(this.mainComposite, 0);
        grpTestResult.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpTestResult = new GridLayout(1, false);
        glGrpTestResult.horizontalSpacing = 15;
        grpTestResult.setLayout((Layout)glGrpTestResult);
        grpTestResult.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEST_RESULT_GROUP);
        this.cbxAutoSubmit = new Button((Composite)grpTestResult, 32);
        this.cbxAutoSubmit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbxAutoSubmit.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEST_RESULT_AUTO_SUBMIT);
        Composite attachComposite = new Composite((Composite)grpTestResult, 0);
        GridLayout glGrpAttach = new GridLayout(1, false);
        glGrpAttach.marginLeft = 15;
        attachComposite.setLayout((Layout)glGrpAttach);
        attachComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cbxAttachScreenshot = new Button(attachComposite, 32);
        this.cbxAttachScreenshot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbxAttachScreenshot.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEST_RESULT_ATTACH_SCREENSHOT);
        this.cbxAttachCaptureVideo = new Button(attachComposite, 32);
        this.cbxAttachCaptureVideo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbxAttachCaptureVideo.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEST_RESULT_ATTACH_CAPTURED_VIDEO);
        this.cbxAttachCaptureVideo.setVisible(false);
    }

    protected void initialize() {
        super.initialize();
        this.fillData();
        this.changeEnabled();
    }

    protected void createFieldEditors() {
    }

    protected void performDefaults() {
        super.performDefaults();
        if (!this.isInitialized()) {
            return;
        }
        this.changeEnabled();
        this.updateDataStore();
    }

    public boolean performOk() {
        if (!this.isInitialized()) {
            return true;
        }
        boolean integrationEnabled = this.enableAnalyticsIntegration.getSelection();
        if (!integrationEnabled) {
            this.updateDataStore();
            return true;
        }
        if (this.cbbTeams.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_CONNECT_SUCCESSFULLY);
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtEmail.getText()) || StringUtils.isEmpty((String)this.txtPassword.getText()) || StringUtils.isEmpty((String)this.txtServerUrl.getText())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_ENTER_REQUIRED_INFORMATION);
            return false;
        }
        this.changeEnabled();
        this.updateDataStore();
        return super.performOk();
    }

    public boolean performCancel() {
        try {
            this.analyticsSettingStore.enableIntegration(this.isIntegratedSuccessfully());
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)this.isIntegratedSuccessfully());
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return super.performCancel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.handleFieldEditorValueChanged(event);
        }
        super.propertyChange(event);
    }

    private void handleFieldEditorValueChanged(PropertyChangeEvent event) {
        if (event.getSource() == this.enableAnalyticsIntegration) {
            this.changeEnabled();
        }
    }

    private void fillData() {
        try {
            boolean encryptionEnabled = this.analyticsSettingStore.isEncryptionEnabled();
            this.enableAnalyticsIntegration.setSelection(this.analyticsSettingStore.isIntegrationEnabled());
            this.cbbTeams.setItems(new String[0]);
            this.cbbProjects.setItems(new String[0]);
            String password = this.analyticsSettingStore.getPassword(this.analyticsSettingStore.isEncryptionEnabled());
            String serverUrl = this.analyticsSettingStore.getServerEndpoint(this.analyticsSettingStore.isEncryptionEnabled());
            String email = this.analyticsSettingStore.getEmail(this.analyticsSettingStore.isEncryptionEnabled());
            if (this.enableAnalyticsIntegration.getSelection()) {
                AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(this.analyticsSettingStore.getServerEndpoint(encryptionEnabled), this.analyticsSettingStore.getEmail(encryptionEnabled), password, this.analyticsSettingStore);
                if (tokenInfo == null) {
                    this.txtEmail.setText(this.analyticsSettingStore.getEmail(encryptionEnabled));
                    this.txtServerUrl.setText(this.analyticsSettingStore.getServerEndpoint(encryptionEnabled));
                    this.maskPasswordField();
                    return;
                }
                this.teams = AnalyticsAuthorizationHandler.getTeams(this.analyticsSettingStore.getServerEndpoint(encryptionEnabled), this.analyticsSettingStore.getEmail(encryptionEnabled), password, tokenInfo, new ProgressMonitorDialog(this.getShell()));
                this.projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, email, password, this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, this.teams)), tokenInfo, new ProgressMonitorDialog(this.getShell()));
                if (this.teams != null && !this.teams.isEmpty()) {
                    this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(this.teams).toArray(new String[this.teams.size()]));
                    this.cbbTeams.select(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, this.teams));
                }
                if (this.teams != null && this.teams.size() > 0) {
                    this.setProjectsBasedOnTeam(this.teams, this.projects, this.analyticsSettingStore.getServerEndpoint(encryptionEnabled), this.analyticsSettingStore.getEmail(encryptionEnabled), password);
                }
            }
            this.txtEmail.setText(this.analyticsSettingStore.getEmail(encryptionEnabled));
            this.txtPassword.setText(password);
            this.chckEncrypt.setSelection(this.analyticsSettingStore.isEncryptionEnabled());
            this.maskPasswordField();
            this.txtServerUrl.setText(this.analyticsSettingStore.getServerEndpoint(encryptionEnabled));
            this.cbxAutoSubmit.setSelection(this.analyticsSettingStore.isAutoSubmit());
            this.cbxAttachScreenshot.setSelection(this.analyticsSettingStore.isAttachScreenshot());
            this.cbxAttachCaptureVideo.setSelection(this.analyticsSettingStore.isAttachCapturedVideos());
            ScopedPreferenceStore preferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.activation.dialog");
            String preferenceEmail = preferenceStore.getString("email");
            String preferencePassword = preferenceStore.getString("password");
            if (!StringUtils.isEmpty((String)preferenceEmail) && !StringUtils.isEmpty((String)preferencePassword)) {
                this.txtEmail.setText(CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)preferenceEmail)));
                this.txtPassword.setText(CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)preferencePassword)));
                preferenceStore.setValue("password", "");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void maskPasswordField() {
        this.txtPassword.setEchoChar("\u2022".charAt(0));
    }

    private void changeEnabled() {
        boolean isAnalyticsIntegrated = this.enableAnalyticsIntegration.getSelection();
        this.btnConnect.setEnabled(isAnalyticsIntegrated);
        this.txtPassword.setEnabled(isAnalyticsIntegrated);
        this.txtEmail.setEnabled(isAnalyticsIntegrated);
        this.txtServerUrl.setEnabled(isAnalyticsIntegrated);
        this.cbbProjects.setEnabled(isAnalyticsIntegrated);
        this.btnCreate.setEnabled(isAnalyticsIntegrated);
        this.cbxAutoSubmit.setEnabled(isAnalyticsIntegrated);
        this.cbxAutoSubmit.setSelection(isAnalyticsIntegrated);
        this.cbxAttachScreenshot.setEnabled(isAnalyticsIntegrated);
        this.cbxAttachScreenshot.setSelection(isAnalyticsIntegrated);
        this.cbxAttachCaptureVideo.setEnabled(isAnalyticsIntegrated);
        this.chckEncrypt.setEnabled(isAnalyticsIntegrated);
        this.chckEncrypt.setSelection(isAnalyticsIntegrated);
    }

    private boolean isIntegratedSuccessfully() {
        if (!this.isInitialized()) {
            return false;
        }
        boolean isAnalyticsIntegrated = this.enableAnalyticsIntegration.getSelection();
        return isAnalyticsIntegrated && !this.teams.isEmpty();
    }

    private void updateDataStore() {
        try {
            boolean encryptionEnabled = this.chckEncrypt.getSelection();
            this.analyticsSettingStore.enableIntegration(this.isIntegratedSuccessfully());
            this.analyticsSettingStore.setServerEndPoint(this.txtServerUrl.getText(), encryptionEnabled);
            this.analyticsSettingStore.setEmail(this.txtEmail.getText(), encryptionEnabled);
            this.analyticsSettingStore.setPassword(this.txtPassword.getText(), encryptionEnabled);
            this.analyticsSettingStore.enableEncryption(encryptionEnabled);
            if (!this.teams.isEmpty()) {
                this.analyticsSettingStore.setTeam(this.teams.get(this.cbbTeams.getSelectionIndex()));
            }
            this.analyticsSettingStore.setProject(this.cbbProjects.getSelectionIndex() != -1 ? this.projects.get(this.cbbProjects.getSelectionIndex()) : null);
            this.analyticsSettingStore.setAutoSubmit(this.cbxAutoSubmit.getSelection());
            this.analyticsSettingStore.setAttachScreenshot(this.cbxAttachScreenshot.getSelection());
            this.analyticsSettingStore.setAttachLog(this.enableAnalyticsIntegration.getSelection());
            this.analyticsSettingStore.setAttachCapturedVideos(this.cbxAttachCaptureVideo.getSelection());
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)this.isIntegratedSuccessfully());
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void addListeners() {
        this.enableAnalyticsIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.changeEnabled();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String serverUrl = AnalyticsPreferencesPage.this.txtServerUrl.getText();
                String email = AnalyticsPreferencesPage.this.txtEmail.getText();
                String password = AnalyticsPreferencesPage.this.txtPassword.getText();
                if (StringUtils.isEmpty((String)serverUrl) || StringUtils.isEmpty((String)email) || StringUtils.isEmpty((String)password)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_ENTER_REQUIRED_INFORMATION);
                    return;
                }
                AnalyticsPreferencesPage.this.cbbTeams.setItems(new String[0]);
                AnalyticsPreferencesPage.this.cbbProjects.setItems(new String[0]);
                AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrl, email, password, AnalyticsPreferencesPage.this.analyticsSettingStore);
                if (tokenInfo == null) {
                    return;
                }
                AnalyticsPreferencesPage.this.teams = AnalyticsAuthorizationHandler.getTeams(serverUrl, email, password, tokenInfo, new ProgressMonitorDialog(AnalyticsPreferencesPage.this.getShell()));
                AnalyticsPreferencesPage.this.projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, email, password, (AnalyticsTeam)AnalyticsPreferencesPage.this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(AnalyticsPreferencesPage.this.analyticsSettingStore, AnalyticsPreferencesPage.this.teams)), tokenInfo, new ProgressMonitorDialog(AnalyticsPreferencesPage.this.getShell()));
                if (AnalyticsPreferencesPage.this.teams != null && !AnalyticsPreferencesPage.this.teams.isEmpty()) {
                    AnalyticsPreferencesPage.this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(AnalyticsPreferencesPage.this.teams).toArray(new String[AnalyticsPreferencesPage.this.teams.size()]));
                    AnalyticsPreferencesPage.this.cbbTeams.select(AnalyticsAuthorizationHandler.getDefaultTeamIndex(AnalyticsPreferencesPage.this.analyticsSettingStore, AnalyticsPreferencesPage.this.teams));
                }
                AnalyticsPreferencesPage.this.setProjectsBasedOnTeam(AnalyticsPreferencesPage.this.teams, AnalyticsPreferencesPage.this.projects, serverUrl, email, password);
            }
        });
        this.cbbTeams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String serverUrl = AnalyticsPreferencesPage.this.txtServerUrl.getText();
                    String email = AnalyticsPreferencesPage.this.txtEmail.getText();
                    String password = AnalyticsPreferencesPage.this.txtPassword.getText();
                    AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrl, email, password, AnalyticsPreferencesPage.this.analyticsSettingStore);
                    AnalyticsPreferencesPage.this.projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, email, password, (AnalyticsTeam)AnalyticsPreferencesPage.this.teams.get(AnalyticsPreferencesPage.this.cbbTeams.getSelectionIndex()), tokenInfo, new ProgressMonitorDialog(AnalyticsPreferencesPage.this.getShell()));
                    AnalyticsPreferencesPage.this.analyticsSettingStore.setTeam((AnalyticsTeam)AnalyticsPreferencesPage.this.teams.get(AnalyticsPreferencesPage.this.cbbTeams.getSelectionIndex()));
                    AnalyticsPreferencesPage.this.setProjectsBasedOnTeam(AnalyticsPreferencesPage.this.teams, AnalyticsPreferencesPage.this.projects, serverUrl, email, password);
                }
                catch (IOException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                }
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsProject createdProject;
                NewProjectDialog dialog;
                String serverUrl = AnalyticsPreferencesPage.this.txtServerUrl.getText();
                String email = AnalyticsPreferencesPage.this.txtEmail.getText();
                String password = AnalyticsPreferencesPage.this.txtPassword.getText();
                AnalyticsTeam team = null;
                if (AnalyticsPreferencesPage.this.teams != null && AnalyticsPreferencesPage.this.teams.size() > 0) {
                    team = (AnalyticsTeam)AnalyticsPreferencesPage.this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(AnalyticsPreferencesPage.this.analyticsSettingStore, AnalyticsPreferencesPage.this.teams));
                }
                if ((dialog = new NewProjectDialog(AnalyticsPreferencesPage.this.btnCreate.getDisplay().getActiveShell(), serverUrl, email, password, team)).open() == 0 && (createdProject = dialog.getAnalyticsProject()) != null) {
                    try {
                        AnalyticsPreferencesPage.this.analyticsSettingStore.setProject(createdProject);
                        AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrl, email, password, AnalyticsPreferencesPage.this.analyticsSettingStore);
                        AnalyticsPreferencesPage.this.projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, email, password, team, tokenInfo, new ProgressMonitorDialog(AnalyticsPreferencesPage.this.getShell()));
                        if (AnalyticsPreferencesPage.this.projects == null) {
                            return;
                        }
                        AnalyticsPreferencesPage.this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(AnalyticsPreferencesPage.this.projects).toArray(new String[AnalyticsPreferencesPage.this.projects.size()]));
                        AnalyticsPreferencesPage.this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex(AnalyticsPreferencesPage.this.analyticsSettingStore, AnalyticsPreferencesPage.this.projects));
                    }
                    catch (IOException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                    }
                }
            }
        });
        this.cbxAutoSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsPreferencesPage.this.cbxAttachScreenshot.setSelection(AnalyticsPreferencesPage.this.cbxAutoSubmit.getSelection());
            }
        });
    }

    private void setProjectsBasedOnTeam(List<AnalyticsTeam> teams, List<AnalyticsProject> projects, String serverUrl, String email, String password) {
        String role;
        AnalyticsTeam team = teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, teams));
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(projects).toArray(new String[projects.size()]));
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex(this.analyticsSettingStore, projects));
        }
        if ((role = team.getRole()).equals("USER")) {
            this.btnCreate.setEnabled(false);
        } else {
            this.btnCreate.setEnabled(true);
        }
    }

    protected boolean isInitialized() {
        return this.enableAnalyticsIntegration != null;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_KATALON_ANALYTICS;
    }
}

