/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiExeception;
import com.kms.katalon.integration.analytics.providers.AnalyticsApiProvider;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AnalyticsAuthorizationHandler {
    public static AnalyticsTokenInfo getToken(String serverUrl, String email, String password, AnalyticsSettingStore settingStore) {
        try {
            boolean encryptionEnabled = true;
            AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.requestToken(serverUrl, email, password);
            settingStore.setToken(tokenInfo.getAccess_token(), encryptionEnabled);
            return tokenInfo;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            try {
                settingStore.setPassword("", true);
                settingStore.enableIntegration(false);
            }
            catch (IOException | GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR);
            return null;
        }
    }

    public static List<AnalyticsProject> getProjects(final String serverUrl, String email, String password, final AnalyticsTeam team, final AnalyticsTokenInfo tokenInfo, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_PROJECTS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_PROJECTS);
                            List loaded = AnalyticsApiProvider.getProjects((String)serverUrl, (AnalyticsTeam)team, (String)tokenInfo.getAccess_token());
                            if (loaded != null && !loaded.isEmpty()) {
                                projects.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return projects;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof AnalyticsApiExeception) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerAnalyticsStringConstants.ERROR, (String)cause.getMessage());
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return projects;
    }

    public static List<AnalyticsTeam> getTeams(final String serverUrl, String email, String password, final AnalyticsTokenInfo tokenInfo, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_TEAMS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_TEAMS);
                            List loaded = AnalyticsApiProvider.getTeams((String)serverUrl, (String)tokenInfo.getAccess_token());
                            if (loaded != null && !loaded.isEmpty()) {
                                teams.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return teams;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof AnalyticsApiExeception) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerAnalyticsStringConstants.ERROR, (String)cause.getMessage());
            } else {
                LoggerSingleton.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return teams;
    }

    public static int getDefaultTeamIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsTeam> teams) {
        int selectionIndex = 0;
        try {
            AnalyticsTeam storedProject = analyticsSettingStore.getTeam();
            if (storedProject != null && storedProject.getId() != null && teams != null) {
                int i = 0;
                while (i < teams.size()) {
                    AnalyticsTeam p = teams.get(i);
                    if (p.getId() == storedProject.getId()) {
                        selectionIndex = i;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return selectionIndex;
    }

    public static List<String> getTeamNames(List<AnalyticsTeam> teams) {
        List<String> names = teams.stream().map(t -> t.getName()).collect(Collectors.toList());
        return names;
    }

    public static List<String> getProjectNames(List<AnalyticsProject> projects) {
        ArrayList<String> names = new ArrayList<String>();
        projects.forEach(p -> {
            boolean bl = names.add(p.getName());
        });
        return names;
    }

    public static int getDefaultProjectIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsProject> projects) {
        int selectionIndex = 0;
        try {
            AnalyticsProject storedProject = analyticsSettingStore.getProject();
            if (storedProject != null && storedProject.getId() != null) {
                int i = 0;
                while (i < projects.size()) {
                    AnalyticsProject p = projects.get(i);
                    if (storedProject.getId().equals(p.getId())) {
                        selectionIndex = i;
                        return selectionIndex;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return selectionIndex;
    }

    public static AnalyticsProject createProject(String serverUrl, String projectName, AnalyticsTeam team, String accessToken) throws AnalyticsApiExeception {
        return AnalyticsApiProvider.createProject((String)serverUrl, (String)projectName, (AnalyticsTeam)team, (String)accessToken);
    }

    public static AnalyticsTokenInfo requestToken(String serverUrl, String email, String password) throws AnalyticsApiExeception {
        return AnalyticsApiProvider.requestToken((String)serverUrl, (String)email, (String)password);
    }
}

