/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.NewProjectDialog;
import com.kms.katalon.composer.integration.analytics.handlers.AnalyticsAuthorizationHandler;
import com.kms.katalon.composer.testcase.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UploadSelectionDialog
extends Dialog {
    public static final int UPLOAD_ID = 2;
    public static final int CANCEL_ID = 3;
    private Button btnUpload;
    private Button btnCancel;
    private Button btnCreate;
    private Combo cbbProjects;
    private Combo cbbTeams;
    private List<AnalyticsTeam> teams;
    private List<AnalyticsProject> projects;
    private AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());

    public UploadSelectionDialog(Shell parentShell, List<AnalyticsTeam> teams, List<AnalyticsProject> projects) {
        super(parentShell);
        this.teams = teams;
        this.projects = projects;
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridData bodyGridData = new GridData(4, 4, true, true);
        bodyGridData.widthHint = 400;
        body.setLayoutData((Object)bodyGridData);
        GridLayout bodyGridLayout = new GridLayout(1, false);
        bodyGridLayout.marginWidth = 10;
        bodyGridLayout.marginHeight = 10;
        body.setLayout((Layout)bodyGridLayout);
        CLabel lblInformation = new CLabel(body, 64);
        lblInformation.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        lblInformation.setBottomMargin(2);
        lblInformation.setText(StringConstants.LBL_SELECTION_INFORMATION);
        Label lblTeam = new Label(body, 0);
        lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
        this.cbbTeams = new Combo(body, 8);
        this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblProject = new Label(body, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        Composite projectComposite = new Composite(body, 0);
        projectComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout projectGridLayout = new GridLayout(2, false);
        projectGridLayout.marginWidth = 0;
        projectGridLayout.marginHeight = 0;
        projectComposite.setLayout((Layout)projectGridLayout);
        this.cbbProjects = new Combo(projectComposite, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCreate = new Button(projectComposite, 0);
        this.btnCreate.setText("New Project");
        if (this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, this.teams)).getRole().equals("USER")) {
            this.btnCreate.setEnabled(false);
        }
        this.fillData();
        return body;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnUpload = this.createButton(parent, 2, StringConstants.BTN_UPLOAD, true);
        this.btnCancel = this.createButton(parent, 3, StringConstants.BTN_CANCEL, false);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.handleUpload();
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsProject createdProject;
                NewProjectDialog dialog;
                HashMap results = null;
                try {
                    results = UploadSelectionDialog.this.getInfo(UploadSelectionDialog.this.analyticsSettingStore.isEncryptionEnabled());
                }
                catch (IOException e1) {
                    LoggerSingleton.logError((Throwable)e1);
                    return;
                }
                AnalyticsTeam team = null;
                if (UploadSelectionDialog.this.teams != null && UploadSelectionDialog.this.teams.size() > 0) {
                    team = (AnalyticsTeam)UploadSelectionDialog.this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(UploadSelectionDialog.this.analyticsSettingStore, UploadSelectionDialog.this.teams));
                }
                if ((dialog = new NewProjectDialog(UploadSelectionDialog.this.btnCreate.getDisplay().getActiveShell(), (String)results.get("serverUrl"), (String)results.get("email"), (String)results.get("password"), team)).open() == 0 && (createdProject = dialog.getAnalyticsProject()) != null) {
                    try {
                        UploadSelectionDialog.this.analyticsSettingStore.setProject(createdProject);
                        UploadSelectionDialog.this.analyticsSettingStore.setTeam(team);
                        if (UploadSelectionDialog.this.projects == null) {
                            return;
                        }
                        UploadSelectionDialog.this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(UploadSelectionDialog.this.projects).toArray(new String[UploadSelectionDialog.this.projects.size()]));
                        UploadSelectionDialog.this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex(UploadSelectionDialog.this.analyticsSettingStore, UploadSelectionDialog.this.projects));
                    }
                    catch (IOException ex) {
                        LoggerSingleton.logError((Throwable)ex);
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                    }
                }
                UploadSelectionDialog.this.fillData();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.cancelPressed();
            }
        });
        this.cbbTeams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadSelectionDialog.this.cbbProjects.setItems(new String[0]);
                if (((AnalyticsTeam)UploadSelectionDialog.this.teams.get(UploadSelectionDialog.this.cbbTeams.getSelectionIndex())).getRole().equals("USER")) {
                    UploadSelectionDialog.this.btnCreate.setEnabled(false);
                } else {
                    UploadSelectionDialog.this.btnCreate.setEnabled(true);
                }
                try {
                    UploadSelectionDialog.this.analyticsSettingStore.setTeam((AnalyticsTeam)UploadSelectionDialog.this.teams.get(UploadSelectionDialog.this.cbbTeams.getSelectionIndex()));
                    AnalyticsTeam team = (AnalyticsTeam)UploadSelectionDialog.this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(UploadSelectionDialog.this.analyticsSettingStore, UploadSelectionDialog.this.teams));
                    HashMap info = null;
                    try {
                        info = UploadSelectionDialog.this.getInfo(UploadSelectionDialog.this.analyticsSettingStore.isEncryptionEnabled());
                    }
                    catch (IOException e1) {
                        LoggerSingleton.logError((Throwable)e1);
                        return;
                    }
                    String serverUrl = (String)info.get("serverUrl");
                    String email = (String)info.get("email");
                    String password = (String)info.get("password");
                    AnalyticsTokenInfo tokenInfo = AnalyticsAuthorizationHandler.getToken(serverUrl, email, password, UploadSelectionDialog.this.analyticsSettingStore);
                    UploadSelectionDialog.this.projects = AnalyticsAuthorizationHandler.getProjects(serverUrl, email, password, team, tokenInfo, new ProgressMonitorDialog(UploadSelectionDialog.this.getShell()));
                    UploadSelectionDialog.this.setProjectsBasedOnTeam(UploadSelectionDialog.this.teams, UploadSelectionDialog.this.projects);
                }
                catch (IOException ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)ComposerAnalyticsStringConstants.ERROR, (String)ex.getMessage());
                }
            }
        });
    }

    private void setProjectsBasedOnTeam(List<AnalyticsTeam> teams, List<AnalyticsProject> projects) {
        if (projects != null && !projects.isEmpty()) {
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(projects).toArray(new String[projects.size()]));
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex(this.analyticsSettingStore, projects));
        }
    }

    private HashMap<String, String> getInfo(boolean encryptionEnabled) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            results.put("serverUrl", this.analyticsSettingStore.getServerEndpoint(encryptionEnabled));
            results.put("email", this.analyticsSettingStore.getEmail(encryptionEnabled));
            results.put("password", this.analyticsSettingStore.getPassword(encryptionEnabled));
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
            return null;
        }
        return results;
    }

    private void fillData() {
        try {
            this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(this.teams).toArray(new String[this.teams.size()]));
            this.cbbTeams.select(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, this.teams));
            this.setProjectsBasedOnTeam(this.teams, this.projects);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.SELECTION_DIALOG_TITLE);
    }

    private void closeDialog() {
        this.close();
    }

    protected boolean isResizable() {
        return true;
    }

    private void handleUpload() {
        try {
            AnalyticsTeam team = null;
            if (this.teams != null && this.teams.size() > 0) {
                team = this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex(this.analyticsSettingStore, this.teams));
            }
            this.analyticsSettingStore.setTeam(team);
            this.analyticsSettingStore.setProject(this.cbbProjects.getSelectionIndex() != -1 ? this.projects.get(this.cbbProjects.getSelectionIndex()) : null);
        }
        catch (IOException e1) {
            LoggerSingleton.logError((Throwable)e1);
        }
        this.setReturnCode(2);
        this.closeDialog();
    }
}

